/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.validation;

import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.common.reflect.ReflectionHelper;
import org.jbpm.form.builder.ng.model.shared.api.RepresentationFactory;

public abstract class FBValidationItem {
    private final Map<String, HasValue<String>> propertiesMap = new HashMap<String, HasValue<String>>();

    public Map<String, HasValue<String>> getPropertiesMap() {
        return this.propertiesMap;
    }

    public void populatePropertiesMap(Map<String, HasValue<String>> map) {
        this.propertiesMap.putAll(map);
    }

    public Map<String, Object> getDataMap() {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        for (Map.Entry<String, HasValue<String>> entry : this.propertiesMap.entrySet()) {
            dataMap.put(entry.getKey(), entry.getValue().getValue());
        }
        return dataMap;
    }

    public abstract String getName();

    public abstract Widget createDisplay();

    public abstract FBValidationItem cloneItem();

    public abstract void setDataMap(Map<String, Object> var1) throws FormBuilderException;

    public static FBValidationItem createValidation(Map<String, Object> validationMap) throws FormBuilderException {
        try {
            String repClassName = (String)validationMap.get("@className");
            String className = RepresentationFactory.getItemClassName(repClassName);
            Object obj = ReflectionHelper.newInstance(className);
            FBValidationItem item = (FBValidationItem)obj;
            item.setDataMap(validationMap);
            return item;
        }
        catch (Exception e) {
            throw new FormBuilderException(e);
        }
    }

    public boolean canValidateOnClient() {
        return false;
    }

    public boolean isValid(Object object) {
        return true;
    }
}

