/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.common.handler;

import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.common.handler.ControlKeyHandler;
import org.jbpm.form.builder.ng.model.common.handler.RightClickEvent;
import org.jbpm.form.builder.ng.model.common.handler.RightClickHandler;

public class EventHelper {
    private static final Map<Widget, List<RightClickHandler>> RCLICK_HANDLERS = new HashMap<Widget, List<RightClickHandler>>();
    private static final Map<Widget, List<ControlKeyHandler>> KCUT_HANDLERS = new HashMap<Widget, List<ControlKeyHandler>>();
    private static final Map<Widget, List<ControlKeyHandler>> KCOPY_HANDLERS = new HashMap<Widget, List<ControlKeyHandler>>();
    private static final Map<Widget, List<ControlKeyHandler>> KPASTE_HANDLERS = new HashMap<Widget, List<ControlKeyHandler>>();
    private static final Map<Widget, List<BlurHandler>> BLUR_HANDLERS = new HashMap<Widget, List<BlurHandler>>();
    private static final Map<Widget, List<FocusHandler>> FOCUS_HANDLERS = new HashMap<Widget, List<FocusHandler>>();

    public static HandlerRegistration addBlurHandler(Widget widget, final BlurHandler handler) {
        widget.sinkEvents(4096);
        List<BlurHandler> handlers = BLUR_HANDLERS.get(widget);
        if (handlers == null) {
            handlers = new ArrayList<BlurHandler>();
            BLUR_HANDLERS.put(widget, handlers);
        }
        handlers.add(handler);
        final List<BlurHandler> _handlers = handlers;
        return new HandlerRegistration(){

            public void removeHandler() {
                _handlers.remove(handler);
            }
        };
    }

    public static HandlerRegistration addFocusHandler(Widget widget, final FocusHandler handler) {
        widget.sinkEvents(2048);
        List<FocusHandler> handlers = FOCUS_HANDLERS.get(widget);
        if (handlers == null) {
            handlers = new ArrayList<FocusHandler>();
            FOCUS_HANDLERS.put(widget, handlers);
        }
        handlers.add(handler);
        final List<FocusHandler> _handlers = handlers;
        return new HandlerRegistration(){

            public void removeHandler() {
                _handlers.remove(handler);
            }
        };
    }

    public static HandlerRegistration addRightClickHandler(Widget widget, final RightClickHandler handler) {
        widget.sinkEvents(262154);
        List<RightClickHandler> handlers = RCLICK_HANDLERS.get(widget);
        if (handlers == null) {
            handlers = new ArrayList<RightClickHandler>();
            RCLICK_HANDLERS.put(widget, handlers);
        }
        handlers.add(handler);
        final List<RightClickHandler> _handlers = handlers;
        return new HandlerRegistration(){

            public void removeHandler() {
                _handlers.remove(handler);
            }
        };
    }

    public static HandlerRegistration addKeyboardPasteHandler(Widget widget, final ControlKeyHandler handler) {
        widget.sinkEvents(256);
        List<ControlKeyHandler> handlers = KPASTE_HANDLERS.get(widget);
        if (handlers == null) {
            handlers = new ArrayList<ControlKeyHandler>();
            KPASTE_HANDLERS.put(widget, handlers);
        }
        handlers.add(handler);
        final List<ControlKeyHandler> _handlers = handlers;
        return new HandlerRegistration(){

            public void removeHandler() {
                _handlers.remove(handler);
            }
        };
    }

    public static HandlerRegistration addKeyboardCutHandler(Widget widget, final ControlKeyHandler handler) {
        widget.sinkEvents(256);
        List<ControlKeyHandler> handlers = KCUT_HANDLERS.get(widget);
        if (handlers == null) {
            handlers = new ArrayList<ControlKeyHandler>();
            KCUT_HANDLERS.put(widget, handlers);
        }
        handlers.add(handler);
        final List<ControlKeyHandler> _handlers = handlers;
        return new HandlerRegistration(){

            public void removeHandler() {
                _handlers.remove(handler);
            }
        };
    }

    public static HandlerRegistration addKeyboardCopyHandler(Widget widget, final ControlKeyHandler handler) {
        widget.sinkEvents(256);
        List<ControlKeyHandler> handlers = KCOPY_HANDLERS.get(widget);
        if (handlers == null) {
            handlers = new ArrayList<ControlKeyHandler>();
            KCOPY_HANDLERS.put(widget, handlers);
        }
        handlers.add(handler);
        final List<ControlKeyHandler> _handlers = handlers;
        return new HandlerRegistration(){

            public void removeHandler() {
                _handlers.remove(handler);
            }
        };
    }

    public static void onBrowserEvent(Widget widget, Event event) {
        switch (DOM.eventGetType((Event)event)) {
            case 2: 
            case 8: 
            case 262144: {
                EventHelper.onRightClickEvent(widget, event);
                break;
            }
            case 256: {
                EventHelper.onKeyEvent(widget, event);
                break;
            }
            case 4096: {
                EventHelper.onBlurEvent(widget, event);
            }
            case 2048: {
                EventHelper.onFocusEvent(widget, event);
            }
        }
    }

    protected static void onBlurEvent(final Widget widget, Event event) {
        BlurEvent bevent = new BlurEvent(){

            public Object getSource() {
                return widget;
            }
        };
        bevent.setNativeEvent((NativeEvent)event);
        List<BlurHandler> handlers = BLUR_HANDLERS.get(widget);
        if (handlers != null) {
            for (BlurHandler handler : handlers) {
                handler.onBlur(bevent);
            }
        }
    }

    protected static void onFocusEvent(final Widget widget, Event event) {
        FocusEvent fevent = new FocusEvent(){

            public Object getSource() {
                return widget;
            }
        };
        fevent.setNativeEvent((NativeEvent)event);
        List<FocusHandler> handlers = FOCUS_HANDLERS.get(widget);
        if (handlers != null) {
            for (FocusHandler handler : handlers) {
                handler.onFocus(fevent);
            }
        }
    }

    protected static void onRightClickEvent(final Widget widget, Event event) {
        switch (DOM.eventGetType((Event)event)) {
            case 8: {
                List<RightClickHandler> rclickHandlers;
                event.stopPropagation();
                event.preventDefault();
                if (DOM.eventGetButton((Event)event) == 1) {
                    ClickEvent cevent = new ClickEvent(){

                        public Object getSource() {
                            return widget;
                        }
                    };
                    cevent.setNativeEvent((NativeEvent)event);
                    widget.fireEvent((GwtEvent)cevent);
                    break;
                }
                if (DOM.eventGetButton((Event)event) != 2 || (rclickHandlers = RCLICK_HANDLERS.get(widget)) == null) break;
                RightClickEvent rcevent = new RightClickEvent(event);
                for (RightClickHandler handler : rclickHandlers) {
                    handler.onRightClick(rcevent);
                }
                break;
            }
            case 2: {
                event.stopPropagation();
                event.preventDefault();
                break;
            }
            case 262144: {
                event.stopPropagation();
                event.preventDefault();
                break;
            }
        }
    }

    protected static void onKeyEvent(Widget widget, Event event) {
        List<ControlKeyHandler> handlers = null;
        block0 : switch (DOM.eventGetType((Event)event)) {
            case 256: {
                if (!event.getCtrlKey()) break;
                switch (event.getCharCode()) {
                    case 67: 
                    case 99: {
                        event.stopPropagation();
                        event.preventDefault();
                        handlers = KCOPY_HANDLERS.get(widget);
                        break block0;
                    }
                    case 88: 
                    case 120: {
                        event.stopPropagation();
                        event.preventDefault();
                        handlers = KCUT_HANDLERS.get(widget);
                        break block0;
                    }
                    case 86: 
                    case 118: {
                        event.stopPropagation();
                        event.preventDefault();
                        handlers = KPASTE_HANDLERS.get(widget);
                        break block0;
                    }
                }
                break;
            }
        }
        if (handlers != null) {
            for (ControlKeyHandler handler : handlers) {
                handler.onKeyboardControl();
            }
        }
    }
}

