/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.common.panels;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

public class ListWidget
extends Widget
implements Focusable {
    private final UListElement element = Document.get().createULElement();

    public ListWidget() {
        this.setElement((Element)this.element);
    }

    public void addItem(String item) {
        LIElement liElem = Document.get().createLIElement();
        liElem.setInnerHTML(item);
        this.element.appendChild((Node)liElem);
    }

    public List<String> getItems() {
        ArrayList<String> items = new ArrayList<String>();
        for (int index = 0; index < this.element.getChildCount(); ++index) {
            Element elem = Element.as((Node)this.element.getChild(index));
            items.add(elem.getInnerHTML());
        }
        return items;
    }

    public void removeItem(String item) {
        for (int index = 0; index < this.element.getChildCount(); ++index) {
            Node child = this.element.getChild(index);
            Element elemChild = Element.as((Node)child);
            String elemHTML = elemChild.getInnerHTML();
            if (elemHTML == null || !elemHTML.equals(item)) continue;
            this.removeItem(index);
            break;
        }
    }

    public void removeItem(int index) {
        if (index < this.element.getChildCount()) {
            this.element.removeChild(this.element.getChild(index));
        }
    }

    public void setScrollTop(int scrollTop) {
        this.element.setScrollTop(scrollTop);
    }

    public int getScrollTop() {
        return this.element.getScrollTop();
    }

    public void setId(String id) {
        this.element.setId(id);
    }

    public String getId() {
        return this.element.getId();
    }

    public void setScrollLeft(int scrollLeft) {
        this.element.setScrollLeft(scrollLeft);
    }

    public int getScrollLeft() {
        return this.element.getScrollLeft();
    }

    public void setDir(String dir) {
        this.element.setDir(dir);
    }

    public String getDir() {
        return this.element.getDir();
    }

    public int getTabIndex() {
        return this.element.getTabIndex();
    }

    public void setTabIndex(int index) {
        this.element.setTabIndex(index);
    }

    public void setAccessKey(char key) {
        this.setAccessKey((Element)this.element, key);
    }

    public native void setAccessKey(Element var1, char var2);

    public void setFocus(boolean focused) {
        if (focused) {
            this.element.focus();
        } else {
            this.element.blur();
        }
    }
}

