/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.common.panels;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.form.builder.ng.model.common.handler.ResizeEvent;
import org.jbpm.form.builder.ng.model.common.handler.ResizeEventHandler;

public class ResizablePanel
extends SimplePanel {
    private List<ResizeEventHandler> resizeHandlers = new ArrayList<ResizeEventHandler>();
    private boolean dragAndDropBegin = false;
    private final Widget widget;
    private final Grid grid = new Grid(3, 3);

    public ResizablePanel(Widget widget, int initialWidth, int initialHeight) {
        this.widget = widget;
        this.grid.setBorderWidth(0);
        this.grid.setCellPadding(0);
        this.grid.setCellSpacing(0);
        this.sinkEvents(124);
        this.makeGrid();
        this.setWidget((Widget)this.grid);
        this.setSize("" + initialWidth + "px", "" + initialHeight + "px");
    }

    private void makeGrid() {
        this.grid.getCellFormatter().addStyleName(0, 0, "northwestCorner");
        this.grid.setHTML(0, 0, "");
        this.grid.getCellFormatter().addStyleName(0, 1, "horizontalLine");
        this.grid.setHTML(0, 1, "");
        this.grid.getCellFormatter().addStyleName(0, 2, "northeastCorner");
        this.grid.setHTML(0, 2, "");
        this.grid.getCellFormatter().addStyleName(1, 0, "verticalLine");
        this.grid.setHTML(1, 0, "");
        this.grid.setWidget(1, 1, this.widget);
        this.grid.getCellFormatter().addStyleName(1, 2, "verticalLine");
        this.grid.setHTML(1, 2, "");
        this.grid.getCellFormatter().addStyleName(2, 0, "southwestCorner");
        this.grid.setHTML(2, 0, "");
        this.grid.getCellFormatter().addStyleName(2, 1, "horizontalLine");
        this.grid.setHTML(2, 1, "");
        this.grid.getCellFormatter().addStyleName(2, 2, "smallButton");
        this.grid.setHTML(2, 2, "");
    }

    public void onBrowserEvent(Event event) {
        event.stopPropagation();
        event.preventDefault();
        switch (DOM.eventGetType((Event)event)) {
            case 16: {
                DOM.setStyleAttribute((Element)this.getElement(), (String)"cursor", (String)(this.isInPosition(event) ? "se-resize" : "default"));
                break;
            }
            case 32: {
                DOM.setStyleAttribute((Element)this.getElement(), (String)"cursor", (String)"default");
                break;
            }
            case 4: {
                if (this.dragAndDropBegin) break;
                this.dragAndDropBegin = true;
                DOM.setCapture((Element)this.getElement());
                break;
            }
            case 64: {
                if (!this.dragAndDropBegin) break;
                int absX = DOM.eventGetClientX((Event)event);
                int absY = DOM.eventGetClientY((Event)event);
                int originalX = DOM.getAbsoluteLeft((Element)this.getElement());
                int originalY = DOM.getAbsoluteTop((Element)this.getElement());
                if (absY <= originalY || absX <= originalX) break;
                Integer height = absY - originalY + 2;
                Integer width = absX - originalX + 2;
                this.setSize(width, height);
                break;
            }
            case 8: {
                if (!this.dragAndDropBegin) break;
                this.dragAndDropBegin = false;
                DOM.releaseCapture((Element)this.getElement());
                this.notifyResize();
            }
        }
    }

    public boolean isInPosition(Event event) {
        int xCursor = DOM.eventGetClientX((Event)event);
        int yCursor = DOM.eventGetClientY((Event)event);
        int east = this.getAbsoluteLeft() + this.getOffsetWidth();
        int west = east - 10;
        int south = this.getAbsoluteTop() + this.getOffsetHeight();
        int north = south - 10;
        boolean isInWidth = xCursor > west && xCursor < east;
        boolean isInHeight = yCursor > north && yCursor < south;
        return isInWidth && isInHeight;
    }

    public void setSize(int width, int height) {
        int realHeight = height - 20;
        int realWidth = width - 20;
        if (realHeight > 0 && realWidth > 0) {
            this.widget.setSize("" + realWidth + "px", "" + realHeight + "px");
            super.setSize("" + width + "px", "" + height + "px");
        }
    }

    protected void notifyResize() {
        int width = this.widget.getOffsetWidth();
        int height = this.widget.getOffsetHeight();
        ResizeEvent event = new ResizeEvent(this.widget, width, height);
        for (ResizeEventHandler handler : this.resizeHandlers) {
            handler.onResize(event);
        }
    }

    public void addResizeHandler(ResizeEventHandler resizeHandler) {
        if (!this.resizeHandlers.contains(resizeHandler)) {
            this.resizeHandlers.add(resizeHandler);
        }
    }
}

