/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.shared.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.common.reflect.ReflectionHelper;
import org.jbpm.form.builder.ng.model.shared.api.FBScriptHelper;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

public class FBScript {
    private String documentation;
    private String id;
    private List<FBScriptHelper> helpers;
    private String type;
    private String src;
    private String content;
    private String invokeFunction;

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public String getContent() {
        if (this.helpers != null && !this.helpers.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (FBScriptHelper helper : this.helpers) {
                String asScriptContent = helper.asScriptContent();
                asScriptContent = asScriptContent.replaceAll("\"", "\\\"").replaceAll("\n", "");
                sb.append(asScriptContent);
            }
            return sb.toString();
        }
        return this.content;
    }

    public void setHelpers(List<FBScriptHelper> helpers) {
        this.helpers = helpers;
    }

    public List<FBScriptHelper> getHelpers() {
        return this.helpers;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getInvokeFunction() {
        return this.invokeFunction;
    }

    public void setInvokeFunction(String invokeFunction) {
        this.invokeFunction = invokeFunction;
    }

    public Map<String, Object> getDataMap() {
        FormBuilderDTO dto = new FormBuilderDTO();
        dto.setString("@className", this.getClass().getName());
        dto.setString("documentation", this.documentation);
        dto.setString("id", this.id);
        dto.setString("type", this.type);
        dto.setString("src", this.src);
        dto.setString("content", this.content);
        if (this.getHelpers() != null) {
            ArrayList<Object> helpersMap = new ArrayList<Object>();
            for (FBScriptHelper helper : this.getHelpers()) {
                helpersMap.add(helper.getDataMap());
            }
            dto.setList("helpers", helpersMap);
        }
        dto.setString("invokeFunction", this.invokeFunction);
        return dto.getParameters();
    }

    public void setDataMap(Map<String, Object> dataMap) throws FormBuilderException {
        FormBuilderDTO dto = new FormBuilderDTO(dataMap);
        this.documentation = dto.getString("documentation");
        this.id = dto.getString("id");
        this.type = dto.getString("type");
        this.src = dto.getString("src");
        this.content = dto.getString("content");
        this.invokeFunction = dto.getString("invokeFunction");
        List<Object> helpersMap = dto.getList("helpers");
        if (helpersMap != null) {
            ArrayList<FBScriptHelper> myHelpers = new ArrayList<FBScriptHelper>();
            for (Object obj : helpersMap) {
                try {
                    Map helperMap = (Map)obj;
                    String helperClass = (String)helperMap.get("@className");
                    FBScriptHelper helper = (FBScriptHelper)ReflectionHelper.newInstance(helperClass);
                    helper.setDataMap(helperMap);
                }
                catch (Exception e) {
                    throw new FormBuilderException("Problem creating helper " + obj, e);
                }
            }
            this.setHelpers(myHelpers);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        result = 31 * result + (this.documentation == null ? 0 : this.documentation.hashCode());
        result = 31 * result + (this.helpers == null ? 0 : ((Object)this.helpers).hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.invokeFunction == null ? 0 : this.invokeFunction.hashCode());
        result = 31 * result + (this.src == null ? 0 : this.src.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FBScript other = (FBScript)obj;
        if (this.content == null ? other.content != null : !this.content.equals(other.content)) {
            return false;
        }
        if (this.documentation == null ? other.documentation != null : !this.documentation.equals(other.documentation)) {
            return false;
        }
        if (this.helpers == null ? other.helpers != null : !((Object)this.helpers).equals(other.helpers)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.invokeFunction == null ? other.invokeFunction != null : !this.invokeFunction.equals(other.invokeFunction)) {
            return false;
        }
        if (this.src == null ? other.src != null : !this.src.equals(other.src)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

