/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.shared.api;

import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
@Reflectable
public class FormBuilderDTO {
    private Map<String, Object> parameters = new HashMap<String, Object>();

    public FormBuilderDTO() {
    }

    public FormBuilderDTO(Map<String, Object> parameters) {
        this();
        this.parameters = parameters;
    }

    public String getString(String key) {
        Object obj = this.parameters.get(key);
        return obj == null ? null : String.valueOf(obj);
    }

    public void setString(String key, String value) {
        this.parameters.put(key, value);
    }

    public List<Object> getList(String key) {
        Object obj = this.parameters.get(key);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Map)) {
            throw new IllegalArgumentException("parameter['" + key + "'] should be a map");
        }
        Map subMap = (Map)obj;
        ArrayList<Object> retval = new ArrayList<Object>(subMap.size());
        ArrayList keys = new ArrayList(subMap.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Integer.valueOf(o1).compareTo(Integer.valueOf(o2));
            }
        });
        for (String subKey : keys) {
            retval.add(subMap.get(subKey));
        }
        return retval;
    }

    public void setList(String key, List<Object> value) {
        HashMap<String, Object> subMap = new HashMap<String, Object>();
        int index = 0;
        for (Object item : value) {
            subMap.put(String.valueOf(index), item);
            ++index;
        }
    }

    public List<FormBuilderDTO> getListOfDtos(String key) {
        List<Object> objs = this.getList(key);
        if (objs == null) {
            return null;
        }
        ArrayList<FormBuilderDTO> retval = new ArrayList<FormBuilderDTO>(objs.size());
        for (Object obj : objs) {
            if (obj == null) {
                retval.add(null);
                continue;
            }
            if (obj instanceof Map) {
                Map item = (Map)obj;
                retval.add(new FormBuilderDTO(item));
                continue;
            }
            throw new IllegalArgumentException("parameter['" + key + "'] subitems should be a map but it is of type " + obj.getClass().getName());
        }
        return retval;
    }

    public Map<String, Object> getMap(String key) {
        Object obj = this.parameters.get(key);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Map)) {
            throw new IllegalArgumentException("parameter['" + key + "'] should be a map");
        }
        return (Map)obj;
    }

    public void setMap(String key, Map<String, Object> value) {
        this.parameters.put(key, value);
    }

    public FormBuilderDTO getSubDto(String key) {
        return new FormBuilderDTO(this.getMap(key));
    }

    public String getClassName() {
        return this.getString("@className");
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setInteger(String key, Integer value) {
        this.parameters.put(key, value == null ? null : String.valueOf(value));
    }

    public Integer getInteger(String key) {
        String val = this.getString(key);
        return val == null ? null : Integer.valueOf(val);
    }

    public void setBoolean(String key, Boolean value) {
        this.parameters.put(key, value == null ? null : String.valueOf(value));
    }

    public Boolean getBoolean(String key) {
        String val = this.getString(key);
        return val == null ? null : Boolean.valueOf(val);
    }

    public void setLong(String key, Long value) {
        this.parameters.put(key, value == null ? null : String.valueOf(value));
    }

    public Long getLong(String key) {
        String val = this.getString(key);
        return val == null ? null : Long.valueOf(this.getString(key));
    }

    public void setDouble(String key, Double value) {
        this.parameters.put(key, value == null ? null : String.valueOf(value));
    }

    public Double getDouble(String key) {
        String val = this.getString(key);
        return val == null ? null : Double.valueOf(this.getString(key));
    }

    public void setMapOfStrings(String key, Map<String, String> value) {
        HashMap<String, String> transValue = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : value.entrySet()) {
            transValue.put(entry.getKey(), entry.getValue());
        }
        this.parameters.put(key, transValue);
    }

    public Map<String, String> getMapOfStrings(String key) {
        Map<String, Object> value = this.getMap(key);
        HashMap<String, String> transValue = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            transValue.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return transValue;
    }
}

