/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.shared.menu.items;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuItem;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.bus.UndoableEvent;
import org.jbpm.form.builder.ng.model.client.bus.UndoableHandler;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.menu.FBMenuItem;
import org.jbpm.form.builder.ng.model.client.resources.FormBuilderResources;
import org.jbpm.form.builder.ng.model.common.panels.CommandPopupPanel;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;
import org.jbpm.form.builder.ng.model.shared.menu.items.ErrorMenuItem;

@Reflectable
public class CustomMenuItem
extends FBMenuItem {
    private String optionName;
    private FormBuilderDTO representation;
    private String groupName;
    private String iconUrlAsString;

    public CustomMenuItem() {
        this(null, null, new ArrayList<FBFormEffect>(), null);
    }

    public CustomMenuItem(FormBuilderDTO representation, String optionName, List<FBFormEffect> formEffects, String groupName) {
        super(formEffects);
        this.representation = representation;
        this.optionName = optionName;
        this.groupName = groupName;
        this.sinkEvents(262154);
        this.repaint();
    }

    public void onBrowserEvent(Event event) {
        event.stopPropagation();
        event.preventDefault();
        switch (DOM.eventGetType((Event)event)) {
            case 8: {
                if (DOM.eventGetButton((Event)event) == 1) {
                    ClickEvent evt = new ClickEvent(){

                        public Object getSource() {
                            return CustomMenuItem.this;
                        }
                    };
                    evt.setNativeEvent((NativeEvent)event);
                    this.fireEvent((GwtEvent)evt);
                    super.onBrowserEvent(event);
                    break;
                }
                if (DOM.eventGetButton((Event)event) != 2) break;
                final CommandPopupPanel removePanel = new CommandPopupPanel(true);
                MenuItem removeItem = new MenuItem(CommonGlobals.getInstance().getI18n().RemoveMenuItem(), (Scheduler.ScheduledCommand)new Command(){

                    public void execute() {
                        HashMap<String, Object> dataSnapshot = new HashMap<String, Object>();
                        dataSnapshot.put("menuItem", (Object)CustomMenuItem.this);
                        dataSnapshot.put("groupName", CustomMenuItem.this.groupName);
                        EventBus bus = CommonGlobals.getInstance().getEventBus();
                        bus.fireEvent((GwtEvent)new UndoableEvent(dataSnapshot, new UndoableHandler(){

                            @Override
                            public void onEvent(UndoableEvent event) {
                            }

                            @Override
                            public void undoAction(UndoableEvent event) {
                                FBMenuItem item = (FBMenuItem)((Object)event.getData("menuItem"));
                                String group = (String)event.getData("groupName");
                            }

                            @Override
                            public void doAction(UndoableEvent event) {
                                FBMenuItem item = (FBMenuItem)((Object)event.getData("menuItem"));
                                String group = (String)event.getData("groupName");
                            }
                        }));
                        removePanel.hide();
                    }
                });
                removePanel.addItem(removeItem);
                removePanel.setPopupPosition(event.getClientX(), event.getClientY());
                removePanel.show();
                break;
            }
            case 2: {
                break;
            }
            case 262144: {
                break;
            }
        }
    }

    public String getOptionName() {
        return this.optionName;
    }

    public FormBuilderDTO getRepresentation() {
        return this.representation;
    }

    public void setRepresentation(FormBuilderDTO representation) {
        this.representation = representation;
    }

    public void setOptionName(String optionName) {
        this.optionName = optionName;
        this.repaint();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Override
    protected String getIconUrlAsString() {
        return this.iconUrlAsString;
    }

    public void setIconUrlAsString(String iconUrlAsString) {
        this.iconUrlAsString = iconUrlAsString;
    }

    @Override
    protected ImageResource getIconUrl() {
        return FormBuilderResources.INSTANCE.questionIcon();
    }

    @Override
    public Label getDescription() {
        return new Label(this.optionName);
    }

    @Override
    public FBMenuItem cloneWidget() {
        CustomMenuItem customItem = new CustomMenuItem(this.representation, this.optionName, new ArrayList<FBFormEffect>(this.getFormEffects()), this.groupName);
        customItem.setIconUrlAsString(this.iconUrlAsString);
        customItem.repaint();
        return this.clone(customItem);
    }

    @Override
    public void addEffect(FBFormEffect effect) {
        super.addEffect(effect);
    }

    @Override
    public FBFormItem buildWidget() {
        try {
            FBFormItem item = FBFormItem.createItem(this.representation);
            return this.build(item);
        }
        catch (FormBuilderException e) {
            return new ErrorMenuItem(e.getLocalizedMessage()).buildWidget();
        }
    }

    @Override
    public String getItemId() {
        return this.groupName + ":" + this.optionName;
    }
}

