/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.emfextmodel;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.jboss.drools.DocumentRoot;
import org.jboss.drools.DroolsFactory;
import org.jboss.drools.DroolsPackage;
import org.jboss.drools.GlobalType;
import org.jboss.drools.ImportType;
import org.jboss.drools.MetaDataType;
import org.jboss.drools.OnEntryScriptType;
import org.jboss.drools.OnExitScriptType;
import org.jboss.drools.util.DroolsResourceFactoryImpl;

public class BPMN2EmfExtTest
extends TestCase {
    private ResourceSet resourceSet;

    protected void setUp() throws Exception {
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new DroolsResourceFactoryImpl());
        this.resourceSet.getPackageRegistry().put((Object)"http://www.jboss.org/drools", (Object)DroolsPackage.eINSTANCE);
    }

    protected void tearDown() throws Exception {
    }

    public void testMetadataElement() throws Exception {
        XMLResource inResource = (XMLResource)this.resourceSet.createResource(URI.createURI((String)"inputStream://dummyUriWithValidSuffix.xml"));
        inResource.getDefaultLoadOptions().put("ENCODING", "UTF-8");
        inResource.setEncoding("UTF-8");
        DocumentRoot documentRoot = DroolsFactory.eINSTANCE.createDocumentRoot();
        MetaDataType metadataType = DroolsFactory.eINSTANCE.createMetaDataType();
        metadataType.setName("testvalue");
        metadataType.setMetaValue("testentry");
        documentRoot.setMetaData(metadataType);
        inResource.getContents().add((Object)documentRoot);
        StringWriter stringWriter = new StringWriter();
        inResource.save((Writer)stringWriter, null);
        BPMN2EmfExtTest.assertNotNull((Object)stringWriter.getBuffer().toString());
        if (stringWriter.getBuffer().toString().length() < 1) {
            BPMN2EmfExtTest.fail((String)"generated xml is empty");
        }
        XMLResource outResource = (XMLResource)this.resourceSet.createResource(URI.createURI((String)"inputStream://dummyUriWithValidSuffix.xml"));
        outResource.getDefaultLoadOptions().put("ENCODING", "UTF-8");
        outResource.setEncoding("UTF-8");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        ByteArrayInputStream is = new ByteArrayInputStream(stringWriter.getBuffer().toString().getBytes("UTF-8"));
        outResource.load((InputStream)is, options);
        DocumentRoot outRoot = (DocumentRoot)outResource.getContents().get(0);
        BPMN2EmfExtTest.assertNotNull((Object)outRoot.getMetaData());
        MetaDataType outMetadataType = outRoot.getMetaData();
        BPMN2EmfExtTest.assertEquals((String)outMetadataType.getName(), (String)"testvalue");
        BPMN2EmfExtTest.assertEquals((String)outMetadataType.getMetaValue(), (String)"testentry");
    }

    public void testOnEntryScriptElement() throws Exception {
        XMLResource inResource = (XMLResource)this.resourceSet.createResource(URI.createURI((String)"inputStream://dummyUriWithValidSuffix.xml"));
        inResource.getDefaultLoadOptions().put("ENCODING", "UTF-8");
        inResource.setEncoding("UTF-8");
        DocumentRoot documentRoot = DroolsFactory.eINSTANCE.createDocumentRoot();
        OnEntryScriptType root = DroolsFactory.eINSTANCE.createOnEntryScriptType();
        root.setScript("script");
        root.setScriptFormat("format");
        documentRoot.setOnEntryScript(root);
        inResource.getContents().add((Object)documentRoot);
        StringWriter stringWriter = new StringWriter();
        inResource.save((Writer)stringWriter, null);
        BPMN2EmfExtTest.assertNotNull((Object)stringWriter.getBuffer().toString());
        if (stringWriter.getBuffer().toString().length() < 1) {
            BPMN2EmfExtTest.fail((String)"generated xml is empty");
        }
        XMLResource outResource = (XMLResource)this.resourceSet.createResource(URI.createURI((String)"inputStream://dummyUriWithValidSuffix.xml"));
        outResource.getDefaultLoadOptions().put("ENCODING", "UTF-8");
        outResource.setEncoding("UTF-8");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        ByteArrayInputStream is = new ByteArrayInputStream(stringWriter.getBuffer().toString().getBytes("UTF-8"));
        outResource.load((InputStream)is, options);
        DocumentRoot outRoot = (DocumentRoot)outResource.getContents().get(0);
        BPMN2EmfExtTest.assertNotNull((Object)outRoot.getOnEntryScript());
        OnEntryScriptType scriptType = outRoot.getOnEntryScript();
        BPMN2EmfExtTest.assertEquals((String)"script", (String)scriptType.getScript());
        BPMN2EmfExtTest.assertEquals((String)"format", (String)scriptType.getScriptFormat());
    }

    public void testOnExitScriptElement() throws Exception {
        XMLResource inResource = (XMLResource)this.resourceSet.createResource(URI.createURI((String)"inputStream://dummyUriWithValidSuffix.xml"));
        inResource.getDefaultLoadOptions().put("ENCODING", "UTF-8");
        inResource.setEncoding("UTF-8");
        DocumentRoot documentRoot = DroolsFactory.eINSTANCE.createDocumentRoot();
        OnExitScriptType root = DroolsFactory.eINSTANCE.createOnExitScriptType();
        root.setScript("script");
        root.setScriptFormat("format");
        documentRoot.setOnExitScript(root);
        inResource.getContents().add((Object)documentRoot);
        StringWriter stringWriter = new StringWriter();
        inResource.save((Writer)stringWriter, null);
        BPMN2EmfExtTest.assertNotNull((Object)stringWriter.getBuffer().toString());
        if (stringWriter.getBuffer().toString().length() < 1) {
            BPMN2EmfExtTest.fail((String)"generated xml is empty");
        }
        XMLResource outResource = (XMLResource)this.resourceSet.createResource(URI.createURI((String)"inputStream://dummyUriWithValidSuffix.xml"));
        outResource.getDefaultLoadOptions().put("ENCODING", "UTF-8");
        outResource.setEncoding("UTF-8");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        ByteArrayInputStream is = new ByteArrayInputStream(stringWriter.getBuffer().toString().getBytes("UTF-8"));
        outResource.load((InputStream)is, options);
        DocumentRoot outRoot = (DocumentRoot)outResource.getContents().get(0);
        BPMN2EmfExtTest.assertNotNull((Object)outRoot.getOnExitScript());
        OnExitScriptType scriptType = outRoot.getOnExitScript();
        BPMN2EmfExtTest.assertEquals((String)"script", (String)scriptType.getScript());
        BPMN2EmfExtTest.assertEquals((String)"format", (String)scriptType.getScriptFormat());
    }

    public void testImportElement() throws Exception {
        XMLResource inResource = (XMLResource)this.resourceSet.createResource(URI.createURI((String)"inputStream://dummyUriWithValidSuffix.xml"));
        inResource.getDefaultLoadOptions().put("ENCODING", "UTF-8");
        inResource.setEncoding("UTF-8");
        DocumentRoot documentRoot = DroolsFactory.eINSTANCE.createDocumentRoot();
        ImportType root = DroolsFactory.eINSTANCE.createImportType();
        root.setName("import");
        documentRoot.setImport(root);
        inResource.getContents().add((Object)documentRoot);
        StringWriter stringWriter = new StringWriter();
        inResource.save((Writer)stringWriter, null);
        BPMN2EmfExtTest.assertNotNull((Object)stringWriter.getBuffer().toString());
        if (stringWriter.getBuffer().toString().length() < 1) {
            BPMN2EmfExtTest.fail((String)"generated xml is empty");
        }
        XMLResource outResource = (XMLResource)this.resourceSet.createResource(URI.createURI((String)"inputStream://dummyUriWithValidSuffix.xml"));
        outResource.getDefaultLoadOptions().put("ENCODING", "UTF-8");
        outResource.setEncoding("UTF-8");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        ByteArrayInputStream is = new ByteArrayInputStream(stringWriter.getBuffer().toString().getBytes("UTF-8"));
        outResource.load((InputStream)is, options);
        DocumentRoot outRoot = (DocumentRoot)outResource.getContents().get(0);
        BPMN2EmfExtTest.assertNotNull((Object)outRoot.getImport());
        ImportType importType = outRoot.getImport();
        BPMN2EmfExtTest.assertEquals((String)"import", (String)importType.getName());
    }

    public void testGlobalElement() throws Exception {
        XMLResource inResource = (XMLResource)this.resourceSet.createResource(URI.createURI((String)"inputStream://dummyUriWithValidSuffix.xml"));
        inResource.getDefaultLoadOptions().put("ENCODING", "UTF-8");
        inResource.setEncoding("UTF-8");
        DocumentRoot documentRoot = DroolsFactory.eINSTANCE.createDocumentRoot();
        GlobalType root = DroolsFactory.eINSTANCE.createGlobalType();
        root.setIdentifier("identifier");
        root.setType("type");
        documentRoot.setGlobal(root);
        inResource.getContents().add((Object)documentRoot);
        StringWriter stringWriter = new StringWriter();
        inResource.save((Writer)stringWriter, null);
        BPMN2EmfExtTest.assertNotNull((Object)stringWriter.getBuffer().toString());
        if (stringWriter.getBuffer().toString().length() < 1) {
            BPMN2EmfExtTest.fail((String)"generated xml is empty");
        }
        XMLResource outResource = (XMLResource)this.resourceSet.createResource(URI.createURI((String)"inputStream://dummyUriWithValidSuffix.xml"));
        outResource.getDefaultLoadOptions().put("ENCODING", "UTF-8");
        outResource.setEncoding("UTF-8");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        ByteArrayInputStream is = new ByteArrayInputStream(stringWriter.getBuffer().toString().getBytes("UTF-8"));
        outResource.load((InputStream)is, options);
        DocumentRoot outRoot = (DocumentRoot)outResource.getContents().get(0);
        BPMN2EmfExtTest.assertNotNull((Object)outRoot.getGlobal());
        GlobalType globalType = outRoot.getGlobal();
        BPMN2EmfExtTest.assertEquals((String)"identifier", (String)globalType.getIdentifier());
        BPMN2EmfExtTest.assertEquals((String)"type", (String)globalType.getType());
    }
}

