/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.backend.server;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.interceptor.Interceptors;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.seam.transaction.TransactionInterceptor;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.console.ng.bd.service.DataServiceEntryPoint;
import org.jbpm.console.ng.ht.backend.server.TaskDefHelper;
import org.jbpm.console.ng.ht.model.TaskDefSummary;
import org.jbpm.console.ng.pr.backend.server.NodeInstanceHelper;
import org.jbpm.console.ng.pr.backend.server.ProcessHelper;
import org.jbpm.console.ng.pr.backend.server.ProcessInstanceHelper;
import org.jbpm.console.ng.pr.backend.server.VariableHelper;
import org.jbpm.console.ng.pr.model.NodeInstanceSummary;
import org.jbpm.console.ng.pr.model.ProcessInstanceSummary;
import org.jbpm.console.ng.pr.model.ProcessSummary;
import org.jbpm.console.ng.pr.model.VariableSummary;
import org.jbpm.kie.services.api.RuntimeDataService;
import org.jbpm.kie.services.api.bpmn2.BPMN2DataService;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.kie.services.impl.model.ProcessInstanceDesc;

@Service
@ApplicationScoped
@Transactional
@Interceptors(value={TransactionInterceptor.class})
public class DataServiceEntryPointImpl
implements DataServiceEntryPoint {
    @Inject
    RuntimeDataService dataService;
    @Inject
    BPMN2DataService bpmn2Service;

    public Collection<ProcessInstanceSummary> getProcessInstances() {
        return ProcessInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstances());
    }

    public Collection<ProcessInstanceSummary> getProcessInstancesByDeploymentId(String deploymentId, List<Integer> states) {
        return ProcessInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstancesByDeploymentId(deploymentId, states));
    }

    public Collection<ProcessSummary> getProcessesByFilter(String filter) {
        return ProcessHelper.adaptCollection((Collection)this.dataService.getProcessesByFilter(filter));
    }

    public ProcessInstanceSummary getProcessInstanceById(long processInstanceId) {
        return ProcessInstanceHelper.adapt((ProcessInstanceDesc)this.dataService.getProcessInstanceById(processInstanceId));
    }

    public ProcessSummary getProcessById(String deploymentId, String processId) {
        return ProcessHelper.adapt((ProcessAssetDesc)this.dataService.getProcessesByDeploymentIdProcessId(deploymentId, processId));
    }

    public Collection<ProcessSummary> getProcesses() {
        return ProcessHelper.adaptCollection((Collection)this.dataService.getProcesses());
    }

    public Collection<ProcessInstanceSummary> getProcessInstancesByProcessDefinition(String processDefId) {
        return ProcessInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstancesByProcessDefinition(processDefId));
    }

    public Collection<NodeInstanceSummary> getProcessInstanceHistory(long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        return NodeInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstanceHistory(piDesc.getDeploymentId(), processInstanceId));
    }

    public Collection<NodeInstanceSummary> getProcessInstanceHistory(long processInstanceId, boolean completed) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        return NodeInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstanceHistory(piDesc.getDeploymentId(), processInstanceId, completed));
    }

    public Collection<NodeInstanceSummary> getProcessInstanceFullHistory(long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        return NodeInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstanceFullHistory(piDesc.getDeploymentId(), processInstanceId));
    }

    public Collection<NodeInstanceSummary> getProcessInstanceActiveNodes(long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        return NodeInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstanceActiveNodes(piDesc.getDeploymentId(), processInstanceId));
    }

    public Collection<ProcessInstanceSummary> getProcessInstances(List<Integer> states, String filterText, String initiator) {
        Collection result = null;
        result = !filterText.equals("") ? this.dataService.getProcessInstancesByProcessName(states, filterText, initiator) : this.dataService.getProcessInstances(states, initiator);
        return ProcessInstanceHelper.adaptCollection((Collection)result);
    }

    public Collection<NodeInstanceSummary> getProcessInstanceCompletedNodes(long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        return NodeInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstanceCompletedNodes(piDesc.getDeploymentId(), processInstanceId));
    }

    public Collection<VariableSummary> getVariableHistory(long processInstanceId, String variableId) {
        return VariableHelper.adaptCollection((Collection)this.dataService.getVariableHistory(processInstanceId, variableId));
    }

    public Collection<String> getReusableSubProcesses(String processId) {
        return this.bpmn2Service.getReusableSubProcesses(processId);
    }

    public List<String> getAssociatedDomainObjects(String processId) {
        return this.bpmn2Service.getAssociatedDomainObjects(processId);
    }

    public Map<String, String> getRequiredInputData(String processId) {
        return this.bpmn2Service.getProcessData(processId);
    }

    public List<String> getAssociatedForms(String processId) {
        return this.bpmn2Service.getAssociatedForms(processId);
    }

    public Collection<TaskDefSummary> getAllTasksDef(String processId) {
        return TaskDefHelper.adaptCollection((Collection)this.bpmn2Service.getAllTasksDef(processId));
    }

    public Map<String, String> getAssociatedEntities(String processId) {
        return this.bpmn2Service.getAssociatedEntities(processId);
    }

    public ProcessSummary getProcessDesc(String processId) {
        return ProcessHelper.adapt((ProcessAssetDesc)this.bpmn2Service.getProcessDesc(processId));
    }

    public Collection<VariableSummary> getVariablesCurrentState(long processInstanceId, String processId) {
        HashMap properties = new HashMap(this.bpmn2Service.getProcessData(processId));
        return VariableHelper.adaptCollection((Collection)this.dataService.getVariablesCurrentState(processInstanceId), properties, (long)processInstanceId);
    }

    public Map<String, String> getTaskInputMappings(String processId, String taskName) {
        return this.bpmn2Service.getTaskInputMappings(processId, taskName);
    }

    public Map<String, String> getTaskOutputMappings(String processId, String taskName) {
        return this.bpmn2Service.getTaskOutputMappings(processId, taskName);
    }
}

