/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.backend.server;

import java.util.ArrayList;
import java.util.List;
import org.droolsjbpm.services.domain.entities.Domain;
import org.droolsjbpm.services.domain.entities.Organization;
import org.droolsjbpm.services.domain.entities.RuntimeId;
import org.jbpm.console.ng.bd.model.DomainSummary;
import org.jbpm.console.ng.bd.model.OrganizationSummary;
import org.jbpm.console.ng.bd.model.RuntimeSummary;

public class DomainEntitiesHelper {
    public static List<DomainSummary> adaptDomainList(List<Domain> domains) {
        ArrayList<DomainSummary> domainSummaries = new ArrayList<DomainSummary>(domains.size());
        for (Domain domain : domains) {
            domainSummaries.add(DomainEntitiesHelper.adaptDomain(domain));
        }
        return domainSummaries;
    }

    public static DomainSummary adaptDomain(Domain domain) {
        return new DomainSummary(domain.getId(), domain.getName(), domain.getOrganization().getName(), DomainEntitiesHelper.adaptRuntimeList(domain.getRuntimes()));
    }

    public static List<RuntimeSummary> adaptRuntimeList(List<RuntimeId> runtimes) {
        ArrayList<RuntimeSummary> runtimeSummaries = new ArrayList<RuntimeSummary>(runtimes.size());
        for (RuntimeId runtime : runtimes) {
            runtimeSummaries.add(DomainEntitiesHelper.adaptRuntime(runtime));
        }
        return runtimeSummaries;
    }

    public static RuntimeSummary adaptRuntime(RuntimeId runtime) {
        return new RuntimeSummary(runtime.getId(), runtime.getName(), runtime.getReference(), runtime.getType());
    }

    public static List<OrganizationSummary> adaptOrganizationList(List<Organization> organizations) {
        ArrayList<OrganizationSummary> organizationSummaries = new ArrayList<OrganizationSummary>(organizations.size());
        for (Organization org : organizations) {
            organizationSummaries.add(DomainEntitiesHelper.adaptOrganization(org));
        }
        return organizationSummaries;
    }

    public static OrganizationSummary adaptOrganization(Organization organization) {
        return new OrganizationSummary(organization.getId(), organization.getName(), DomainEntitiesHelper.adaptDomainList(organization.getDomains()));
    }
}

