/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.backend.server;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.droolsjbpm.services.api.DomainManagerService;
import org.droolsjbpm.services.domain.entities.Domain;
import org.droolsjbpm.services.domain.entities.Organization;
import org.droolsjbpm.services.domain.entities.RuntimeId;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.console.ng.bd.backend.server.DomainEntitiesHelper;
import org.jbpm.console.ng.bd.model.DomainSummary;
import org.jbpm.console.ng.bd.model.OrganizationSummary;
import org.jbpm.console.ng.bd.model.RuntimeSummary;
import org.jbpm.console.ng.bd.service.DomainManagerServiceEntryPoint;

@Service
@ApplicationScoped
@Transactional
public class DomainManagerServiceEntryPointImpl
implements DomainManagerServiceEntryPoint {
    @Inject
    private DomainManagerService domainManager;

    public List<OrganizationSummary> getAllOrganizations() {
        return DomainEntitiesHelper.adaptOrganizationList(this.domainManager.getAllOrganizations());
    }

    public void removeOrganization(long organizationId) {
        this.domainManager.removeOrganization(organizationId);
    }

    public OrganizationSummary getOrganizationById(long organizationId) {
        return DomainEntitiesHelper.adaptOrganization(this.domainManager.getOrganizationById(organizationId));
    }

    public DomainSummary getDomainById(long domainId) {
        return DomainEntitiesHelper.adaptDomain(this.domainManager.getDomainById(domainId));
    }

    public List<DomainSummary> getAllDomains() {
        return DomainEntitiesHelper.adaptDomainList(this.domainManager.getAllDomains());
    }

    public List<DomainSummary> getAllDomainsByOrganization(long organizationId) {
        return DomainEntitiesHelper.adaptDomainList(this.domainManager.getAllDomainsByOrganization(organizationId));
    }

    public DomainSummary getDomainByName(String domainName) {
        return DomainEntitiesHelper.adaptDomain(this.domainManager.getDomainByName(domainName));
    }

    public void removeDomain(long domainId) {
        this.domainManager.removeDomain(domainId);
    }

    public void initOrganization(long organizationId) {
        this.domainManager.initOrganization(organizationId);
    }

    public void initDomain(long domainId) {
        this.domainManager.initDomain(domainId);
    }

    public long newOrganization(OrganizationSummary organizationSummary) {
        Organization org = new Organization();
        org.setName(organizationSummary.getName());
        ArrayList<Domain> domains = new ArrayList<Domain>(organizationSummary.getDomains().size());
        for (DomainSummary d : organizationSummary.getDomains()) {
            Domain domain = new Domain();
            domain.setName(d.getName());
            domain.setOrganization(org);
            ArrayList<RuntimeId> runtimes = new ArrayList<RuntimeId>(d.getRuntimes().size());
            for (RuntimeSummary r : d.getRuntimes()) {
                RuntimeId runtimeId = new RuntimeId();
                runtimeId.setName(r.getName());
                runtimeId.setReference(r.getReference());
                runtimeId.setType(r.getType());
                runtimeId.setDomain(domain);
                runtimes.add(runtimeId);
            }
            domain.setRuntimes(runtimes);
            domains.add(domain);
        }
        org.setDomains(domains);
        return this.domainManager.storeOrganization(org);
    }
}

