/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.backend.server;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.console.ng.bd.service.FileServiceEntryPoint;
import org.jbpm.shared.services.api.FileException;
import org.jbpm.shared.services.api.FileService;
import org.kie.commons.java.nio.file.Path;
import org.uberfire.backend.vfs.ActiveFileSystems;
import org.uberfire.backend.vfs.FileSystem;
import org.uberfire.backend.vfs.PathFactory;

@Service
@ApplicationScoped
@Transactional
public class FileServiceEntryPointImpl
implements FileServiceEntryPoint {
    @Inject
    private FileService fs;
    @Inject
    private ActiveFileSystems fileSystems;

    public String createProcessDefinitionFile(String name) {
        return this.fs.createFile(name).toString();
    }

    public void fetchChanges() {
        this.fs.fetchChanges();
    }

    public byte[] loadFile(Path file) {
        try {
            return this.fs.loadFile(file);
        }
        catch (FileException ex) {
            Logger.getLogger(FileServiceEntryPointImpl.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Iterable<Path> loadFilesByType(String path, String fileType) {
        try {
            return this.fs.loadFilesByType(path, fileType);
        }
        catch (FileException ex) {
            Logger.getLogger(FileServiceEntryPointImpl.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public org.uberfire.backend.vfs.Path getPath(String path) {
        String reporoot = this.fs.getRepositoryRoot();
        if (reporoot.endsWith("/")) {
            reporoot = reporoot.substring(0, reporoot.length() - 1);
        }
        String uri = reporoot + path;
        String name = uri.substring(uri.lastIndexOf("/") + 1);
        return PathFactory.newPath((FileSystem)this.fileSystems.getBootstrapFileSystem(), (String)name, (String)uri);
    }
}

