/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.droolsjbpm.services.api.DomainManagerService;
import org.droolsjbpm.services.api.RuntimeDataService;
import org.droolsjbpm.services.impl.model.ProcessInstanceDesc;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.console.ng.bd.service.KieSessionEntryPoint;
import org.jbpm.console.ng.pr.backend.server.ProcessInstanceHelper;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.runtime.manager.Context;
import org.kie.internal.runtime.manager.RuntimeManager;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

@Service
@ApplicationScoped
@Transactional
public class KieSessionEntryPointImpl
implements KieSessionEntryPoint {
    @Inject
    private DomainManagerService domainManagerService;
    @Inject
    private RuntimeDataService dataService;

    public long startProcess(String domainName, String processId) {
        RuntimeManager runtimesByDomain = this.domainManagerService.getRuntimesByDomain(domainName);
        KieSession ksession = runtimesByDomain.getRuntime((Context)ProcessInstanceIdContext.get()).getKieSession();
        ProcessInstance pi = ksession.startProcess(processId);
        return pi.getId();
    }

    public long startProcess(String domainName, String processId, Map<String, String> params) {
        RuntimeManager runtimesByDomain = this.domainManagerService.getRuntimesByDomain(domainName);
        KieSession ksession = runtimesByDomain.getRuntime((Context)ProcessInstanceIdContext.get()).getKieSession();
        ProcessInstance pi = ksession.startProcess(processId, new HashMap<String, String>(params));
        return pi.getId();
    }

    public void abortProcessInstance(long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        RuntimeManager runtimesByDomain = this.domainManagerService.getRuntimesByDomain(piDesc.getDomainId());
        KieSession ksession = runtimesByDomain.getRuntime((Context)ProcessInstanceIdContext.get((Long)processInstanceId)).getKieSession();
        ksession.abortProcessInstance(processInstanceId);
    }

    public void signalProcessInstance(long processInstanceId, String signalName, Object event) {
        if (processInstanceId != -1L) {
            ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
            RuntimeManager runtimesByDomain = this.domainManagerService.getRuntimesByDomain(piDesc.getDomainId());
            KieSession ksession = runtimesByDomain.getRuntime((Context)ProcessInstanceIdContext.get((Long)processInstanceId)).getKieSession();
            ksession.signalEvent(signalName, event, processInstanceId);
        }
    }

    public Collection<String> getAvailableSignals(long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        RuntimeManager runtimesByDomain = this.domainManagerService.getRuntimesByDomain(piDesc.getDomainId());
        KieSession ksession = runtimesByDomain.getRuntime((Context)ProcessInstanceIdContext.get((Long)processInstanceId)).getKieSession();
        ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId);
        ArrayList<String> activeSignals = new ArrayList<String>();
        if (processInstance != null) {
            ((ProcessInstanceImpl)processInstance).setProcess(ksession.getKieBase().getProcess(processInstance.getProcessId()));
            Collection activeNodes = ((WorkflowProcessInstance)processInstance).getNodeInstances();
            activeSignals.addAll(ProcessInstanceHelper.collectActiveSignals((Collection)activeNodes));
        }
        return activeSignals;
    }

    public void setProcessVariable(long processInstanceId, String variableId, Object value) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        RuntimeManager runtimesByDomain = this.domainManagerService.getRuntimesByDomain(piDesc.getDomainId());
        KieSession ksession = runtimesByDomain.getRuntime((Context)ProcessInstanceIdContext.get((Long)processInstanceId)).getKieSession();
        ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId);
        ((WorkflowProcessInstance)processInstance).setVariable(variableId, value);
    }
}

