/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.backend.server;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.bd.exception.DeploymentException;
import org.jbpm.console.ng.bd.model.DeploymentUnitSummary;
import org.jbpm.console.ng.bd.model.KModuleDeploymentUnitSummary;
import org.jbpm.console.ng.bd.service.DeploymentManagerEntryPoint;
import org.jbpm.console.ng.bd.service.Initializable;
import org.jbpm.kie.services.api.DeployedUnit;
import org.jbpm.kie.services.api.DeploymentService;
import org.jbpm.kie.services.api.DeploymentUnit;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.event.Deploy;
import org.jbpm.kie.services.impl.event.DeploymentEvent;
import org.jbpm.kie.services.impl.event.Undeploy;
import org.kie.workbench.common.services.shared.builder.model.DeployResult;
import org.uberfire.backend.deployment.DeploymentConfigService;

@Service
@ApplicationScoped
public class DeploymentManagerEntryPointImpl
implements DeploymentManagerEntryPoint,
Initializable<DeploymentUnit> {
    @Inject
    private DeploymentService deploymentService;
    @Inject
    @RequestScoped
    private Set<DeploymentUnit> deploymentUnits;
    @Inject
    private DeploymentConfigService deploymentConfigService;
    @Inject
    private GuvnorM2Repository guvnorM2Repository;

    @PostConstruct
    public void configure() {
        this.guvnorM2Repository.getRepositoryURL();
    }

    public void initDeployments(Set<DeploymentUnit> deploymentUnits) {
        for (DeploymentUnit unit : deploymentUnits) {
            if (this.deploymentService.getDeployedUnit(unit.getIdentifier()) != null) continue;
            this.cleanup(unit.getIdentifier());
            this.deploymentService.deploy(unit);
        }
    }

    public void deploy(DeploymentUnitSummary unitSummary) {
        KModuleDeploymentUnit unit = null;
        if (unitSummary.getType().equals("kjar")) {
            unit = new KModuleDeploymentUnit(((KModuleDeploymentUnitSummary)unitSummary).getGroupId(), ((KModuleDeploymentUnitSummary)unitSummary).getArtifactId(), ((KModuleDeploymentUnitSummary)unitSummary).getVersion(), ((KModuleDeploymentUnitSummary)unitSummary).getKbaseName(), ((KModuleDeploymentUnitSummary)unitSummary).getKsessionName());
        }
        if (this.deploymentService.getDeployedUnit(unit.getIdentifier()) == null) {
            this.deploymentService.deploy(unit);
        }
    }

    public void undeploy(DeploymentUnitSummary unitSummary) {
        KModuleDeploymentUnit unit = null;
        if (unitSummary.getType().equals("kjar")) {
            unit = new KModuleDeploymentUnit(((KModuleDeploymentUnitSummary)unitSummary).getGroupId(), ((KModuleDeploymentUnitSummary)unitSummary).getArtifactId(), ((KModuleDeploymentUnitSummary)unitSummary).getVersion(), ((KModuleDeploymentUnitSummary)unitSummary).getKbaseName(), ((KModuleDeploymentUnitSummary)unitSummary).getKsessionName());
        }
        try {
            if (this.deploymentService.getDeployedUnit(unit.getIdentifier()) != null) {
                this.deploymentService.undeploy(unit);
            }
        }
        catch (IllegalStateException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
    }

    public void redeploy() {
        for (DeploymentUnit unit : this.deploymentUnits) {
            if (this.deploymentService.getDeployedUnit(unit.getIdentifier()) != null) {
                this.deploymentService.undeploy(unit);
            }
            this.deploymentService.deploy(unit);
        }
    }

    protected void cleanup(final String identifier) {
        File dataDir;
        String location = System.getProperty("jbpm.data.dir", System.getProperty("jboss.server.data.dir"));
        if (location == null) {
            location = System.getProperty("java.io.tmpdir");
        }
        if ((dataDir = new File(location)).exists()) {
            String[] jbpmSerFiles;
            for (String file : jbpmSerFiles = dataDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equals(identifier + "-jbpmSessionId.ser");
                }
            })) {
                new File(dataDir, file).delete();
            }
        }
    }

    public void saveDeployment(@Observes @Deploy DeploymentEvent event) {
        if (this.deploymentConfigService.getDeployment(event.getDeploymentId()) == null) {
            this.deploymentConfigService.addDeployment(event.getDeploymentId(), (Object)event.getDeployedUnit().getDeploymentUnit());
        }
    }

    public void removeDeployment(@Observes @Undeploy DeploymentEvent event) {
        this.deploymentConfigService.removeDeployment(event.getDeploymentId());
    }

    public List<KModuleDeploymentUnitSummary> getDeploymentUnits() {
        Collection deployedUnits = this.deploymentService.getDeployedUnits();
        ArrayList<KModuleDeploymentUnitSummary> unitsIds = new ArrayList<KModuleDeploymentUnitSummary>(deployedUnits.size());
        for (DeployedUnit du : deployedUnits) {
            KModuleDeploymentUnit kdu = (KModuleDeploymentUnit)du.getDeploymentUnit();
            KModuleDeploymentUnitSummary duSummary = new KModuleDeploymentUnitSummary(kdu.getIdentifier(), kdu.getGroupId(), kdu.getArtifactId(), kdu.getVersion(), kdu.getKbaseName(), kdu.getKsessionName());
            unitsIds.add(duSummary);
        }
        return unitsIds;
    }

    public void autoDeploy(@Observes DeployResult result) {
        try {
            KModuleDeploymentUnitSummary unit = new KModuleDeploymentUnitSummary("", result.getGroupId(), result.getArtifactId(), result.getVersion(), "", "");
            this.undeploy((DeploymentUnitSummary)unit);
            this.deploy((DeploymentUnitSummary)unit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

