/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.backend.server.provider;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jbpm.console.ng.bd.service.DeploymentUnitProvider;
import org.jbpm.kie.services.api.DeploymentUnit;
import org.jbpm.kie.services.api.Kjar;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;

@ApplicationScoped
@Kjar
public class UserDefinedDeploymentUnitProvider
implements DeploymentUnitProvider<DeploymentUnit> {
    @Inject
    private Logger logger;

    public Set<DeploymentUnit> getDeploymentUnits() {
        File duFile;
        String deploymentUnitsFile;
        HashSet<DeploymentUnit> deploymentUnits = new HashSet<DeploymentUnit>();
        String propertyDeployments = System.getProperty("jbpm.deployment.units");
        if (propertyDeployments != null) {
            String[] allGAVs;
            for (String gav : allGAVs = propertyDeployments.split(";")) {
                DeploymentUnit unit = this.buildDeploymentUnit(gav);
                if (unit == null) continue;
                deploymentUnits.add(unit);
            }
        }
        if ((deploymentUnitsFile = System.getProperty("jbpm.deployment.units.file")) != null && (duFile = new File(deploymentUnitsFile)).exists()) {
            try {
                Scanner duFileScanner = new Scanner(duFile);
                while (duFileScanner.hasNextLine()) {
                    String gav = duFileScanner.nextLine();
                    DeploymentUnit unit = this.buildDeploymentUnit(gav);
                    if (unit == null) continue;
                    deploymentUnits.add(unit);
                }
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        return deploymentUnits;
    }

    protected DeploymentUnit buildDeploymentUnit(String gav) {
        String[] elems = gav.split(":");
        if (elems.length == 3) {
            return new KModuleDeploymentUnit(elems[0], elems[1], elems[2]);
        }
        if (elems.length == 5) {
            return new KModuleDeploymentUnit(elems[0], elems[1], elems[2], elems[3], elems[4]);
        }
        this.logger.warning("Unknown deployment unit " + gav);
        return null;
    }
}

