/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.backend.server;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import javax.inject.Named;
import org.jbpm.console.ng.bd.service.AdministrationService;
import org.jbpm.console.ng.bd.service.DeploymentManagerEntryPoint;
import org.jbpm.console.ng.bd.service.DeploymentUnitProvider;
import org.jbpm.console.ng.bd.service.Initializable;
import org.jbpm.kie.services.api.DeploymentService;
import org.jbpm.kie.services.api.DeploymentUnit;
import org.jbpm.kie.services.api.Kjar;
import org.jbpm.kie.services.api.Vfs;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.FileSystemAlreadyExistsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.group.Group;
import org.uberfire.backend.group.GroupService;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.repositories.RepositoryService;
import org.uberfire.backend.server.config.ConfigGroup;
import org.uberfire.backend.server.config.ConfigType;
import org.uberfire.backend.server.config.ConfigurationFactory;
import org.uberfire.backend.server.config.ConfigurationService;

@ApplicationScoped
public class AdministrationServiceImpl
implements AdministrationService {
    private static final String DEPLOYMENT_SERVICE_TYPE_CONFIG = "deployment.service";
    private static final Logger logger = LoggerFactory.getLogger(AdministrationServiceImpl.class);
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private RepositoryService repositoryService;
    @Inject
    private GroupService groupService;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private DeploymentManagerEntryPoint deploymentManager;
    @Inject
    @Any
    private Instance<DeploymentService> deploymentService;
    @Inject
    @Any
    private Instance<DeploymentUnitProvider> deploymentUnitProviders;
    private String deploymentServiceType;
    private volatile boolean bootstrapDeploymentsDone = false;

    @Override
    public void bootstrapRepository(String repoAlias, String repoUrl, String userName, String password) {
        Repository repository = null;
        try {
            repository = this.repositoryService.getRepository(repoAlias);
            if (repository == null) {
                HashMap<String, String> env = new HashMap<String, String>(3);
                env.put("origin", repoUrl);
                env.put("username", userName);
                env.put("crypt:password", password);
                this.repositoryService.createRepository("git", repoAlias, env);
                repository = this.repositoryService.getRepository(repoAlias);
            }
        }
        catch (Exception e) {
            logger.warn("Unable to create repository with alias {} due to {}", (Object)repoAlias, (Object)e.getMessage());
        }
        Group demoGroup = this.groupService.getGroup("demo");
        if (demoGroup == null) {
            ArrayList<Repository> repositories = new ArrayList<Repository>();
            if (repository != null) {
                repositories.add(repository);
            }
            this.groupService.createGroup("demo", "demo@jbpm.org", repositories);
        } else {
            Collection repositories = demoGroup.getRepositories();
            if (repositories != null) {
                boolean found = false;
                for (Repository repo : repositories) {
                    if (!repo.getAlias().equals(repository.getAlias())) continue;
                    found = true;
                }
                if (!found) {
                    this.groupService.addRepository(demoGroup, repository);
                }
            }
        }
        if (repository != null) {
            try {
                this.ioService.newFileSystem(URI.create(repository.getUri()), repository.getEnvironment());
            }
            catch (FileSystemAlreadyExistsException e) {
                this.ioService.getFileSystem(URI.create(repository.getUri()));
            }
        }
    }

    @Override
    public void bootstrapConfig() {
        ConfigGroup deploymentServiceTypeConfig = null;
        List configGroups = this.configurationService.getConfiguration(ConfigType.GLOBAL);
        if (configGroups != null) {
            for (ConfigGroup configGroup : configGroups) {
                if (!DEPLOYMENT_SERVICE_TYPE_CONFIG.equals(configGroup.getName())) continue;
                deploymentServiceTypeConfig = configGroup;
                break;
            }
        }
        if (deploymentServiceTypeConfig == null) {
            deploymentServiceTypeConfig = this.configurationFactory.newConfigGroup(ConfigType.GLOBAL, DEPLOYMENT_SERVICE_TYPE_CONFIG, "");
            deploymentServiceTypeConfig.addConfigItem(this.configurationFactory.newConfigItem("type", "kjar"));
            this.configurationService.addConfiguration(deploymentServiceTypeConfig);
        }
        this.deploymentServiceType = deploymentServiceTypeConfig.getConfigItemValue("type");
    }

    @Override
    public void bootstrapDeployments() {
        Set<DeploymentUnit> deploymentUnits = this.produceDeploymentUnits();
        ((Initializable)this.deploymentManager).initDeployments(deploymentUnits);
        this.bootstrapDeploymentsDone = true;
    }

    @Override
    public boolean getBootstrapDeploymentsDone() {
        return this.bootstrapDeploymentsDone;
    }

    @Override
    @Produces
    @RequestScoped
    public Set<DeploymentUnit> produceDeploymentUnits() {
        HashSet<DeploymentUnit> deploymentUnits = new HashSet<DeploymentUnit>();
        Instance suitableProviders = this.deploymentUnitProviders.select(new Annotation[]{this.getDeploymentType()});
        for (DeploymentUnitProvider provider : suitableProviders) {
            deploymentUnits.addAll(provider.getDeploymentUnits());
        }
        return deploymentUnits;
    }

    @Override
    @Produces
    public DeploymentService getDeploymentService() {
        return (DeploymentService)this.deploymentService.select(new Annotation[]{this.getDeploymentType()}).get();
    }

    protected AnnotationLiteral getDeploymentType() {
        if (this.deploymentServiceType.equals("kjar")) {
            return new AnnotationLiteral<Kjar>(){};
        }
        if (this.deploymentServiceType.equals("vfs")) {
            return new AnnotationLiteral<Vfs>(){};
        }
        throw new IllegalStateException("Unknown type of deployment service " + this.deploymentServiceType);
    }
}

