/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.backend.server.profile;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.jbpm.console.ng.bd.backend.server.profile.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileManagerExtension
implements Extension {
    private static final Logger logger = LoggerFactory.getLogger(ProfileManagerExtension.class);
    private Map<String, String> profilesExcludes = new HashMap<String, String>();
    private String activeProfile;

    public ProfileManagerExtension() {
        this.profilesExcludes.put("exec-server", "(org\\.jboss\\.errai\\.*.)||(org\\.jbpm\\.console\\.ng.*\\.client\\..*)||(org\\.kie\\.workbench.*\\.client\\..*)||(org\\.guvnor.*\\.client\\..*)");
        this.profilesExcludes.put("ui-server", "(org\\.kie\\.services\\.remote\\..*)||(org\\.kie\\.services\\.client\\..*)||(org\\.kie\\.workbench\\.common\\.services\\.rest\\..*)");
        this.activeProfile = System.getProperty("org.kie.active.profile", "full");
    }

    <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> pat, BeanManager beanManager) {
        AnnotatedType annotatedType = pat.getAnnotatedType();
        Class javaClass = annotatedType.getJavaClass();
        Package pkg = javaClass.getPackage();
        String pattern = this.profilesExcludes.get(this.activeProfile);
        if (pattern != null) {
            if (pkg != null && pkg.isAnnotationPresent(Profile.class)) {
                Profile profileOnBean = pkg.getAnnotation(Profile.class);
                if (!this.isInActiveProfile(profileOnBean)) {
                    logger.info("Excluding Bean {} since it is not in active profile {}", (Object)javaClass, (Object)this.activeProfile);
                    pat.veto();
                }
            } else if (annotatedType.isAnnotationPresent(Profile.class)) {
                Profile profileOnBean = (Profile)annotatedType.getAnnotation(Profile.class);
                if (!this.isInActiveProfile(profileOnBean)) {
                    logger.info("Excluding Bean {} since it is not in active profile {}", (Object)javaClass, (Object)this.activeProfile);
                    pat.veto();
                }
            } else if (pkg != null && pkg.getName().matches(pattern)) {
                logger.info("Excluding Bean {} since it is not in active profile {}", (Object)javaClass, (Object)this.activeProfile);
                pat.veto();
            }
        }
    }

    private boolean isInActiveProfile(Profile profileOnBean) {
        String[] beansProfiles;
        for (String profile : beansProfiles = profileOnBean.names()) {
            if (!this.activeProfile.equals(profile)) continue;
            return true;
        }
        return false;
    }
}

