/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.interceptor.Interceptors;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.seam.transaction.TransactionInterceptor;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.console.ng.bd.service.KieSessionEntryPoint;
import org.jbpm.console.ng.pr.backend.server.ProcessInstanceHelper;
import org.jbpm.kie.services.api.DeploymentService;
import org.jbpm.kie.services.api.RuntimeDataService;
import org.jbpm.kie.services.impl.model.ProcessInstanceDesc;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

@Service
@ApplicationScoped
@Transactional
@Interceptors(value={TransactionInterceptor.class})
public class KieSessionEntryPointImpl
implements KieSessionEntryPoint {
    @Inject
    private DeploymentService deploymentService;
    @Inject
    private RuntimeDataService dataService;

    public long startProcess(String domainName, String processId) {
        RuntimeManager runtimesByDomain = this.deploymentService.getDeployedUnit(domainName).getRuntimeManager();
        KieSession ksession = runtimesByDomain.getRuntimeEngine((Context)ProcessInstanceIdContext.get()).getKieSession();
        ProcessInstance pi = ksession.startProcess(processId);
        return pi.getId();
    }

    public long startProcess(String domainName, String processId, Map<String, String> params) {
        RuntimeManager runtimesByDomain = this.deploymentService.getDeployedUnit(domainName).getRuntimeManager();
        KieSession ksession = runtimesByDomain.getRuntimeEngine((Context)ProcessInstanceIdContext.get()).getKieSession();
        ProcessInstance pi = ksession.startProcess(processId, new HashMap<String, String>(params));
        return pi.getId();
    }

    public void abortProcessInstance(long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        RuntimeManager runtimesByDomain = this.deploymentService.getDeployedUnit(piDesc.getDeploymentId()).getRuntimeManager();
        KieSession ksession = runtimesByDomain.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId)).getKieSession();
        ksession.abortProcessInstance(processInstanceId);
    }

    public void abortProcessInstances(List<Long> processInstanceIds) {
        for (long processInstanceId : processInstanceIds) {
            ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
            RuntimeManager runtimesByDomain = this.deploymentService.getDeployedUnit(piDesc.getDeploymentId()).getRuntimeManager();
            KieSession ksession = runtimesByDomain.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId)).getKieSession();
            ksession.abortProcessInstance(processInstanceId);
        }
    }

    public void suspendProcessInstance(long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        RuntimeManager runtimesByDomain = this.deploymentService.getDeployedUnit(piDesc.getDeploymentId()).getRuntimeManager();
    }

    public void signalProcessInstance(long processInstanceId, String signalName, Object event) {
        if (processInstanceId != -1L) {
            ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
            RuntimeManager runtimesByDomain = this.deploymentService.getDeployedUnit(piDesc.getDeploymentId()).getRuntimeManager();
            KieSession ksession = runtimesByDomain.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId)).getKieSession();
            ksession.signalEvent(signalName, event, processInstanceId);
        }
    }

    public void signalProcessInstances(List<Long> processInstanceIds, String signalName, Object event) {
        for (Long processInstanceId : processInstanceIds) {
            if (processInstanceId == -1L) continue;
            ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId.longValue());
            RuntimeManager runtimesByDomain = this.deploymentService.getDeployedUnit(piDesc.getDeploymentId()).getRuntimeManager();
            KieSession ksession = runtimesByDomain.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId)).getKieSession();
            ksession.signalEvent(signalName, event, processInstanceId.longValue());
        }
    }

    public Collection<String> getAvailableSignals(long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        RuntimeManager runtimesByDomain = this.deploymentService.getDeployedUnit(piDesc.getDeploymentId()).getRuntimeManager();
        KieSession ksession = runtimesByDomain.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId)).getKieSession();
        ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId);
        ArrayList<String> activeSignals = new ArrayList<String>();
        if (processInstance != null) {
            ((ProcessInstanceImpl)processInstance).setProcess(ksession.getKieBase().getProcess(processInstance.getProcessId()));
            Collection activeNodes = ((WorkflowProcessInstance)processInstance).getNodeInstances();
            activeSignals.addAll(ProcessInstanceHelper.collectActiveSignals((Collection)activeNodes));
        }
        return activeSignals;
    }

    public void setProcessVariable(long processInstanceId, String variableId, Object value) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        RuntimeManager runtimesByDomain = this.deploymentService.getDeployedUnit(piDesc.getDeploymentId()).getRuntimeManager();
        KieSession ksession = runtimesByDomain.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId)).getKieSession();
        ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId);
        ((WorkflowProcessInstance)processInstance).setVariable(variableId, value);
    }
}

