/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.service;

import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.jbpm.console.ng.bd.api.FileException;
import org.jbpm.console.ng.bd.api.FileService;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@ApplicationScoped
public class VFSFileServiceImpl
implements FileService {
    private static final String REPO_PLAYGROUND = "git://jbpm-playground/";
    private boolean active;
    @Inject
    @Named(value="ioStrategy")
    private Instance<IOService> ioService;

    @Override
    @PostConstruct
    public void init() {
        try {
            this.getIOService().get(URI.create(REPO_PLAYGROUND));
            this.fetchChanges();
            this.active = true;
        }
        catch (FileSystemNotFoundException e) {
            this.active = false;
        }
    }

    @Override
    public void fetchChanges() {
        this.getIOService().getFileSystem(URI.create("git://jbpm-playground/?fetch"));
        this.active = true;
    }

    @Override
    public byte[] loadFile(Path file) throws FileException {
        if (!this.isActive()) {
            return new byte[0];
        }
        PortablePreconditions.checkNotNull((String)"file", (Object)file);
        try {
            return this.getIOService().readAllBytes(file);
        }
        catch (IOException ex) {
            throw new FileException(ex.getMessage(), ex);
        }
    }

    @Override
    public Iterable<Path> loadFilesByType(Path path, final String fileType) {
        if (!this.isActive()) {
            return new ArrayList<Path>();
        }
        return this.getIOService().newDirectoryStream(path, (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return !Files.isDirectory((Path)entry, (LinkOption[])new LinkOption[0]) && (entry.getFileName().toString().endsWith(fileType) || entry.getFileName().toString().matches(fileType));
            }
        });
    }

    @Override
    public Iterable<Path> listDirectories(Path path) {
        if (!this.isActive()) {
            return new ArrayList<Path>();
        }
        return this.getIOService().newDirectoryStream(path, (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return Files.isDirectory((Path)entry, (LinkOption[])new LinkOption[0]);
            }
        });
    }

    @Override
    public Path getPath(String path) {
        if (!this.isActive()) {
            return null;
        }
        return this.getIOService().get(path, new String[0]);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean exists(Path file) {
        if (!this.isActive()) {
            return false;
        }
        return this.getIOService().exists(file);
    }

    @Override
    public void move(Path source, Path dest) {
        if (!this.isActive()) {
            return;
        }
        this.copy(source, dest);
        this.getIOService().delete(source, new DeleteOption[0]);
    }

    @Override
    public void copy(Path source, Path dest) {
        if (!this.isActive()) {
            return;
        }
        PortablePreconditions.checkNotNull((String)"source", (Object)source);
        PortablePreconditions.checkNotNull((String)"dest", (Object)dest);
        this.getIOService().copy(source, dest, new CopyOption[0]);
    }

    @Override
    public Path createDirectory(Path path) {
        if (!this.isActive()) {
            return null;
        }
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        return this.getIOService().createDirectory(path, new FileAttribute[0]);
    }

    @Override
    public Path createFile(Path path) {
        if (!this.isActive()) {
            return null;
        }
        return this.getIOService().createFile(path, new FileAttribute[0]);
    }

    @Override
    public boolean deleteIfExists(Path path) {
        if (!this.isActive()) {
            return false;
        }
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        return this.getIOService().deleteIfExists(path, new DeleteOption[0]);
    }

    @Override
    public OutputStream openFile(Path path) {
        if (!this.isActive()) {
            return null;
        }
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        return this.getIOService().newOutputStream(path, new OpenOption[0]);
    }

    protected IOService getIOService() {
        return (IOService)this.ioService.get();
    }
}

