/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.backend.server.dd;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringEscapeUtils;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.bd.dd.model.DeploymentDescriptorModel;
import org.jbpm.console.ng.bd.dd.model.ItemObjectModel;
import org.jbpm.console.ng.bd.dd.model.Parameter;
import org.jbpm.console.ng.bd.dd.service.DDEditorService;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorIO;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorImpl;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorManager;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.PersistenceMode;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.workbench.common.services.backend.service.KieService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@Service
@ApplicationScoped
public class DDEditorServiceImpl
extends KieService<DeploymentDescriptorModel>
implements DDEditorService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;

    public DeploymentDescriptorModel load(org.uberfire.backend.vfs.Path path) {
        return (DeploymentDescriptorModel)super.loadContent(path);
    }

    protected DeploymentDescriptorModel constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        InputStream input = this.ioService.newInputStream(Paths.convert((org.uberfire.backend.vfs.Path)path), new OpenOption[0]);
        DeploymentDescriptor originDD = DeploymentDescriptorIO.fromXml((InputStream)input);
        DeploymentDescriptorModel ddModel = this.marshal(originDD);
        ddModel.setOverview(overview);
        return ddModel;
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path path, DeploymentDescriptorModel content, Metadata metadata, String comment) {
        try {
            String deploymentContent = this.unmarshal(path, content).toXml();
            Metadata currentMetadata = this.metadataService.getMetadata(path);
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), deploymentContent, this.metadataService.setUpAttributes(path, metadata), new OpenOption[]{this.makeCommentedOption(comment)});
            this.fireMetadataSocialEvents(path, currentMetadata, metadata);
            return path;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path, DeploymentDescriptorModel content) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        try {
            this.unmarshal(path, content).toXml();
        }
        catch (Exception e) {
            ValidationMessage msg = new ValidationMessage();
            msg.setPath(path);
            msg.setLevel(ValidationMessage.Level.ERROR);
            msg.setText(e.getMessage());
            validationMessages.add(msg);
        }
        return validationMessages;
    }

    public String toSource(org.uberfire.backend.vfs.Path path, DeploymentDescriptorModel model) {
        try {
            return StringEscapeUtils.escapeXml((String)this.unmarshal(path, model).toXml());
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private DeploymentDescriptorModel marshal(DeploymentDescriptor originDD) {
        DeploymentDescriptorModel ddModel = new DeploymentDescriptorModel();
        ddModel.setPersistenceUnitName(originDD.getPersistenceUnit());
        ddModel.setAuditPersistenceUnitName(originDD.getAuditPersistenceUnit());
        ddModel.setAuditMode(originDD.getAuditMode().toString());
        ddModel.setPersistenceMode(originDD.getPersistenceMode().toString());
        ddModel.setRuntimeStrategy(originDD.getRuntimeStrategy().toString());
        List marshallingStrategies = originDD.getMarshallingStrategies();
        ddModel.setMarshallingStrategies(this.processObjectModel(marshallingStrategies));
        List eventListeners = originDD.getEventListeners();
        ddModel.setEventListeners(this.processObjectModel(eventListeners));
        List globals = originDD.getGlobals();
        ddModel.setGlobals(this.processNamedObjectModel(globals));
        List workItemHandlers = originDD.getWorkItemHandlers();
        ddModel.setWorkItemHandlers(this.processNamedObjectModel(workItemHandlers));
        List taskEventListeners = originDD.getTaskEventListeners();
        ddModel.setTaskEventListeners(this.processObjectModel(taskEventListeners));
        List environmentEntries = originDD.getEnvironmentEntries();
        ddModel.setEnvironmentEntries(this.processNamedObjectModel(environmentEntries));
        List configuration = originDD.getConfiguration();
        ddModel.setConfiguration(this.processNamedObjectModel(configuration));
        ddModel.setRequiredRoles(originDD.getRequiredRoles());
        ddModel.setRemotableClasses(originDD.getClasses());
        return ddModel;
    }

    private DeploymentDescriptor unmarshal(org.uberfire.backend.vfs.Path path, DeploymentDescriptorModel model) {
        if (model == null) {
            return new DeploymentDescriptorManager().getDefaultDescriptor();
        }
        DeploymentDescriptorImpl updated = new DeploymentDescriptorImpl();
        updated.getBuilder().persistenceUnit(model.getPersistenceUnitName()).auditPersistenceUnit(model.getAuditPersistenceUnitName()).auditMode(AuditMode.valueOf((String)model.getAuditMode())).persistenceMode(PersistenceMode.valueOf((String)model.getPersistenceMode())).runtimeStrategy(RuntimeStrategy.valueOf((String)model.getRuntimeStrategy()));
        List marshallingStrategies = model.getMarshallingStrategies();
        updated.getBuilder().setMarshalingStrategies(this.processToObjectModel(marshallingStrategies));
        List eventListeners = model.getEventListeners();
        updated.getBuilder().setEventListeners(this.processToObjectModel(eventListeners));
        List globals = model.getGlobals();
        updated.getBuilder().setGlobals(this.processToNamedObjectModel(globals));
        List workItemHandlers = model.getWorkItemHandlers();
        updated.getBuilder().setWorkItemHandlers(this.processToNamedObjectModel(workItemHandlers));
        List taskEventListeners = model.getTaskEventListeners();
        updated.getBuilder().setTaskEventListeners(this.processToObjectModel(taskEventListeners));
        List environmentEntries = model.getEnvironmentEntries();
        updated.getBuilder().setEnvironmentEntries(this.processToNamedObjectModel(environmentEntries));
        List configuration = model.getConfiguration();
        updated.getBuilder().setConfiguration(this.processToNamedObjectModel(configuration));
        updated.getBuilder().setRequiredRoles(model.getRequiredRoles());
        updated.getBuilder().setClasses(model.getRemotableClasses());
        return updated;
    }

    private List<ItemObjectModel> processNamedObjectModel(List<NamedObjectModel> data) {
        ArrayList<ItemObjectModel> result = null;
        if (data != null) {
            result = new ArrayList<ItemObjectModel>();
            for (NamedObjectModel orig : data) {
                List<Parameter> parameters = this.collectParameters(orig.getParameters());
                result.add(new ItemObjectModel(orig.getName(), orig.getIdentifier(), orig.getResolver(), parameters));
            }
        }
        return result;
    }

    private List<ItemObjectModel> processObjectModel(List<ObjectModel> data) {
        ArrayList<ItemObjectModel> result = null;
        if (data != null) {
            result = new ArrayList<ItemObjectModel>();
            for (ObjectModel orig : data) {
                List<Parameter> parameters = this.collectParameters(orig.getParameters());
                result.add(new ItemObjectModel(null, orig.getIdentifier(), orig.getResolver(), parameters));
            }
        }
        return result;
    }

    private List<Parameter> collectParameters(List<Object> parameters) {
        ArrayList<Parameter> result = null;
        if (parameters != null && !parameters.isEmpty()) {
            result = new ArrayList<Parameter>();
            for (Object param : parameters) {
                if (!(param instanceof ObjectModel)) continue;
                ObjectModel model = (ObjectModel)param;
                result.add(new Parameter(model.getIdentifier(), model.getParameters().get(0).toString()));
            }
        }
        return result;
    }

    private List<ObjectModel> processToObjectModel(List<ItemObjectModel> data) {
        ArrayList<ObjectModel> result = null;
        if (data != null) {
            result = new ArrayList<ObjectModel>();
            for (ItemObjectModel item : data) {
                ObjectModel ms = new ObjectModel(item.getResolver(), item.getValue(), new Object[0]);
                if (item.getParameters() != null) {
                    for (Parameter param : item.getParameters()) {
                        ObjectModel p = new ObjectModel(item.getResolver(), param.getType(), new Object[]{param.getValue().trim()});
                        ms.addParameter((Object)p);
                    }
                }
                result.add(ms);
            }
        }
        return result;
    }

    private List<NamedObjectModel> processToNamedObjectModel(List<ItemObjectModel> data) {
        ArrayList<NamedObjectModel> result = null;
        if (data != null) {
            result = new ArrayList<NamedObjectModel>();
            for (ItemObjectModel item : data) {
                NamedObjectModel ms = new NamedObjectModel(item.getResolver(), item.getName(), item.getValue(), new Object[0]);
                if (item.getParameters() != null) {
                    for (Parameter param : item.getParameters()) {
                        ObjectModel p = new ObjectModel(item.getResolver(), param.getType(), new Object[]{param.getValue().trim()});
                        ms.addParameter((Object)p);
                    }
                }
                result.add(ms);
            }
        }
        return result;
    }

    public void createIfNotExists(org.uberfire.backend.vfs.Path path) {
        Path converted = Paths.convert((org.uberfire.backend.vfs.Path)path);
        if (!this.ioService.exists(converted)) {
            DeploymentDescriptor dd = new DeploymentDescriptorManager("org.jbpm.domain").getDefaultDescriptor();
            String xmlDescriptor = dd.toXml();
            this.ioService.write(converted, xmlDescriptor, new OpenOption[0]);
        }
    }
}

