/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.integration;

import java.util.ArrayList;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.dashbuilder.dataset.group.Interval;
import org.jbpm.console.ng.bd.integration.KieServerDataSetProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.definition.QueryParam;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KieServerDataSetProviderTest {
    public static String COLUMN_TEST = "columTest";
    KieServerDataSetProvider kieServerDataSetProvider;

    @Before
    public void setUp() {
        this.kieServerDataSetProvider = new KieServerDataSetProvider();
    }

    @Test
    public void appendEqualToIntervalSelectionTest() {
        String filterValue = "testValue";
        DataSetGroup dataSetGroup = new DataSetGroup();
        dataSetGroup.setColumnGroup(new ColumnGroup(COLUMN_TEST, COLUMN_TEST, GroupStrategy.DYNAMIC));
        ArrayList<Interval> intervalList = new ArrayList<Interval>();
        Interval interval = new Interval(filterValue);
        intervalList.add(interval);
        dataSetGroup.setSelectedIntervalList(intervalList);
        ArrayList filterParams = new ArrayList();
        this.kieServerDataSetProvider.appendIntervalSelection(dataSetGroup, filterParams);
        Assert.assertEquals((long)1L, (long)filterParams.size());
        Assert.assertEquals((Object)COLUMN_TEST, (Object)((QueryParam)filterParams.get(0)).getColumn());
        Assert.assertEquals((Object)"EQUALS_TO", (Object)((QueryParam)filterParams.get(0)).getOperator());
        Assert.assertEquals((Object)filterValue, ((QueryParam)filterParams.get(0)).getValue().get(0));
    }

    @Test
    public void appendBetweenIntervalSelectionTest() {
        String filterValue = "testValue";
        Long minValue = 0L;
        Long maxValue = 2L;
        DataSetGroup dataSetGroup = new DataSetGroup();
        dataSetGroup.setColumnGroup(new ColumnGroup(COLUMN_TEST, COLUMN_TEST, GroupStrategy.DYNAMIC));
        ArrayList<Interval> intervalList = new ArrayList<Interval>();
        Interval interval = new Interval(filterValue);
        interval.setMinValue((Object)minValue);
        interval.setMaxValue((Object)maxValue);
        intervalList.add(interval);
        dataSetGroup.setSelectedIntervalList(intervalList);
        ArrayList filterParams = new ArrayList();
        this.kieServerDataSetProvider.appendIntervalSelection(dataSetGroup, filterParams);
        Assert.assertEquals((long)1L, (long)filterParams.size());
        Assert.assertEquals((Object)COLUMN_TEST, (Object)((QueryParam)filterParams.get(0)).getColumn());
        Assert.assertEquals((Object)"BETWEEN", (Object)((QueryParam)filterParams.get(0)).getOperator());
        Assert.assertEquals((Object)minValue, ((QueryParam)filterParams.get(0)).getValue().get(0));
        Assert.assertEquals((Object)maxValue, ((QueryParam)filterParams.get(0)).getValue().get(1));
    }
}

