/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.integration.security;

import java.lang.reflect.Method;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.kie.server.client.CredentialsProvider;
import org.uberfire.ext.security.server.SecurityIntegrationFilter;

public class KeyCloakTokenCredentialsProvider
implements CredentialsProvider {
    private Class<?> keycloakPrincipal;
    private Class<?> keycloakSecurityContext;
    private Method tokenMethod;
    private Method securityContextMethod;

    public KeyCloakTokenCredentialsProvider() {
        try {
            this.keycloakPrincipal = Class.forName("org.keycloak.KeycloakPrincipal");
            this.keycloakSecurityContext = Class.forName("org.keycloak.KeycloakSecurityContext");
            this.tokenMethod = this.keycloakSecurityContext.getMethod("getTokenString", new Class[0]);
            this.securityContextMethod = this.keycloakPrincipal.getMethod("getKeycloakSecurityContext", new Class[0]);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("KeyCloak not on classpath");
        }
    }

    public String getHeaderName() {
        return "Authorization";
    }

    public String getAuthorization() {
        HttpServletRequest request = SecurityIntegrationFilter.getRequest();
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            try {
                Object securityContext = this.securityContextMethod.invoke((Object)principal, new Object[0]);
                return "Bearer " + this.tokenMethod.invoke(securityContext, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

