/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.integration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.dashbuilder.dataprovider.DataSetProvider;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.filter.LogicalExprFilter;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.dataset.impl.DataColumnImpl;
import org.dashbuilder.dataset.impl.DataSetMetadataImpl;
import org.dashbuilder.dataset.sort.ColumnSort;
import org.dashbuilder.dataset.sort.DataSetSort;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jbpm.console.ng.bd.integration.AbstractKieServerService;
import org.jbpm.console.ng.bd.integration.ConsoleDataSetLookup;
import org.jbpm.console.ng.bd.integration.KieServerDataSetProviderType;
import org.kie.server.api.model.definition.QueryFilterSpec;
import org.kie.server.api.model.definition.QueryParam;
import org.kie.server.client.QueryServicesClient;
import org.kie.server.common.rest.KieServerHttpRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class KieServerDataSetProvider
extends AbstractKieServerService
implements DataSetProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieServerDataSetProvider.class);
    public static final DataSetProviderType TYPE = new KieServerDataSetProviderType();

    public DataSetProviderType getType() {
        return TYPE;
    }

    public DataSetMetadata getDataSetMetadata(DataSetDef def) throws Exception {
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<ColumnType> columnTypes = new ArrayList<ColumnType>();
        List columns = def.getColumns();
        for (DataColumnDef column : columns) {
            columnNames.add(column.getId());
            columnTypes.add(column.getColumnType());
        }
        return new DataSetMetadataImpl(def, def.getUUID(), -1, def.getColumns().size(), columnNames, columnTypes, -1);
    }

    public DataSet lookupDataSet(DataSetDef def, DataSetLookup lookup) throws Exception {
        DataSetSort sort;
        if (!(lookup instanceof ConsoleDataSetLookup)) {
            throw new IllegalArgumentException("DataSetLookup is of incorrect type " + lookup.getClass().getName());
        }
        ConsoleDataSetLookup dataSetLookup = (ConsoleDataSetLookup)lookup;
        LOGGER.debug("Data Set lookup using Server Template Id: {}", (Object)dataSetLookup.getServerTemplateId());
        if (dataSetLookup.getServerTemplateId() == null || dataSetLookup.getServerTemplateId().isEmpty()) {
            return this.buildDataSet(def, new ArrayList<List>(), new ArrayList<DataColumn>());
        }
        QueryServicesClient queryClient = this.getClient(dataSetLookup.getServerTemplateId(), QueryServicesClient.class);
        ArrayList<QueryParam> filterParams = new ArrayList<QueryParam>();
        QueryFilterSpec filterSpec = new QueryFilterSpec();
        for (DataSetFilter filter : dataSetLookup.getOperationList(DataSetFilter.class)) {
            if (filter == null) continue;
            for (ColumnFilter cFilter : filter.getColumnFilterList()) {
                if (cFilter instanceof CoreFunctionFilter) {
                    CoreFunctionFilter coreFunctionFilter = (CoreFunctionFilter)cFilter;
                    filterParams.add(new QueryParam(coreFunctionFilter.getColumnId(), coreFunctionFilter.getType().toString(), coreFunctionFilter.getParameters()));
                    continue;
                }
                if (!(cFilter instanceof LogicalExprFilter)) continue;
                LogicalExprFilter logicalExprFilter = (LogicalExprFilter)cFilter;
                filterParams.add(new QueryParam(logicalExprFilter.getColumnId(), logicalExprFilter.getLogicalOperator().toString(), logicalExprFilter.getLogicalTerms()));
            }
        }
        ArrayList<DataColumn> extraColumns = new ArrayList<DataColumn>();
        List dataSetGroups = lookup.getFirstGroupOpSelections();
        for (Object group : dataSetGroups) {
            if (group.getSelectedIntervalList() == null || group.getSelectedIntervalList().size() <= 0) continue;
            this.appendIntervalSelection((DataSetGroup)group, filterParams);
        }
        DataSetGroup dataSetGroup = dataSetLookup.getLastGroupOp();
        if (dataSetGroup != null) {
            if (dataSetGroup.getColumnGroup() != null) {
                filterParams.add(new QueryParam(dataSetGroup.getColumnGroup().getSourceId(), "group", Arrays.asList(dataSetGroup.getColumnGroup().getColumnId())));
            }
            for (GroupFunction groupFunction : dataSetGroup.getGroupFunctions()) {
                if (groupFunction.getFunction() != null) {
                    filterParams.add(new QueryParam(groupFunction.getSourceId(), groupFunction.getFunction().toString(), Arrays.asList(groupFunction.getColumnId())));
                    extraColumns.add((DataColumn)new DataColumnImpl(groupFunction.getSourceId(), ColumnType.NUMBER));
                    continue;
                }
                filterParams.add(new QueryParam(groupFunction.getSourceId(), null, Arrays.asList(groupFunction.getColumnId())));
                extraColumns.add((DataColumn)new DataColumnImpl(groupFunction.getSourceId(), ColumnType.LABEL));
            }
        }
        if (!filterParams.isEmpty()) {
            filterSpec.setParameters(filterParams.toArray(new QueryParam[filterParams.size()]));
        }
        if ((sort = dataSetLookup.getFirstSortOp()) != null) {
            SortOrder sortOrder = SortOrder.UNSPECIFIED;
            StringBuilder orderBy = new StringBuilder();
            for (ColumnSort cSort : sort.getColumnSortList()) {
                orderBy.append(cSort.getColumnId()).append(",");
                sortOrder = cSort.getOrder();
            }
            orderBy.deleteCharAt(orderBy.length() - 1);
            filterSpec.setOrderBy(orderBy.toString());
            filterSpec.setAscending(sortOrder.equals((Object)SortOrder.ASCENDING));
        }
        List instances = null;
        try {
            instances = queryClient.query(dataSetLookup.getDataSetUUID(), "RawList", filterSpec, Integer.valueOf(dataSetLookup.getRowOffset() / dataSetLookup.getNumberOfRows()), Integer.valueOf(dataSetLookup.getNumberOfRows()), List.class);
        }
        catch (KieServerHttpRequestException e) {
            LOGGER.warn("Encountered {} while fetching query for {}", (Object)e.getMessage(), (Object)dataSetLookup.getDataSetUUID());
            instances = Collections.emptyList();
        }
        LOGGER.debug("Query client returned {} row(s)", (Object)instances.size());
        return this.buildDataSet(def, instances, extraColumns);
    }

    public boolean isDataSetOutdated(DataSetDef def) {
        return false;
    }

    protected DataSet buildDataSet(DataSetDef def, List<List> instances, List<DataColumn> extraColumns) throws Exception {
        DataSet dataSet = DataSetFactory.newEmptyDataSet();
        dataSet.setUUID(def.getUUID());
        dataSet.setDefinition(def);
        if (extraColumns != null && !extraColumns.isEmpty()) {
            for (DataColumn extraColumn : extraColumns) {
                dataSet.addColumn(extraColumn);
            }
        } else {
            for (DataColumnDef column : def.getColumns()) {
                DataColumnImpl numRows = new DataColumnImpl(column.getId(), column.getColumnType());
                dataSet.addColumn((DataColumn)numRows);
            }
        }
        for (List row : instances) {
            int columnIndex = 0;
            for (Object value : row) {
                DataColumn intervalBuilder = dataSet.getColumnByIndex(columnIndex);
                intervalBuilder.getValues().add(value);
                ++columnIndex;
            }
        }
        dataSet.setRowCountNonTrimmed(instances.size());
        return dataSet;
    }

    protected void appendIntervalSelection(DataSetGroup intervalSel, List<QueryParam> filterParams) {
        if (intervalSel != null && intervalSel.isSelect()) {
            ColumnGroup cg = intervalSel.getColumnGroup();
            List intervalList = intervalSel.getSelectedIntervalList();
            ArrayList<String> names = new ArrayList<String>();
            Comparable min = null;
            Comparable max = null;
            for (Interval interval : intervalList) {
                names.add(interval.getName());
                Comparable intervalMin = (Comparable)interval.getMinValue();
                Comparable intervalMax = (Comparable)interval.getMaxValue();
                if (intervalMin != null) {
                    if (min == null) {
                        min = intervalMin;
                    } else if (min.compareTo(intervalMin) > 0) {
                        min = intervalMin;
                    }
                }
                if (intervalMax == null) continue;
                if (max == null) {
                    max = intervalMax;
                    continue;
                }
                if (max.compareTo(intervalMax) <= 0) continue;
                max = intervalMax;
            }
            if (min != null && max != null && min.compareTo(max) > 0) {
                min = max;
            }
            ColumnFilter filter = min != null && max != null ? FilterFactory.between((String)cg.getSourceId(), (Comparable)min, max) : (min != null ? FilterFactory.greaterOrEqualsTo((String)cg.getSourceId(), (Comparable)min) : (max != null ? FilterFactory.lowerOrEqualsTo((String)cg.getSourceId(), max) : FilterFactory.equalsTo((String)cg.getSourceId(), names)));
            CoreFunctionFilter coreFunctionFilter = (CoreFunctionFilter)filter;
            filterParams.add(new QueryParam(coreFunctionFilter.getColumnId(), coreFunctionFilter.getType().toString(), coreFunctionFilter.getParameters()));
        }
    }
}

