/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.backend.server;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jbpm.console.ng.bd.integration.KieServerIntegration;
import org.jbpm.console.ng.cm.backend.server.CaseDefinitionMapperTest;
import org.jbpm.console.ng.cm.backend.server.CaseInstanceMapperTest;
import org.jbpm.console.ng.cm.backend.server.RemoteCaseManagementServiceImpl;
import org.jbpm.console.ng.cm.model.CaseDefinitionSummary;
import org.jbpm.console.ng.cm.model.CaseInstanceSummary;
import org.jbpm.console.ng.cm.service.CaseManagementService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.cases.CaseDefinition;
import org.kie.server.api.model.cases.CaseInstance;
import org.kie.server.client.CaseServicesClient;
import org.kie.server.client.KieServicesClient;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RemoteCaseManagementServiceImplTest {
    @Mock
    KieServicesClient kieServicesClient;
    @Mock
    CaseServicesClient caseServicesClient;
    @Mock
    KieServerIntegration kieServerIntegration;
    @InjectMocks
    RemoteCaseManagementServiceImpl service;

    @Before
    public void setup() {
        Mockito.when((Object)this.kieServerIntegration.getServerClient(Matchers.anyString())).thenReturn((Object)this.kieServicesClient);
        Mockito.when((Object)this.kieServerIntegration.getServerClient(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.kieServicesClient);
        Mockito.when((Object)this.kieServicesClient.getServicesClient(CaseServicesClient.class)).thenReturn((Object)this.caseServicesClient);
    }

    @Test
    public void testInvalidServerTemplate() throws Exception {
        Method[] methods;
        for (Method method : methods = CaseManagementService.class.getMethods()) {
            Class<?> returnType = method.getReturnType();
            Object[] args = new Object[method.getParameterCount()];
            Object result = method.invoke((Object)this.service, args);
            this.assertMethodResult(method, returnType, result);
            args[0] = "";
            result = method.invoke((Object)this.service, args);
            this.assertMethodResult(method, returnType, result);
        }
    }

    private void assertMethodResult(Method method, Class<?> returnType, Object result) {
        if (Collection.class.isAssignableFrom(returnType)) {
            Assert.assertNotNull((String)String.format("Returned collection for method %s should not be null", method.getName()), (Object)result);
            Assert.assertTrue((String)String.format("Returned collection for method %s should be empty", method.getName()), (boolean)((Collection)result).isEmpty());
        } else {
            Assert.assertNull((String)String.format("Returned object for method %s should be null", method.getName()), (Object)result);
        }
    }

    @Test
    public void testGetCaseDefinitions() throws Exception {
        CaseDefinition definition = new CaseDefinition();
        definition.setIdentifier("org.jbpm.case");
        definition.setName("New case");
        definition.setContainerId("org.jbpm");
        definition.setRoles(Collections.emptyMap());
        Mockito.when((Object)this.caseServicesClient.getCaseDefinitions(Integer.valueOf(Matchers.anyInt()), Integer.valueOf(Matchers.anyInt()))).thenReturn(Collections.singletonList(definition));
        List definitions = this.service.getCaseDefinitions("id", Integer.valueOf(0), Integer.valueOf(0));
        Assert.assertNotNull((Object)definitions);
        Assert.assertEquals((long)1L, (long)definitions.size());
        CaseDefinitionMapperTest.assertCaseDefinition(definition, (CaseDefinitionSummary)definitions.get(0));
    }

    @Test
    public void testGetCaseInstances() throws Exception {
        CaseInstance instance = new CaseInstance();
        instance.setCaseDescription("New case");
        instance.setCaseId("CASE-1");
        instance.setCaseStatus(Integer.valueOf(1));
        instance.setContainerId("org.jbpm");
        Mockito.when((Object)this.caseServicesClient.getCaseInstances(Integer.valueOf(Matchers.anyInt()), Integer.valueOf(Matchers.anyInt()))).thenReturn(Collections.singletonList(instance));
        List instances = this.service.getCaseInstances("id", Integer.valueOf(0), Integer.valueOf(0));
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        CaseInstanceSummary caseInstanceSummary = (CaseInstanceSummary)instances.get(0);
        CaseInstanceMapperTest.assertCaseInstance(instance, caseInstanceSummary);
        Assert.assertTrue((boolean)caseInstanceSummary.isActive());
    }

    @Test
    public void testStartCaseInstance() throws Exception {
        String caseDefinitionId = "org.jbpm";
        String container = "container";
        this.service.startCaseInstance("server", "container", "org.jbpm");
        ((CaseServicesClient)Mockito.verify((Object)this.caseServicesClient)).startCase("container", "org.jbpm");
    }

    @Test
    public void testCancelCaseInstance() throws Exception {
        String caseId = "CASE-1";
        String container = "container";
        this.service.cancelCaseInstance("server", "container", "CASE-1");
        ((CaseServicesClient)Mockito.verify((Object)this.caseServicesClient)).cancelCaseInstance("container", "CASE-1");
    }

    @Test
    public void testDestroyCaseInstance() throws Exception {
        String caseId = "CASE-1";
        String container = "container";
        this.service.destroyCaseInstance("server", "container", "CASE-1");
        ((CaseServicesClient)Mockito.verify((Object)this.caseServicesClient)).destroyCaseInstance("container", "CASE-1");
    }

    @Test
    public void testGetCaseInstanceNull() throws Exception {
        CaseInstanceSummary cis = this.service.getCaseInstance("server", "container", "CASE-1");
        Assert.assertNull((Object)cis);
    }

    @Test
    public void testGetCaseInstance() throws Exception {
        CaseInstance ci = new CaseInstance();
        ci.setCaseDescription("New case");
        ci.setCaseId("CASE-1");
        ci.setCaseStatus(Integer.valueOf(1));
        ci.setContainerId("org.jbpm");
        Mockito.when((Object)this.caseServicesClient.getCaseInstance(ci.getContainerId(), ci.getCaseId(), true, true, true, true)).thenReturn((Object)ci);
        CaseInstanceSummary cis = this.service.getCaseInstance("server", ci.getContainerId(), ci.getCaseId());
        CaseInstanceMapperTest.assertCaseInstance(ci, cis);
    }
}

