/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.backend.server;

import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jbpm.console.ng.cm.model.CaseInstanceSummary;
import org.jbpm.console.ng.cm.model.CaseRoleAssignmentSummary;
import org.kie.server.api.model.cases.CaseInstance;

public class CaseInstanceMapper
implements Function<CaseInstance, CaseInstanceSummary> {
    @Override
    public CaseInstanceSummary apply(CaseInstance ci) {
        if (ci == null) {
            return null;
        }
        CaseInstanceSummary cis = new CaseInstanceSummary();
        cis.setCaseId(ci.getCaseId());
        cis.setDescription(ci.getCaseDescription());
        cis.setStatus(ci.getCaseStatus());
        cis.setContainerId(ci.getContainerId());
        cis.setOwner(ci.getCaseOwner());
        cis.setStartedAt(ci.getStartedAt());
        cis.setCompletedAt(ci.getCompletedAt());
        cis.setCaseDefinitionId(ci.getCaseDefinitionId());
        cis.setRoleAssignments(Optional.ofNullable(ci.getRoleAssignments()).orElse(Collections.emptyList()).stream().map(ra -> new CaseRoleAssignmentSummary(ra.getName(), Optional.ofNullable(ra.getGroups()).orElse(Collections.emptyList()), Optional.ofNullable(ra.getUsers()).orElse(Collections.emptyList()))).collect(Collectors.toList()));
        return cis;
    }
}

