/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.backend.server;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.bd.integration.AbstractKieServerService;
import org.jbpm.console.ng.cm.backend.server.CaseDefinitionMapper;
import org.jbpm.console.ng.cm.backend.server.CaseInstanceMapper;
import org.jbpm.console.ng.cm.model.CaseDefinitionSummary;
import org.jbpm.console.ng.cm.model.CaseInstanceSummary;
import org.jbpm.console.ng.cm.service.CaseManagementService;
import org.kie.server.client.CaseServicesClient;

@Service
@ApplicationScoped
public class RemoteCaseManagementServiceImpl
extends AbstractKieServerService
implements CaseManagementService {
    public List<CaseDefinitionSummary> getCaseDefinitions(String serverTemplateId, Integer page, Integer pageSize) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return Collections.emptyList();
        }
        CaseServicesClient client = (CaseServicesClient)this.getClient(serverTemplateId, CaseServicesClient.class);
        List caseDefinitions = client.getCaseDefinitions(page, pageSize);
        return caseDefinitions.stream().map(new CaseDefinitionMapper()).collect(Collectors.toList());
    }

    public CaseDefinitionSummary getCaseDefinition(String serverTemplateId, String containerId, String caseDefinitionId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return null;
        }
        CaseServicesClient client = (CaseServicesClient)this.getClient(serverTemplateId, CaseServicesClient.class);
        return Optional.ofNullable(client.getCaseDefinition(containerId, caseDefinitionId)).map(new CaseDefinitionMapper()).orElse(null);
    }

    public List<CaseInstanceSummary> getCaseInstances(String serverTemplateId, Integer page, Integer pageSize) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return Collections.emptyList();
        }
        CaseServicesClient client = (CaseServicesClient)this.getClient(serverTemplateId, CaseServicesClient.class);
        List caseInstances = client.getCaseInstances(page, pageSize);
        return caseInstances.stream().map(new CaseInstanceMapper()).collect(Collectors.toList());
    }

    public String startCaseInstance(String serverTemplateId, String containerId, String caseDefinitionId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return null;
        }
        CaseServicesClient client = (CaseServicesClient)this.getClient(serverTemplateId, containerId, CaseServicesClient.class);
        return client.startCase(containerId, caseDefinitionId);
    }

    public void cancelCaseInstance(String serverTemplateId, String containerId, String caseId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        CaseServicesClient client = (CaseServicesClient)this.getClient(serverTemplateId, containerId, CaseServicesClient.class);
        client.cancelCaseInstance(containerId, caseId);
    }

    public void destroyCaseInstance(String serverTemplateId, String containerId, String caseId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        CaseServicesClient client = (CaseServicesClient)this.getClient(serverTemplateId, containerId, CaseServicesClient.class);
        client.destroyCaseInstance(containerId, caseId);
    }

    public CaseInstanceSummary getCaseInstance(String serverTemplateId, String containerId, String caseId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return null;
        }
        CaseServicesClient client = (CaseServicesClient)this.getClient(serverTemplateId, CaseServicesClient.class);
        return Optional.ofNullable(client.getCaseInstance(containerId, caseId, true, true, true, true)).map(new CaseInstanceMapper()).orElse(null);
    }

    public void assignUserToRole(String serverTemplateId, String containerId, String caseId, String roleName, String user) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        CaseServicesClient client = (CaseServicesClient)this.getClient(serverTemplateId, CaseServicesClient.class);
        client.assignUserToRole(containerId, caseId, roleName, user);
    }

    public void assignGroupToRole(String serverTemplateId, String containerId, String caseId, String roleName, String group) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        CaseServicesClient client = (CaseServicesClient)this.getClient(serverTemplateId, CaseServicesClient.class);
        client.assignGroupToRole(containerId, caseId, roleName, group);
    }

    public void removeUserFromRole(String serverTemplateId, String containerId, String caseId, String roleName, String user) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        CaseServicesClient client = (CaseServicesClient)this.getClient(serverTemplateId, CaseServicesClient.class);
        client.removeUserFromRole(containerId, caseId, roleName, user);
    }

    public void removeGroupFromRole(String serverTemplateId, String containerId, String caseId, String roleName, String group) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        CaseServicesClient client = (CaseServicesClient)this.getClient(serverTemplateId, CaseServicesClient.class);
        client.removeGroupFromRole(containerId, caseId, roleName, group);
    }
}

