/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.backend.server;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jbpm.console.ng.cm.backend.server.CaseCommentMapperTest;
import org.jbpm.console.ng.cm.backend.server.CaseDefinitionMapperTest;
import org.jbpm.console.ng.cm.backend.server.CaseInstanceMapperTest;
import org.jbpm.console.ng.cm.backend.server.RemoteCaseManagementServiceImpl;
import org.jbpm.console.ng.cm.model.CaseCommentSummary;
import org.jbpm.console.ng.cm.model.CaseDefinitionSummary;
import org.jbpm.console.ng.cm.model.CaseInstanceSummary;
import org.jbpm.console.ng.cm.model.CaseMilestoneSummary;
import org.jbpm.console.ng.cm.util.CaseInstanceSearchRequest;
import org.jbpm.console.ng.cm.util.CaseInstanceSortBy;
import org.jbpm.console.ng.cm.util.CaseMilestoneSearchRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.cases.CaseComment;
import org.kie.server.api.model.cases.CaseDefinition;
import org.kie.server.api.model.cases.CaseInstance;
import org.kie.server.api.model.cases.CaseMilestone;
import org.kie.server.client.CaseServicesClient;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RemoteCaseManagementServiceImplTest {
    final String serverTemplateId = "serverTemplateId";
    final String containerId = "containerId";
    final String caseDefinitionId = "caseDefinitionId";
    final String caseId = "CASE-1";
    final String caseName = "case name";
    final String caseDescription = "case description";
    final String author = "author";
    final String text = "text";
    final String commentId = "commentId";
    @Mock
    CaseServicesClient clientMock;
    @InjectMocks
    RemoteCaseManagementServiceImpl testedService;

    @Test
    public void testGetCaseDefinitions_singleCaseDefinition() {
        CaseDefinition definition = this.createTestDefinition();
        Mockito.when((Object)this.clientMock.getCaseDefinitions(Integer.valueOf(Matchers.anyInt()), Integer.valueOf(Matchers.anyInt()))).thenReturn(Collections.singletonList(definition));
        List definitions = this.testedService.getCaseDefinitions();
        Assert.assertNotNull((Object)definitions);
        Assert.assertEquals((long)1L, (long)definitions.size());
        CaseDefinitionMapperTest.assertCaseDefinition(definition, (CaseDefinitionSummary)definitions.get(0));
    }

    @Test
    public void testGetCaseDefinitions_emptyList() {
        Mockito.when((Object)this.clientMock.getCaseDefinitions(Integer.valueOf(Matchers.anyInt()), Integer.valueOf(Matchers.anyInt()))).thenReturn(Collections.emptyList());
        List definitions = this.testedService.getCaseDefinitions();
        Assert.assertNotNull((Object)definitions);
        Assert.assertTrue((boolean)definitions.isEmpty());
    }

    @Test
    public void getCaseDefinition_whenClientReturnsCaseDefinition() {
        CaseDefinition definition = this.createTestDefinition();
        Mockito.when((Object)this.clientMock.getCaseDefinition(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)definition);
        CaseDefinitionSummary actualDef = this.testedService.getCaseDefinition("serverTemplateId", "containerId", "caseDefinitionId");
        CaseDefinitionMapperTest.assertCaseDefinition(definition, actualDef);
    }

    @Test
    public void getCaseDefinition_whenClientReturnsNull() {
        Mockito.when((Object)this.clientMock.getCaseDefinition(Matchers.anyString(), Matchers.anyString())).thenReturn(null);
        CaseDefinitionSummary shouldBeNull = this.testedService.getCaseDefinition("serverTemplateId", "containerId", "caseDefinitionId");
        Assert.assertNull((Object)shouldBeNull);
    }

    @Test
    public void getCaseInstances_singleCaseInstance() {
        CaseInstanceSearchRequest request = new CaseInstanceSearchRequest();
        CaseInstance instance = this.createTestInstance("CASE-1");
        Mockito.when((Object)this.clientMock.getCaseInstances((List)Matchers.eq(Collections.singletonList(request.getStatus())), Integer.valueOf(Matchers.anyInt()), Integer.valueOf(Matchers.anyInt()))).thenReturn(Collections.singletonList(instance));
        List instances = this.testedService.getCaseInstances(request);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        CaseInstanceMapperTest.assertCaseInstance(instance, (CaseInstanceSummary)instances.get(0));
    }

    @Test
    public void getCaseInstances_emptyList() {
        CaseInstanceSearchRequest request = new CaseInstanceSearchRequest();
        Mockito.when((Object)this.clientMock.getCaseInstances((List)Matchers.eq(Collections.singletonList(request.getStatus())), Integer.valueOf(Matchers.anyInt()), Integer.valueOf(Matchers.anyInt()))).thenReturn(Collections.emptyList());
        List instances = this.testedService.getCaseInstances(request);
        Assert.assertNotNull((Object)instances);
        Assert.assertTrue((boolean)instances.isEmpty());
    }

    @Test
    public void getCaseInstances_sortCaseInstanceList() {
        CaseInstance c1 = this.createTestInstance("id1");
        c1.setStartedAt(new Date(10000L));
        CaseInstance c2 = this.createTestInstance("id2");
        c2.setStartedAt(new Date(10L));
        Mockito.when((Object)this.clientMock.getCaseInstances(Matchers.anyList(), Integer.valueOf(Matchers.anyInt()), Integer.valueOf(Matchers.anyInt()))).thenReturn(Arrays.asList(c1, c2));
        CaseInstanceSearchRequest defaultSortRequest = new CaseInstanceSearchRequest();
        List sortedInstances = this.testedService.getCaseInstances(defaultSortRequest);
        Assert.assertEquals((Object)"id1", (Object)((CaseInstanceSummary)sortedInstances.get(0)).getCaseId());
        Assert.assertEquals((Object)"id2", (Object)((CaseInstanceSummary)sortedInstances.get(1)).getCaseId());
        CaseInstanceSearchRequest sortByIdRequest = new CaseInstanceSearchRequest();
        sortByIdRequest.setSortBy(CaseInstanceSortBy.CASE_ID);
        sortByIdRequest.setSortByAsc(Boolean.valueOf(true));
        sortedInstances = this.testedService.getCaseInstances(sortByIdRequest);
        Assert.assertEquals((Object)"id1", (Object)((CaseInstanceSummary)sortedInstances.get(0)).getCaseId());
        Assert.assertEquals((Object)"id2", (Object)((CaseInstanceSummary)sortedInstances.get(1)).getCaseId());
        sortByIdRequest.setSortByAsc(Boolean.valueOf(false));
        sortedInstances = this.testedService.getCaseInstances(sortByIdRequest);
        Assert.assertEquals((Object)"id2", (Object)((CaseInstanceSummary)sortedInstances.get(0)).getCaseId());
        Assert.assertEquals((Object)"id1", (Object)((CaseInstanceSummary)sortedInstances.get(1)).getCaseId());
        CaseInstanceSearchRequest sortByStarted = new CaseInstanceSearchRequest();
        sortByStarted.setSortBy(CaseInstanceSortBy.START_TIME);
        sortByStarted.setSortByAsc(Boolean.valueOf(true));
        sortedInstances = this.testedService.getCaseInstances(sortByStarted);
        Assert.assertEquals((Object)"id2", (Object)((CaseInstanceSummary)sortedInstances.get(0)).getCaseId());
        Assert.assertEquals((Object)"id1", (Object)((CaseInstanceSummary)sortedInstances.get(1)).getCaseId());
        sortByStarted.setSortByAsc(Boolean.valueOf(false));
        sortedInstances = this.testedService.getCaseInstances(sortByStarted);
        Assert.assertEquals((Object)"id1", (Object)((CaseInstanceSummary)sortedInstances.get(0)).getCaseId());
        Assert.assertEquals((Object)"id2", (Object)((CaseInstanceSummary)sortedInstances.get(1)).getCaseId());
    }

    @Test
    public void testStartCaseInstance() {
        this.testedService.startCaseInstance("serverTemplateId", "containerId", "caseDefinitionId");
        ((CaseServicesClient)Mockito.verify((Object)this.clientMock)).startCase("containerId", "caseDefinitionId");
    }

    @Test
    public void testCancelCaseInstance() {
        this.testedService.cancelCaseInstance("serverTemplateId", "containerId", "CASE-1");
        ((CaseServicesClient)Mockito.verify((Object)this.clientMock)).cancelCaseInstance("containerId", "CASE-1");
    }

    @Test
    public void testDestroyCaseInstance() {
        this.testedService.destroyCaseInstance("serverTemplateId", "containerId", "CASE-1");
        ((CaseServicesClient)Mockito.verify((Object)this.clientMock)).destroyCaseInstance("containerId", "CASE-1");
    }

    @Test
    public void getCaseInstance_whenClientReturnsInstance() {
        CaseInstance ci = this.createTestInstance("CASE-1");
        Mockito.when((Object)this.clientMock.getCaseInstance(ci.getContainerId(), ci.getCaseId(), true, true, true, true)).thenReturn((Object)ci);
        CaseInstanceSummary cis = this.testedService.getCaseInstance("serverTemplateId", ci.getContainerId(), ci.getCaseId());
        CaseInstanceMapperTest.assertCaseInstance(ci, cis);
    }

    @Test
    public void getCaseInstance_whenClientReturnsNull() {
        Mockito.when((Object)this.clientMock.getCaseInstance("containerId", "CASE-1", true, true, true, true)).thenReturn(null);
        CaseInstanceSummary cis = this.testedService.getCaseInstance("serverTemplateId", "containerId", "CASE-1");
        Assert.assertNull((Object)cis);
    }

    @Test
    public void testGetComments_singleComment() {
        CaseComment caseComment = this.createTestComment();
        Mockito.when((Object)this.clientMock.getComments("containerId", "CASE-1", Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE))).thenReturn(Collections.singletonList(caseComment));
        List comments = this.testedService.getComments("serverTemplateId", "containerId", "CASE-1");
        Assert.assertNotNull((Object)comments);
        Assert.assertEquals((long)1L, (long)comments.size());
        CaseCommentMapperTest.assertCaseComment(caseComment, (CaseCommentSummary)comments.get(0));
    }

    @Test
    public void testGetComments_emptyList() {
        Mockito.when((Object)this.clientMock.getComments("containerId", "CASE-1", Integer.valueOf(0), Integer.valueOf(0))).thenReturn(Collections.emptyList());
        List comments = this.testedService.getComments("serverTemplateId", "containerId", "CASE-1");
        Assert.assertNotNull((Object)comments);
        Assert.assertTrue((boolean)comments.isEmpty());
    }

    @Test
    public void testAddComment() {
        this.testedService.addComment("serverTemplateId", "containerId", "CASE-1", "author", "text");
        ((CaseServicesClient)Mockito.verify((Object)this.clientMock)).addComment("containerId", "CASE-1", "author", "text");
    }

    @Test
    public void testUpdateComment() {
        this.testedService.updateComment("serverTemplateId", "containerId", "CASE-1", "commentId", "author", "text");
        ((CaseServicesClient)Mockito.verify((Object)this.clientMock)).updateComment("containerId", "CASE-1", "commentId", "author", "text");
    }

    @Test
    public void testRemoveComment() {
        this.testedService.removeComment("serverTemplateId", "containerId", "CASE-1", "commentId");
        ((CaseServicesClient)Mockito.verify((Object)this.clientMock)).removeComment("containerId", "CASE-1", "commentId");
    }

    @Test
    public void getCaseMilestones_sorting() {
        CaseMilestone c1 = this.createTestMilestone("id1", "milestone1", "Available");
        CaseMilestone c2 = this.createTestMilestone("id2", "milestone2", "Available");
        CaseMilestone c3 = this.createTestMilestone("id3", "milestone3", "Completed");
        Mockito.when((Object)this.clientMock.getMilestones(Matchers.anyString(), Matchers.anyString(), Mockito.anyBoolean(), Integer.valueOf(Matchers.anyInt()), Integer.valueOf(Matchers.anyInt()))).thenReturn(Arrays.asList(c1, c2, c3));
        CaseMilestoneSearchRequest defaultSortRequest = new CaseMilestoneSearchRequest();
        List sortedMilestones = this.testedService.getCaseMilestones("containerId", "caseId", defaultSortRequest);
        Assert.assertEquals((Object)"id1", (Object)((CaseMilestoneSummary)sortedMilestones.get(0)).getIdentifier());
        Assert.assertEquals((Object)"id2", (Object)((CaseMilestoneSummary)sortedMilestones.get(1)).getIdentifier());
        Assert.assertEquals((Object)"id3", (Object)((CaseMilestoneSummary)sortedMilestones.get(2)).getIdentifier());
        CaseMilestoneSearchRequest sortByNameAscRequest = new CaseMilestoneSearchRequest();
        sortByNameAscRequest.setSortByAsc(Boolean.valueOf(true));
        sortedMilestones = this.testedService.getCaseMilestones("containerId", "caseId", sortByNameAscRequest);
        Assert.assertEquals((Object)"id1", (Object)((CaseMilestoneSummary)sortedMilestones.get(0)).getIdentifier());
        Assert.assertEquals((Object)"id2", (Object)((CaseMilestoneSummary)sortedMilestones.get(1)).getIdentifier());
        Assert.assertEquals((Object)"id3", (Object)((CaseMilestoneSummary)sortedMilestones.get(2)).getIdentifier());
        CaseMilestoneSearchRequest sortByNameDescRequest = new CaseMilestoneSearchRequest();
        sortByNameDescRequest.setSortByAsc(Boolean.valueOf(false));
        sortedMilestones = this.testedService.getCaseMilestones("containerId", "caseId", sortByNameDescRequest);
        Assert.assertEquals((Object)"id2", (Object)((CaseMilestoneSummary)sortedMilestones.get(0)).getIdentifier());
        Assert.assertEquals((Object)"id1", (Object)((CaseMilestoneSummary)sortedMilestones.get(1)).getIdentifier());
        Assert.assertEquals((Object)"id3", (Object)((CaseMilestoneSummary)sortedMilestones.get(2)).getIdentifier());
    }

    private CaseDefinition createTestDefinition() {
        CaseDefinition definition = CaseDefinition.builder().id("caseDefinitionId").name("case name").containerId("containerId").roles(Collections.emptyMap()).build();
        return definition;
    }

    private CaseInstance createTestInstance(String caseId) {
        CaseInstance instance = CaseInstance.builder().caseDescription("case description").caseId(caseId).caseStatus(Integer.valueOf(1)).containerId("containerId").build();
        return instance;
    }

    private CaseComment createTestComment() {
        CaseComment comment = CaseComment.builder().id("commentId").author("author").text("text").addedAt(new Date()).build();
        return comment;
    }

    private CaseMilestone createTestMilestone(String caseMilestoneId, String caseMilestoneName, String status) {
        CaseMilestone milestone = CaseMilestone.builder().name(caseMilestoneName).status(status).id(caseMilestoneId).achieved(false).build();
        return milestone;
    }
}

