/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dashboard.renderer.backend;

import java.util.Arrays;
import java.util.List;
import org.dashbuilder.DataSetCore;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetLookupFactory;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.jbpm.dashboard.renderer.backend.DataSetDefsBootstrap;
import org.jbpm.dashboard.renderer.backend.DeploymentIdsPreprocessor;
import org.jbpm.kie.services.impl.security.DeploymentRolesManager;
import org.jbpm.persistence.settings.JpaSettings;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.internal.identity.IdentityProvider;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DataSetDefsBootstrapTest {
    @Mock
    DeploymentRolesManager deploymentRolesManager;
    @Mock
    IdentityProvider identityProvider;
    @Mock
    JpaSettings jpaSettings;
    @Spy
    DeploymentIdsPreprocessor deploymentIdsPreprocessor;
    @Spy
    DataSetDefRegistry dataSetRegistry = DataSetCore.get().getDataSetDefRegistry();
    @Spy
    DataSetManager dataSetManager = DataSetCore.get().getDataSetManager();
    @InjectMocks
    DataSetDefsBootstrap dataSetsBootstrap;
    List<String> deploymentIds = Arrays.asList("role1", "role2");

    @Before
    public void setUp() {
        this.deploymentIdsPreprocessor.deploymentRolesManager = this.deploymentRolesManager;
        this.deploymentIdsPreprocessor.identityProvider = this.identityProvider;
        this.dataSetsBootstrap.registerDataSetDefinitions();
        Mockito.when((Object)this.deploymentRolesManager.getDeploymentsForUser(this.identityProvider)).thenReturn(this.deploymentIds);
    }

    @Test
    public void registerDataSetDefsTest() {
        ArgumentCaptor argument = ArgumentCaptor.forClass(DataSetDef.class);
        ((DataSetDefRegistry)Mockito.verify((Object)this.dataSetRegistry, (VerificationMode)Mockito.times((int)2))).registerDataSetDef((DataSetDef)argument.capture());
        List dataSetDefList = argument.getAllValues();
        Assert.assertEquals((long)dataSetDefList.size(), (long)2L);
        Assert.assertEquals((Object)((DataSetDef)dataSetDefList.get(0)).getUUID(), (Object)"processesMonitoring");
        Assert.assertEquals((Object)((DataSetDef)dataSetDefList.get(1)).getUUID(), (Object)"tasksMonitoring");
    }

    @Test
    public void procInstancesPreprocessorTest() {
        DataSetLookup lookup = ((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("processesMonitoring")).buildLookup();
        this.dataSetManager.lookupDataSet(lookup);
        ArgumentCaptor argument = ArgumentCaptor.forClass(DataSetLookup.class);
        ((DeploymentIdsPreprocessor)Mockito.verify((Object)this.deploymentIdsPreprocessor)).preprocess(lookup);
        ((DataSetManager)Mockito.verify((Object)this.dataSetManager)).lookupDataSet((DataSetLookup)argument.capture());
        Assert.assertEquals((Object)argument.getValue(), (Object)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("processesMonitoring")).filter(new ColumnFilter[]{FilterFactory.in((String)"externalId", this.deploymentIds)})).buildLookup());
    }

    @Test
    public void tasksPreprocessorTest() {
        DataSetLookup lookup = ((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("tasksMonitoring")).buildLookup();
        this.dataSetManager.lookupDataSet(lookup);
        ArgumentCaptor argument = ArgumentCaptor.forClass(DataSetLookup.class);
        ((DeploymentIdsPreprocessor)Mockito.verify((Object)this.deploymentIdsPreprocessor)).preprocess(lookup);
        ((DataSetManager)Mockito.verify((Object)this.dataSetManager)).lookupDataSet((DataSetLookup)argument.capture());
        Assert.assertEquals((Object)argument.getValue(), (Object)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("tasksMonitoring")).filter(new ColumnFilter[]{FilterFactory.in((String)"externalId", this.deploymentIds)})).buildLookup());
    }
}

