/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dashboard.renderer.client.panel;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.AbstractDisplayerListener;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerCoordinator;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.client.DisplayerLocator;
import org.dashbuilder.renderer.client.metric.MetricDisplayer;
import org.dashbuilder.renderer.client.table.TableDisplayer;
import org.jbpm.console.ng.ht.model.events.TaskSelectionEvent;
import org.jbpm.dashboard.renderer.client.panel.AbstractDashboard;
import org.jbpm.dashboard.renderer.client.panel.DashboardFactory;
import org.jbpm.dashboard.renderer.client.panel.DashboardKpis;
import org.jbpm.dashboard.renderer.client.panel.events.ProcessDashboardFocusEvent;
import org.jbpm.dashboard.renderer.client.panel.events.TaskDashboardFocusEvent;
import org.jbpm.dashboard.renderer.client.panel.formatter.DurationFormatter;
import org.jbpm.dashboard.renderer.client.panel.widgets.ProcessBreadCrumb;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.mvp.Command;

@Dependent
public class TaskDashboard
extends AbstractDashboard
implements IsWidget {
    protected View view;
    protected Event<TaskSelectionEvent> taskSelectionEvent;
    protected Event<TaskDashboardFocusEvent> taskDashboardFocusEvent;
    protected MetricDisplayer totalMetric;
    protected MetricDisplayer createdMetric;
    protected MetricDisplayer readyMetric;
    protected MetricDisplayer reservedMetric;
    protected MetricDisplayer inProgressMetric;
    protected MetricDisplayer suspendedMetric;
    protected MetricDisplayer completedMetric;
    protected MetricDisplayer failedMetric;
    protected MetricDisplayer errorMetric;
    protected MetricDisplayer exitedMetric;
    protected MetricDisplayer obsoleteMetric;
    protected AbstractDisplayer tasksByProcess;
    protected AbstractDisplayer tasksByOwner;
    protected AbstractDisplayer tasksByCreationDate;
    protected AbstractDisplayer tasksByEndDate;
    protected AbstractDisplayer tasksByRunningTime;
    protected AbstractDisplayer tasksByStatus;
    protected TableDisplayer tasksTable;
    protected List<Displayer> metricsGroup = new ArrayList<Displayer>();
    protected List<Displayer> metricsGroupOptional = new ArrayList<Displayer>();
    protected List<Displayer> chartsGroup = new ArrayList<Displayer>();
    protected String totalTasksTitle;
    public static final String TASK_DETAILS_SCREEN_ID = "Task Details Multi";
    DisplayerListener dashboardListener = new AbstractDisplayerListener(){

        public void onDraw(Displayer displayer) {
            DataSet ds;
            if (TaskDashboard.this.totalMetric == displayer && (ds = displayer.getDataSetHandler().getLastDataSet()).getRowCount() == 0) {
                TaskDashboard.this.showBlankDashboard();
            }
        }

        public void onFilterEnabled(Displayer displayer, DataSetGroup groupOp) {
            if ("processName".equals(groupOp.getColumnGroup().getSourceId())) {
                Interval interval = (Interval)groupOp.getSelectedIntervalList().get(0);
                TaskDashboard.this.changeCurrentProcess(interval.getName());
            }
        }

        public void onFilterReset(Displayer displayer, List<DataSetGroup> groupOps) {
            for (DataSetGroup groupOp : groupOps) {
                if (!"processName".equals(groupOp.getColumnGroup().getSourceId())) continue;
                TaskDashboard.this.resetCurrentProcess();
                return;
            }
        }

        public void onFilterEnabled(Displayer displayer, DataSetFilter filter) {
            if (TaskDashboard.this.metricsGroup.contains(displayer)) {
                TaskDashboard.this.changeCurrentMetric((MetricDisplayer)displayer);
            }
        }

        public void onFilterReset(Displayer displayer, DataSetFilter filter) {
            if (TaskDashboard.this.metricsGroup.contains(displayer)) {
                TaskDashboard.this.resetCurrentMetric();
            }
        }
    };

    @Inject
    public TaskDashboard(View view, ProcessBreadCrumb processBreadCrumb, DashboardFactory dashboardFactory, DataSetClientServices dataSetClientServices, DisplayerLocator displayerLocator, DisplayerCoordinator displayerCoordinator, PlaceManager placeManager, Event<TaskSelectionEvent> taskSelectionEvent, Event<TaskDashboardFocusEvent> taskDashboardFocusEvent) {
        super(dashboardFactory, dataSetClientServices, placeManager, view.getI18nService(), processBreadCrumb, displayerLocator, displayerCoordinator);
        this.view = view;
        this.taskSelectionEvent = taskSelectionEvent;
        this.taskDashboardFocusEvent = taskDashboardFocusEvent;
        this.init();
    }

    protected void init() {
        this.processBreadCrumb.setOnRootSelectedCommand(new Command(){

            public void execute() {
                TaskDashboard.this.resetProcessBreadcrumb();
            }
        });
        this.view.showLoading();
        DisplayerSettings totalTasks = DashboardKpis.tasksTotal(this.i18n);
        this.totalTasksTitle = totalTasks.getTitle();
        this.totalMetric = this.createMetricDisplayer(totalTasks);
        this.createdMetric = this.createMetricDisplayer(DashboardKpis.tasksCreated(this.i18n));
        this.readyMetric = this.createMetricDisplayer(DashboardKpis.tasksReady(this.i18n));
        this.reservedMetric = this.createMetricDisplayer(DashboardKpis.tasksReserved(this.i18n));
        this.inProgressMetric = this.createMetricDisplayer(DashboardKpis.tasksInProgress(this.i18n));
        this.suspendedMetric = this.createMetricDisplayer(DashboardKpis.tasksSuspended(this.i18n));
        this.completedMetric = this.createMetricDisplayer(DashboardKpis.tasksCompleted(this.i18n));
        this.failedMetric = this.createMetricDisplayer(DashboardKpis.tasksFailed(this.i18n));
        this.errorMetric = this.createMetricDisplayer(DashboardKpis.tasksError(this.i18n));
        this.exitedMetric = this.createMetricDisplayer(DashboardKpis.tasksExited(this.i18n));
        this.obsoleteMetric = this.createMetricDisplayer(DashboardKpis.tasksObsolete(this.i18n));
        this.tasksByProcess = this.createDisplayer(DashboardKpis.tasksByProcess(this.i18n));
        this.tasksByOwner = this.createDisplayer(DashboardKpis.tasksByOwner(this.i18n));
        this.tasksByCreationDate = this.createDisplayer(DashboardKpis.tasksByCreationDate(this.i18n));
        this.tasksByEndDate = this.createDisplayer(DashboardKpis.tasksByEndDate(this.i18n));
        this.tasksByRunningTime = this.createDisplayer(DashboardKpis.tasksByRunningTime(this.i18n));
        this.tasksByStatus = this.createDisplayer(DashboardKpis.tasksByStatus(this.i18n));
        this.tasksTable = this.createTableDisplayer(DashboardKpis.tasksTable(this.i18n), "duration", new DurationFormatter("createdDate", "endDate"));
        this.view.init(this, (Displayer)this.totalMetric, (Displayer)this.createdMetric, (Displayer)this.readyMetric, (Displayer)this.reservedMetric, (Displayer)this.inProgressMetric, (Displayer)this.suspendedMetric, (Displayer)this.completedMetric, (Displayer)this.failedMetric, (Displayer)this.errorMetric, (Displayer)this.exitedMetric, (Displayer)this.obsoleteMetric, (Displayer)this.tasksByProcess, (Displayer)this.tasksByOwner, (Displayer)this.tasksByCreationDate, (Displayer)this.tasksByEndDate, (Displayer)this.tasksByRunningTime, (Displayer)this.tasksByStatus, (Displayer)this.tasksTable);
        this.metricsGroup.add((Displayer)this.totalMetric);
        this.metricsGroup.add((Displayer)this.readyMetric);
        this.metricsGroup.add((Displayer)this.reservedMetric);
        this.metricsGroup.add((Displayer)this.inProgressMetric);
        this.metricsGroup.add((Displayer)this.suspendedMetric);
        this.metricsGroup.add((Displayer)this.completedMetric);
        this.metricsGroupOptional.add((Displayer)this.createdMetric);
        this.metricsGroupOptional.add((Displayer)this.failedMetric);
        this.metricsGroupOptional.add((Displayer)this.errorMetric);
        this.metricsGroupOptional.add((Displayer)this.exitedMetric);
        this.metricsGroupOptional.add((Displayer)this.obsoleteMetric);
        this.chartsGroup.add((Displayer)this.tasksByProcess);
        this.chartsGroup.add((Displayer)this.tasksByCreationDate);
        this.chartsGroup.add((Displayer)this.tasksByEndDate);
        this.chartsGroup.add((Displayer)this.tasksByOwner);
        this.chartsGroup.add((Displayer)this.tasksByRunningTime);
        this.chartsGroup.add((Displayer)this.tasksByStatus);
        this.chartsGroup.add((Displayer)this.tasksTable);
        this.displayerCoordinator.addDisplayers(this.metricsGroup);
        this.displayerCoordinator.addDisplayers(this.metricsGroupOptional);
        this.displayerCoordinator.addDisplayers(this.chartsGroup);
        this.displayerCoordinator.addNotificationVeto(this.metricsGroup);
        this.displayerCoordinator.addListener(new DisplayerListener[]{this.dashboardListener});
        this.displayerCoordinator.drawAll(new Command(){

            public void execute() {
                TaskDashboard.this.view.hideLoading();
                TaskDashboard.this.totalMetric.filterApply();
            }
        }, new Command(){

            public void execute() {
                TaskDashboard.this.view.hideLoading();
            }
        });
    }

    public MetricDisplayer getTotalMetric() {
        return this.totalMetric;
    }

    public MetricDisplayer getCreatedMetric() {
        return this.createdMetric;
    }

    public MetricDisplayer getReadyMetric() {
        return this.readyMetric;
    }

    public MetricDisplayer getReservedMetric() {
        return this.reservedMetric;
    }

    public MetricDisplayer getInProgressMetric() {
        return this.inProgressMetric;
    }

    public MetricDisplayer getSuspendedMetric() {
        return this.suspendedMetric;
    }

    public MetricDisplayer getCompletedMetric() {
        return this.completedMetric;
    }

    public MetricDisplayer getFailedMetric() {
        return this.failedMetric;
    }

    public MetricDisplayer getErrorMetric() {
        return this.errorMetric;
    }

    public MetricDisplayer getExitedMetric() {
        return this.exitedMetric;
    }

    public MetricDisplayer getObsoleteMetric() {
        return this.obsoleteMetric;
    }

    public AbstractDisplayer getTasksByProcess() {
        return this.tasksByProcess;
    }

    public AbstractDisplayer getTasksByOwner() {
        return this.tasksByOwner;
    }

    public AbstractDisplayer getTasksByCreationDate() {
        return this.tasksByCreationDate;
    }

    public AbstractDisplayer getTasksByEndDate() {
        return this.tasksByEndDate;
    }

    public AbstractDisplayer getTasksByRunningTime() {
        return this.tasksByRunningTime;
    }

    public AbstractDisplayer getTasksByStatus() {
        return this.tasksByStatus;
    }

    public TableDisplayer getTasksTable() {
        return this.tasksTable;
    }

    @Override
    public AbstractDashboard.View getView() {
        return this.view;
    }

    @Override
    public void resetProcessBreadcrumb() {
        this.tasksByProcess.filterReset();
        this.tasksByRunningTime.filterReset();
        this.tasksByProcess.redraw();
        this.tasksByRunningTime.redraw();
        this.view.hideBreadCrumb();
    }

    public void showBlankDashboard() {
    }

    @Override
    public void updateHeaderText() {
        if (this.selectedProcess == null) {
            String selected;
            String string = selected = this.selectedMetric != null ? this.selectedMetric.getDisplayerSettings().getTitle() : null;
            if (selected == null || this.totalTasksTitle.equals(selected)) {
                this.view.setHeaderText(this.i18n.allTasks());
            } else {
                this.view.setHeaderText(selected);
            }
        } else {
            String status = "";
            if (this.createdMetric == this.selectedMetric) {
                status = this.i18n.taskStatusCreated();
            } else if (this.readyMetric == this.selectedMetric) {
                status = this.i18n.taskStatusReady();
            } else if (this.reservedMetric == this.selectedMetric) {
                status = this.i18n.taskStatusReserved();
            } else if (this.inProgressMetric == this.selectedMetric) {
                status = this.i18n.taskStatusInProgress();
            } else if (this.suspendedMetric == this.selectedMetric) {
                status = this.i18n.taskStatusSuspended();
            } else if (this.completedMetric == this.selectedMetric) {
                status = this.i18n.taskStatusCompleted();
            } else if (this.failedMetric == this.selectedMetric) {
                status = this.i18n.taskStatusFailed();
            } else if (this.errorMetric == this.selectedMetric) {
                status = this.i18n.taskStatusError();
            } else if (this.exitedMetric == this.selectedMetric) {
                status = this.i18n.taskStatusExited();
            } else if (this.obsoleteMetric == this.selectedMetric) {
                status = this.i18n.taskStatusObsolete();
            }
            this.view.setHeaderText(this.i18n.selectedTaskStatusHeader(status, this.selectedProcess));
        }
    }

    @Override
    public void tableCellSelected(String columnId, int rowIndex) {
        DataSet ds = this.tasksTable.getDataSetHandler().getLastDataSet();
        Long taskId = Double.valueOf(ds.getValueAt(rowIndex, "taskId").toString()).longValue();
        String taskName = ds.getValueAt(rowIndex, "taskName").toString();
        this.openTaskDetailsScreen();
        this.taskSelectionEvent.fire((Object)new TaskSelectionEvent(taskId, taskName, false, true));
    }

    public void showDashboard() {
        this.view.showDashboard();
        this.taskDashboardFocusEvent.fire((Object)new TaskDashboardFocusEvent());
        this.closeTaskDetailsScreen();
    }

    public void showTasksTable() {
        this.view.showInstances();
        this.taskDashboardFocusEvent.fire((Object)new TaskDashboardFocusEvent());
        this.tasksTable.redraw();
    }

    public void openTaskDetailsScreen() {
        this.taskDashboardFocusEvent.fire((Object)new TaskDashboardFocusEvent());
        PlaceStatus status = this.placeManager.getStatus(TASK_DETAILS_SCREEN_ID);
        if (status == PlaceStatus.CLOSE) {
            this.placeManager.goTo(TASK_DETAILS_SCREEN_ID);
        }
    }

    public void closeTaskDetailsScreen() {
        PlaceStatus status = this.placeManager.getStatus(TASK_DETAILS_SCREEN_ID);
        if (status == PlaceStatus.OPEN) {
            this.placeManager.closePlace(TASK_DETAILS_SCREEN_ID);
        }
    }

    public void onManagingTasks(@Observes ProcessDashboardFocusEvent event) {
        this.closeTaskDetailsScreen();
    }

    public static interface View
    extends AbstractDashboard.View {
        public void init(TaskDashboard var1, Displayer var2, Displayer var3, Displayer var4, Displayer var5, Displayer var6, Displayer var7, Displayer var8, Displayer var9, Displayer var10, Displayer var11, Displayer var12, Displayer var13, Displayer var14, Displayer var15, Displayer var16, Displayer var17, Displayer var18, Displayer var19);
    }
}

