/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.documents.backend.server.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.drools.core.common.DroolsObjectInputStream;
import org.jbpm.console.ng.dm.model.DocumentSummary;
import org.jbpm.console.ng.documents.backend.server.DocumentService;
import org.jbpm.console.ng.documents.backend.server.DocumentServiceCMISImpl;
import org.jbpm.document.Document;
import org.kie.api.marshalling.ObjectMarshallingStrategy;

public class CMISDocumentMarshallingStrategy
implements ObjectMarshallingStrategy {
    private DocumentService documentService = new DocumentServiceCMISImpl();

    public CMISDocumentMarshallingStrategy() {
        this.documentService.init();
    }

    public boolean accept(Object o) {
        return o instanceof Document;
    }

    public void write(ObjectOutputStream os, Object object) throws IOException {
        Document document = (Document)object;
        this.documentService.createDocument(new DocumentSummary(document.getName(), "", "/"));
    }

    public Object read(ObjectInputStream os) throws IOException, ClassNotFoundException {
        String objectId = os.readUTF();
        String canonicalName = os.readUTF();
        String link = os.readUTF();
        try {
            DocumentSummary doc = (DocumentSummary)this.documentService.getDocument(objectId);
            Document document = (Document)Class.forName(canonicalName).newInstance();
            document.setIdentifier(objectId);
            document.setLink(link);
            document.setName(doc.getName());
            document.setSize(10L);
            document.setLastModified(new Date());
            document.setAttributes(new HashMap());
            document.setContent(doc.getContent());
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot read document", e);
        }
    }

    public byte[] marshal(ObjectMarshallingStrategy.Context context, ObjectOutputStream os, Object object) throws IOException {
        String path = "/";
        Document document = (Document)object;
        DocumentSummary summary = new DocumentSummary(document.getName(), "", path);
        summary.setContent(document.getContent());
        this.documentService.createDocument(summary);
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(buff);
        oos.writeUTF(summary.getId());
        oos.writeUTF(document.getClass().getCanonicalName());
        String link = "http://localhost:8080/magnoliaAuthor/dms" + path + document.getName();
        oos.writeUTF(link);
        oos.close();
        return buff.toByteArray();
    }

    public Object unmarshal(ObjectMarshallingStrategy.Context context, ObjectInputStream objectInputStream, byte[] object, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        DroolsObjectInputStream is = new DroolsObjectInputStream((InputStream)new ByteArrayInputStream(object), classLoader);
        String objectId = is.readUTF();
        String canonicalName = is.readUTF();
        String link = is.readUTF();
        Document document = null;
        try {
            document = (Document)Class.forName(canonicalName).newInstance();
            DocumentSummary storedDoc = (DocumentSummary)this.documentService.getDocument(objectId);
            document.setIdentifier(storedDoc.getId());
            document.setName(storedDoc.getName());
            document.setLink(link);
            document.setLastModified(new Date());
            document.setSize(10L);
            document.setAttributes(new HashMap());
            InputStream stream = this.documentService.getDocumentContent(objectId);
            byte[] content = IOUtils.toByteArray((InputStream)stream);
            document.setContent(content);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot read document from storage service", e);
        }
        return document;
    }

    public ObjectMarshallingStrategy.Context createContext() {
        return null;
    }
}

