/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.dm.client.document.newdocument;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.FileUpload;
import com.github.gwtbootstrap.client.ui.Form;
import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.console.ng.dm.client.document.newdocument.NewDocumentPresenter;
import org.jbpm.console.ng.dm.client.i18n.Constants;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
@Templated(value="NewDocumentViewImpl.html")
public class NewDocumentViewImpl
extends Composite
implements NewDocumentPresenter.NewDocumentView {
    private Constants constants = (Constants)GWT.create(Constants.class);
    public TextBox documentNameText = new TextBox();
    public Label documentNameLabel = new Label();
    public TextBox documentFolderText = new TextBox();
    public Hidden hiddenDocumentFolderText = new Hidden();
    public Label documentFolderLabel = new Label();
    public Label newDocTypeLabel = new Label();
    public ListBox newDocType = new ListBox();
    public FileUpload fileUpload = new FileUpload();
    public Label fileUploadLabel = new Label();
    @Inject
    @DataField
    public Button createButton;
    @Inject
    @DataField
    public Form formUpload;
    @Inject
    Event<NotificationEvent> notificationEvents;
    private NewDocumentPresenter presenter;

    public void init(NewDocumentPresenter p) {
        this.presenter = p;
        this.createButton.setText("Create");
        this.createButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                BusyPopup.showMessage((String)"Loading...");
                NewDocumentViewImpl.this.formUpload.submit();
            }
        });
        this.documentNameText.setName("documentName");
        this.hiddenDocumentFolderText.setName("documentFolder");
        this.fileUpload.setName("file");
        this.newDocType.setName("documentType");
        this.newDocTypeLabel.setText("File Type");
        this.newDocTypeLabel.setStyleName("control-label");
        this.documentNameLabel.setText("Document Name");
        this.documentNameLabel.setStyleName("control-label");
        this.documentFolderLabel.setText("Document Folder");
        this.documentFolderLabel.setStyleName("control-label");
        this.fileUploadLabel.setText("Upload");
        this.fileUploadLabel.setStyleName("control-label");
        this.newDocType.addItem("Text File");
        this.newDocType.addItem("PDF");
        this.formUpload.setAction(this.getWebContext() + "/documentview/");
        VerticalPanel allFields = new VerticalPanel();
        HorizontalPanel line = new HorizontalPanel();
        line.setHorizontalAlignment(HorizontalPanel.ALIGN_CENTER);
        line.add((Widget)this.documentFolderLabel);
        line.add((Widget)this.documentFolderText);
        line.add((Widget)this.hiddenDocumentFolderText);
        this.documentFolderText.setName("folder");
        allFields.add((Widget)line);
        line = new HorizontalPanel();
        line.setHorizontalAlignment(HorizontalPanel.ALIGN_CENTER);
        line.add((Widget)this.fileUploadLabel);
        line.add((Widget)this.fileUpload);
        this.fileUpload.setName("file");
        allFields.add((Widget)line);
        this.formUpload.add((Widget)allFields);
        this.formUpload.addSubmitHandler(new Form.SubmitHandler(){

            public void onSubmit(Form.SubmitEvent event) {
                String fileName = NewDocumentViewImpl.this.fileUpload.getFilename();
                if (fileName == null || "".equals(fileName)) {
                    BusyPopup.close();
                    Window.alert((String)"Please select a file!");
                    event.cancel();
                }
            }
        });
        this.formUpload.addSubmitCompleteHandler(new Form.SubmitCompleteHandler(){

            public void onSubmitComplete(Form.SubmitCompleteEvent event) {
                if ("OK".equalsIgnoreCase(event.getResults())) {
                    BusyPopup.close();
                    Window.alert((String)"Great!");
                    NewDocumentViewImpl.this.fileUpload.getElement().setPropertyString("value", "");
                    NewDocumentViewImpl.this.hide();
                } else if ("NO VALID POM".equalsIgnoreCase(event.getResults())) {
                    BusyPopup.close();
                } else {
                    BusyPopup.close();
                    ErrorPopup.showMessage((String)("Something wrong: " + event.getResults()));
                    NewDocumentViewImpl.this.hide();
                }
            }
        });
    }

    @Override
    public void displayNotification(String notification) {
        this.notificationEvents.fire((Object)new NotificationEvent(notification));
    }

    private String getWebContext() {
        String context = GWT.getModuleBaseURL().replace(GWT.getModuleName() + "/", "");
        if (context.endsWith("/")) {
            context = context.substring(0, context.length() - 1);
        }
        return context;
    }

    public void hide() {
        this.presenter.close();
    }

    @Override
    public void setFolder(String folder) {
        this.documentFolderText.setText(folder);
        this.documentFolderText.setEnabled(false);
        this.hiddenDocumentFolderText.setValue(folder);
    }
}

