/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.dm.client.document.CMISconfig;

import com.google.gwt.core.client.GWT;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.TextBox;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.dm.client.i18n.Constants;
import org.jbpm.console.ng.dm.service.DocumentServiceEntryPoint;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.client.workbench.widgets.split.WorkbenchSplitLayoutPanel;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="CMIS Configuration")
public class CMISConfigurationPresenter {
    private PlaceRequest place;
    private Menus menus;
    @Inject
    private ErrorPopupPresenter errorPopup;
    @Inject
    private PlaceManager placeManager;
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private CMISConfigurationView view;
    @Inject
    private Caller<DocumentServiceEntryPoint> dataServices;
    private Map<String, String> configurationParameters;

    public CMISConfigurationPresenter() {
        this.makeMenuBar();
    }

    @DefaultPosition
    public Position getPosition() {
        return CompassPosition.EAST;
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
        this.configurationParameters = new HashMap<String, String>();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.ConfigurationPanel();
    }

    @WorkbenchPartView
    public UberView<CMISConfigurationPresenter> getView() {
        return this.view;
    }

    private void changeStyleRow(String processDefName, String processDefVersion) {
    }

    public void refreshConfigurationParameters() {
        ((DocumentServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<Map<String, String>>(){

            public void callback(Map<String, String> parameters) {
                CMISConfigurationPresenter.this.view.getWSACLTextBox().setText(parameters.get("org.apache.chemistry.opencmis.binding.webservices.ACLService"));
                CMISConfigurationPresenter.this.view.getWSDiscoveryTextBox().setText(parameters.get("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService"));
                CMISConfigurationPresenter.this.view.getWSMultifilingTextBox().setText(parameters.get("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService"));
                CMISConfigurationPresenter.this.view.getWSNavigationTextBox().setText(parameters.get("org.apache.chemistry.opencmis.binding.webservices.NavigationService"));
                CMISConfigurationPresenter.this.view.getWSObjectTextBox().setText(parameters.get("org.apache.chemistry.opencmis.binding.webservices.ObjectService"));
                CMISConfigurationPresenter.this.view.getWSPolicyTextBox().setText(parameters.get("org.apache.chemistry.opencmis.binding.webservices.PolicyService"));
                CMISConfigurationPresenter.this.view.getWSRelationshipTextBox().setText(parameters.get("org.apache.chemistry.opencmis.binding.webservices.RelationshipService"));
                CMISConfigurationPresenter.this.view.getWSRepositoryTextBox().setText(parameters.get("org.apache.chemistry.opencmis.binding.webservices.RepositoryService"));
                CMISConfigurationPresenter.this.view.getWSVersioningTextBox().setText(parameters.get("org.apache.chemistry.opencmis.binding.webservices.VersioningService"));
                CMISConfigurationPresenter.this.view.getRepositoryIDTextBox().setText(parameters.get("org.apache.chemistry.opencmis.session.repository.id"));
                CMISConfigurationPresenter.this.view.getUserTextBox().setText(parameters.get("org.apache.chemistry.opencmis.user"));
                CMISConfigurationPresenter.this.view.getPasswordTextBox().setText(parameters.get("org.apache.chemistry.opencmis.password"));
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)CMISConfigurationPresenter.this.constants.UnexpectedError(throwable.getMessage()));
                return true;
            }
        })).getConfigurationParameters();
    }

    @OnOpen
    public void onOpen() {
        WorkbenchSplitLayoutPanel splitPanel = (WorkbenchSplitLayoutPanel)this.view.asWidget().getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent();
        splitPanel.setWidgetMinSize(splitPanel.getWidget(0), 500);
        this.refreshConfigurationParameters();
    }

    public void configureParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", this.view.getWSACLTextBox().getText());
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", this.view.getWSDiscoveryTextBox().getText());
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", this.view.getWSMultifilingTextBox().getText());
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", this.view.getWSNavigationTextBox().getText());
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", this.view.getWSObjectTextBox().getText());
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", this.view.getWSPolicyTextBox().getText());
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", this.view.getWSRelationshipTextBox().getText());
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", this.view.getWSRepositoryTextBox().getText());
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", this.view.getWSVersioningTextBox().getText());
        parameters.put("org.apache.chemistry.opencmis.session.repository.id", this.view.getRepositoryIDTextBox().getText());
        parameters.put("org.apache.chemistry.opencmis.user", this.view.getUserTextBox().getText());
        parameters.put("org.apache.chemistry.opencmis.password", this.view.getPasswordTextBox().getText());
        ((DocumentServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<Long>(){

            public void callback(Long taskId) {
                CMISConfigurationPresenter.this.view.displayNotification("Updated", NotificationEvent.NotificationType.SUCCESS);
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                CMISConfigurationPresenter.this.errorPopup.showMessage("Unexpected error encountered : " + throwable.getMessage());
                return true;
            }
        })).setConfigurationParameters(parameters);
    }

    public void testConnection() {
        ((DocumentServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<Boolean>(){

            public void callback(Boolean result) {
                if (result.booleanValue()) {
                    CMISConfigurationPresenter.this.view.displayNotification("Connection Successfull", NotificationEvent.NotificationType.SUCCESS);
                } else {
                    CMISConfigurationPresenter.this.view.displayNotification("Connection Failed", NotificationEvent.NotificationType.ERROR);
                }
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                CMISConfigurationPresenter.this.errorPopup.showMessage("Unexpected error encountered : " + throwable.getMessage());
                return true;
            }
        })).testConnection();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }

    private void makeMenuBar() {
        this.menus = ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)this.constants.Refresh()).respondsWith(new Command(){

            public void execute() {
                CMISConfigurationPresenter.this.refreshConfigurationParameters();
                CMISConfigurationPresenter.this.view.displayNotification("Refresh complete.");
            }
        })).endMenu()).build();
    }

    private List<MenuItem> getOptions() {
        return null;
    }

    public static interface CMISConfigurationView
    extends UberView<CMISConfigurationPresenter> {
        public TextBox getWSACLTextBox();

        public TextBox getWSDiscoveryTextBox();

        public TextBox getWSMultifilingTextBox();

        public TextBox getWSNavigationTextBox();

        public TextBox getWSObjectTextBox();

        public TextBox getWSPolicyTextBox();

        public TextBox getWSRelationshipTextBox();

        public TextBox getWSRepositoryTextBox();

        public TextBox getWSVersioningTextBox();

        public TextBox getRepositoryIDTextBox();

        public TextBox getUserTextBox();

        public TextBox getPasswordTextBox();

        public void displayNotification(String var1);

        public void displayNotification(String var1, NotificationEvent.NotificationType var2);

        public Button getConfigureButton();

        public Button getTestButton();
    }
}

