/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.dm.client.document.list;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.view.client.Range;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.dm.client.i18n.Constants;
import org.jbpm.console.ng.dm.model.CMSContentSummary;
import org.jbpm.console.ng.dm.model.events.DocumentDefSelectionEvent;
import org.jbpm.console.ng.dm.model.events.DocumentRemoveSearchEvent;
import org.jbpm.console.ng.dm.model.events.DocumentsHomeSearchEvent;
import org.jbpm.console.ng.dm.model.events.DocumentsListSearchEvent;
import org.jbpm.console.ng.dm.model.events.DocumentsParentSearchEvent;
import org.jbpm.console.ng.dm.model.events.NewDocumentEvent;
import org.jbpm.console.ng.dm.service.DocumentServiceEntryPoint;
import org.jbpm.console.ng.ga.model.PortableQueryFilter;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.list.base.AbstractScreenListPresenter;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.mvp.UberView;
import org.uberfire.lifecycle.OnFocus;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@Dependent
@WorkbenchScreen(identifier="Documents Presenter")
public class DocumentListPresenter
extends AbstractScreenListPresenter<CMSContentSummary> {
    @Inject
    private DocumentListView view;
    @Inject
    private Caller<DocumentServiceEntryPoint> dataServices;
    @Inject
    private Event<DocumentDefSelectionEvent> documentDefSelected;
    List<CMSContentSummary> currentDocuments = null;
    String id = null;
    CMSContentSummary currentCMSContentSummary;
    private Constants constants = (Constants)GWT.create(Constants.class);

    protected AbstractListView.ListView getListView() {
        return this.view;
    }

    public void getData(Range visibleRange) {
        ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
        if (this.currentFilter == null) {
            this.currentFilter = new PortableQueryFilter(visibleRange.getStart(), visibleRange.getLength(), false, "", columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "", columnSortList.size() == 0 || columnSortList.get(0).isAscending());
        }
        if (this.currentFilter.getParams() == null || this.currentFilter.getParams().isEmpty() || this.currentFilter.getParams().get("textSearch") == null || this.currentFilter.getParams().get("textSearch").equals("")) {
            this.currentFilter.setOffset(Integer.valueOf(visibleRange.getStart()));
            this.currentFilter.setCount(Integer.valueOf(visibleRange.getLength()));
        } else {
            this.currentFilter.setOffset(Integer.valueOf(0));
            this.currentFilter.setCount(Integer.valueOf(this.view.getListGrid().getPageSize()));
        }
        this.currentFilter.setOrderBy(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
        this.currentFilter.setIsAscending(Boolean.valueOf(columnSortList.size() == 0 || columnSortList.get(0).isAscending()));
        if (this.id != null) {
            HashMap params = this.currentFilter.getParams();
            if (params == null) {
                params = new HashMap();
                this.currentFilter.setParams(params);
            }
            this.currentFilter.getParams().put("id", this.id);
        }
        ((DocumentServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<List<CMSContentSummary>>(){

            public void callback(List<CMSContentSummary> response) {
                CMSContentSummary first;
                DocumentListPresenter.this.view.hideBusyIndicator();
                DocumentListPresenter.this.dataProvider.updateRowCount(response.size(), true);
                DocumentListPresenter.this.dataProvider.updateRowData(0, response);
                List<CMSContentSummary> documents = response;
                if (documents.size() > 0 && (first = documents.get(0)) != null) {
                    DocumentListPresenter.this.currentCMSContentSummary = first.getParent();
                }
                DocumentListPresenter.this.view.updatePathLink();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                DocumentListPresenter.this.view.hideBusyIndicator();
                DocumentListPresenter.this.view.displayNotification("Error: Getting documents from CMIS Server: " + message);
                GWT.log((String)throwable.toString());
                return true;
            }
        })).getDocuments(this.id);
    }

    private void refreshDocumentList(String id) {
        this.id = id;
        this.refreshGrid();
    }

    public void onProcessDefSelectionEvent(@Observes DocumentsListSearchEvent event) {
        if (event.getSummary().getContentType().toString().equalsIgnoreCase("FOLDER")) {
            this.currentCMSContentSummary = event.getSummary();
            this.refreshDocumentList(event.getSummary().getId());
        } else {
            CMSContentSummary document = null;
            PlaceStatus instanceDetailsStatus = this.placeManager.getStatus((PlaceRequest)new DefaultPlaceRequest("Document Details"));
            if (instanceDetailsStatus == PlaceStatus.OPEN) {
                this.placeManager.closePlace("Document Details");
            }
            document = event.getSummary();
            this.placeManager.goTo("Document Details");
            this.documentDefSelected.fire((Object)new DocumentDefSelectionEvent(document.getId()));
        }
    }

    public void onDocumentsParentSelectionEvent(@Observes DocumentsParentSearchEvent event) {
        if (this.currentCMSContentSummary != null) {
            if (this.currentCMSContentSummary.getParent() != null) {
                this.refreshDocumentList(this.currentCMSContentSummary.getParent().getId());
            } else {
                this.refreshDocumentList(null);
            }
        }
    }

    public void onDocumentsHomeSelectionEvent(@Observes DocumentsHomeSearchEvent event) {
        this.refreshDocumentList(null);
    }

    public void onDocumentRemoveEvent(@Observes DocumentRemoveSearchEvent event) {
        ((DocumentServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void response) {
                DocumentListPresenter.this.refreshDocumentList(DocumentListPresenter.this.currentCMSContentSummary.getId());
            }
        })).removeDocument(event.getSummary().getId());
    }

    public void onDocumentAddedEvent(@Observes NewDocumentEvent event) {
        this.refreshDocumentList(this.currentCMSContentSummary.getId());
    }

    @OnOpen
    public void onOpen() {
        this.id = null;
        this.currentCMSContentSummary = null;
        this.refreshDocumentList(null);
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    @OnFocus
    public void onFocus() {
        this.refreshDocumentList(null);
    }

    @WorkbenchPartView
    public UberView<DocumentListPresenter> getView() {
        return this.view;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.DocumentsList();
    }

    public static interface DocumentListView
    extends AbstractListView.ListView<CMSContentSummary, DocumentListPresenter> {
        public void updatePathLink();
    }
}

