/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.es.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.bd.integration.AbstractKieServerService;
import org.jbpm.console.ng.es.backend.server.RequestSummaryHelper;
import org.jbpm.console.ng.es.model.ErrorSummary;
import org.jbpm.console.ng.es.model.RequestDetails;
import org.jbpm.console.ng.es.model.RequestKey;
import org.jbpm.console.ng.es.model.RequestParameterSummary;
import org.jbpm.console.ng.es.model.RequestSummary;
import org.jbpm.console.ng.es.service.ExecutorService;
import org.jbpm.console.ng.ga.model.QueryFilter;
import org.jbpm.console.ng.ga.service.GenericServiceEntryPoint;
import org.kie.api.executor.STATUS;
import org.kie.server.api.model.instance.JobRequestInstance;
import org.kie.server.api.model.instance.RequestInfoInstance;
import org.kie.server.client.JobServicesClient;
import org.uberfire.paging.PageResponse;

@Service
@ApplicationScoped
public class RemoteExecutorServiceImpl
extends AbstractKieServerService
implements ExecutorService,
GenericServiceEntryPoint<RequestKey, RequestSummary> {
    public RequestDetails getRequestDetails(String serverTemplateId, Long requestId) {
        JobServicesClient jobClient = (JobServicesClient)this.getClient(serverTemplateId, JobServicesClient.class);
        RequestInfoInstance request = jobClient.getRequestById(requestId, true, true);
        RequestSummary summary = RequestSummaryHelper.adaptRequest(request);
        List<ErrorSummary> errors = RequestSummaryHelper.adaptErrorInstanceList(request.getErrors().getItems());
        List<RequestParameterSummary> params = RequestSummaryHelper.adaptInternalMap(request);
        return new RequestDetails(summary, errors, params);
    }

    public Long scheduleRequest(String serverTemplateId, String commandName, Map<String, String> ctx) {
        JobServicesClient jobClient = (JobServicesClient)this.getClient(serverTemplateId, JobServicesClient.class);
        HashMap<Object, Object> data = new HashMap();
        if (ctx != null && !ctx.isEmpty()) {
            data = new HashMap<String, String>(ctx);
        }
        JobRequestInstance jobRequest = JobRequestInstance.builder().command(commandName).data(data).build();
        return jobClient.scheduleRequest(jobRequest);
    }

    public Long scheduleRequest(String serverTemplateId, String commandName, Date date, Map<String, String> ctx) {
        JobServicesClient jobClient = (JobServicesClient)this.getClient(serverTemplateId, JobServicesClient.class);
        HashMap<Object, Object> data = new HashMap();
        if (ctx != null && !ctx.isEmpty()) {
            data = new HashMap<String, String>(ctx);
        }
        JobRequestInstance jobRequest = JobRequestInstance.builder().command(commandName).data(data).scheduledDate(date).build();
        return jobClient.scheduleRequest(jobRequest);
    }

    public void cancelRequest(String serverTemplateId, Long requestId) {
        JobServicesClient jobClient = (JobServicesClient)this.getClient(serverTemplateId, JobServicesClient.class);
        jobClient.cancelRequest(requestId.longValue());
    }

    public void requeueRequest(String serverTemplateId, Long requestId) {
        JobServicesClient jobClient = (JobServicesClient)this.getClient(serverTemplateId, JobServicesClient.class);
        jobClient.requeueRequest(requestId.longValue());
    }

    public PageResponse<RequestSummary> getData(QueryFilter filter) {
        PageResponse response = new PageResponse();
        List<RequestSummary> requestSummarys = this.getRequests(filter);
        response.setStartRowIndex(filter.getOffset().intValue());
        response.setTotalRowSize(requestSummarys.size() - 1);
        if (requestSummarys.size() > filter.getCount()) {
            response.setTotalRowSizeExact(false);
        } else {
            response.setTotalRowSizeExact(true);
        }
        if (!requestSummarys.isEmpty() && requestSummarys.size() > filter.getCount() + filter.getOffset()) {
            response.setPageRowList(new ArrayList<RequestSummary>(requestSummarys.subList(filter.getOffset(), filter.getOffset() + filter.getCount())));
            response.setLastPage(false);
        } else {
            response.setPageRowList(new ArrayList<RequestSummary>(requestSummarys));
            response.setLastPage(true);
        }
        return response;
    }

    private List<RequestSummary> getRequests(QueryFilter filter) {
        ArrayList<String> states = null;
        if (filter.getParams() != null) {
            states = (ArrayList<String>)filter.getParams().get("states");
        }
        Collection requestInfoList = null;
        if (states == null || states.isEmpty()) {
            states = new ArrayList<String>();
            states.add(STATUS.QUEUED.toString());
            states.add(STATUS.RUNNING.toString());
            states.add(STATUS.RETRYING.toString());
            states.add(STATUS.ERROR.toString());
            states.add(STATUS.DONE.toString());
            states.add(STATUS.CANCELLED.toString());
        }
        JobServicesClient jobClient = (JobServicesClient)this.getClient((String)filter.getParams().get("serverTemplateId"), JobServicesClient.class);
        List jobs = jobClient.getRequestsByStatus(states, Integer.valueOf(0), Integer.valueOf(100));
        ArrayList<RequestSummary> requestSummarys = new ArrayList<RequestSummary>(requestInfoList.size());
        for (RequestInfoInstance requestInfo : jobs) {
            if (filter.getParams().get("textSearch") == null || ((String)filter.getParams().get("textSearch")).isEmpty()) {
                requestSummarys.add(RequestSummaryHelper.adaptRequest(requestInfo));
                continue;
            }
            if (!requestInfo.getCommandName().toLowerCase().contains((String)filter.getParams().get("textSearch"))) continue;
            requestSummarys.add(RequestSummaryHelper.adaptRequest(requestInfo));
        }
        return requestSummarys;
    }
}

