/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.es.client.editors.requestlist.dataset;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.RadioButton;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.df.client.filter.FilterSettings;
import org.jbpm.console.ng.df.client.list.base.DataSetQueryHelper;
import org.jbpm.console.ng.es.client.editors.quicknewjob.QuickNewJobPopup;
import org.jbpm.console.ng.es.client.editors.servicesettings.JobServiceSettingsPopup;
import org.jbpm.console.ng.es.client.i18n.Constants;
import org.jbpm.console.ng.es.model.RequestSummary;
import org.jbpm.console.ng.es.model.events.RequestChangedEvent;
import org.jbpm.console.ng.es.service.ExecutorServiceEntryPoint;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.list.base.AbstractScreenListPresenter;
import org.jbpm.console.ng.gc.client.list.base.events.SearchEvent;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.mvp.Command;
import org.uberfire.paging.PageResponse;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@Dependent
@WorkbenchScreen(identifier="DataSet Requests List")
public class DataSetRequestListPresenter
extends AbstractScreenListPresenter<RequestSummary> {
    public static String FILTER_STATUSES_PARAM_NAME = "states";
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private DataSetRequestListView view;
    @Inject
    private Caller<ExecutorServiceEntryPoint> executorServices;
    @Inject
    private Event<RequestChangedEvent> requestChangedEvent;
    @Inject
    DataSetQueryHelper dataSetQueryHelper;
    private List<String> currentActiveStates;
    @Inject
    private JobServiceSettingsPopup jobServiceSettingsPopup;
    @Inject
    private QuickNewJobPopup quickNewJobPopup;
    public Button menuActionsButton;
    private PopupPanel popup = new PopupPanel(true);
    public Button menuRefreshButton = new Button();
    public Button menuResetTabsButton = new Button();
    @Inject
    private ErrorPopupPresenter errorPopup;

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.RequestsListTitle();
    }

    @WorkbenchPartView
    public UberView<DataSetRequestListPresenter> getView() {
        return this.view;
    }

    public void filterGrid(FilterSettings tableSettings) {
        this.dataSetQueryHelper.setCurrentTableSettings(tableSettings);
        this.refreshGrid();
    }

    public void init() {
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                DataSetRequestListPresenter.this.view.displayNotification("Executor Service Started ...");
            }
        })).init();
    }

    public void createRequest() {
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("businessKey", "1234");
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<Long>(){

            public void callback(Long requestId) {
                DataSetRequestListPresenter.this.view.displayNotification("Request Schedulled: " + requestId);
            }
        })).scheduleRequest("PrintOutCmd", ctx);
    }

    protected AbstractListView.ListView getListView() {
        return this.view;
    }

    public void getData(final Range visibleRange) {
        try {
            FilterSettings currentTableSettings = this.dataSetQueryHelper.getCurrentTableSettings();
            if (currentTableSettings != null) {
                currentTableSettings.setTablePageSize(this.view.getListGrid().getPageSize());
                ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
                if (columnSortList != null && columnSortList.size() > 0) {
                    this.dataSetQueryHelper.setLastOrderedColumn(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
                    this.dataSetQueryHelper.setLastSortOrder(columnSortList.size() > 0 && columnSortList.get(0).isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING);
                } else {
                    this.dataSetQueryHelper.setLastOrderedColumn("timestamp");
                    this.dataSetQueryHelper.setLastSortOrder(SortOrder.ASCENDING);
                }
                this.dataSetQueryHelper.setDataSetHandler(currentTableSettings);
                if (this.textSearchStr != null && this.textSearchStr.trim().length() > 0) {
                    DataSetFilter filter = new DataSetFilter();
                    ArrayList<ColumnFilter> filters = new ArrayList<ColumnFilter>();
                    filters.add(FilterFactory.likeTo((String)"commandName", (String)("%" + this.textSearchStr.toLowerCase() + "%"), (boolean)false));
                    filters.add(FilterFactory.likeTo((String)"message", (String)("%" + this.textSearchStr.toLowerCase() + "%"), (boolean)false));
                    filters.add(FilterFactory.likeTo((String)"businessKey", (String)("%" + this.textSearchStr.toLowerCase() + "%"), (boolean)false));
                    filter.addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                    if (currentTableSettings.getDataSetLookup().getFirstFilterOp() != null) {
                        currentTableSettings.getDataSetLookup().getFirstFilterOp().addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                    } else {
                        currentTableSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
                    }
                    this.textSearchStr = "";
                }
                this.dataSetQueryHelper.lookupDataSet(Integer.valueOf(visibleRange.getStart()), new DataSetReadyCallback(){

                    public void callback(DataSet dataSet) {
                        if (dataSet != null) {
                            ArrayList<RequestSummary> myRequestSumaryFromDataSet = new ArrayList<RequestSummary>();
                            for (int i = 0; i < dataSet.getRowCount(); ++i) {
                                myRequestSumaryFromDataSet.add(new RequestSummary(DataSetRequestListPresenter.this.dataSetQueryHelper.getColumnLongValue(dataSet, "id", i), DataSetRequestListPresenter.this.dataSetQueryHelper.getColumnDateValue(dataSet, "timestamp", i), DataSetRequestListPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "status", i), DataSetRequestListPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "commandName", i), DataSetRequestListPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "message", i), DataSetRequestListPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "businessKey", i)));
                            }
                            PageResponse requestSummaryPageResponse = new PageResponse();
                            requestSummaryPageResponse.setPageRowList(myRequestSumaryFromDataSet);
                            requestSummaryPageResponse.setStartRowIndex(visibleRange.getStart());
                            requestSummaryPageResponse.setTotalRowSize(dataSet.getRowCountNonTrimmed());
                            requestSummaryPageResponse.setTotalRowSizeExact(true);
                            if (visibleRange.getStart() + dataSet.getRowCount() == dataSet.getRowCountNonTrimmed()) {
                                requestSummaryPageResponse.setLastPage(true);
                            } else {
                                requestSummaryPageResponse.setLastPage(false);
                            }
                            DataSetRequestListPresenter.this.updateDataOnCallback(requestSummaryPageResponse);
                        }
                        DataSetRequestListPresenter.this.view.hideBusyIndicator();
                    }

                    public void notFound() {
                        DataSetRequestListPresenter.this.view.hideBusyIndicator();
                        DataSetRequestListPresenter.this.errorPopup.showMessage("Not found DataSet with UUID [  jbpmRequestList ] ");
                        GWT.log((String)"DataSet with UUID [  jbpmRequestList ] not found.");
                    }

                    public boolean onError(ClientRuntimeError error) {
                        DataSetRequestListPresenter.this.view.hideBusyIndicator();
                        DataSetRequestListPresenter.this.errorPopup.showMessage("DataSet with UUID [  jbpmRequestList ] error: " + error.getThrowable());
                        GWT.log((String)"DataSet with UUID [  jbpmRequestList ] error: ", (Throwable)error.getThrowable());
                        return false;
                    }
                });
            } else {
                this.view.hideBusyIndicator();
            }
        }
        catch (Exception e) {
            GWT.log((String)"Error looking up dataset with UUID [ jbpmRequestList ]");
        }
    }

    public void addDataDisplay(HasData<RequestSummary> display) {
        this.dataProvider.addDataDisplay(display);
    }

    public AsyncDataProvider<RequestSummary> getDataProvider() {
        return this.dataProvider;
    }

    public void cancelRequest(final Long requestId) {
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                DataSetRequestListPresenter.this.view.displayNotification("Request " + requestId + " cancelled");
                DataSetRequestListPresenter.this.requestChangedEvent.fire((Object)new RequestChangedEvent(requestId));
            }
        })).cancelRequest(requestId);
    }

    public void requeueRequest(final Long requestId) {
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                DataSetRequestListPresenter.this.view.displayNotification("Request " + requestId + " cancelled");
                DataSetRequestListPresenter.this.requestChangedEvent.fire((Object)new RequestChangedEvent(requestId));
            }
        })).requeueRequest(requestId);
    }

    @WorkbenchMenu
    public Menus getMenus() {
        this.setupButtons();
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)Constants.INSTANCE.New_Job()).respondsWith(new Command(){

            public void execute() {
                DataSetRequestListPresenter.this.quickNewJobPopup.show();
            }
        })).endMenu()).newTopLevelMenu(Constants.INSTANCE.Job_Service_Settings()).respondsWith(new Command(){

            public void execute() {
                DataSetRequestListPresenter.this.jobServiceSettingsPopup.show();
            }
        })).endMenu()).newTopLevelCustomMenu(new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        DataSetRequestListPresenter.this.menuRefreshButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent clickEvent) {
                                DataSetRequestListPresenter.this.refreshGrid();
                            }
                        });
                        return DataSetRequestListPresenter.this.menuRefreshButton;
                    }

                    public boolean isEnabled() {
                        return true;
                    }

                    public void setEnabled(boolean enabled) {
                    }

                    public String getSignatureId() {
                        return "org.jbpm.console.ng.es.client.editors.requestlist.RequestListPresenter#menuRefreshButton";
                    }
                };
            }
        }).endMenu()).newTopLevelCustomMenu(new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        return DataSetRequestListPresenter.this.menuActionsButton;
                    }

                    public boolean isEnabled() {
                        return true;
                    }

                    public void setEnabled(boolean enabled) {
                    }

                    public String getSignatureId() {
                        return "org.jbpm.console.ng.es.client.editors.requestlist.RequestListPresenter#menuActionsButton";
                    }
                };
            }
        }).endMenu()).newTopLevelCustomMenu(new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        DataSetRequestListPresenter.this.menuResetTabsButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent clickEvent) {
                                DataSetRequestListPresenter.this.view.restoreTabs();
                            }
                        });
                        return DataSetRequestListPresenter.this.menuResetTabsButton;
                    }

                    public boolean isEnabled() {
                        return true;
                    }

                    public void setEnabled(boolean enabled) {
                    }

                    public String getSignatureId() {
                        return "org.jbpm.console.ng.es.client.editors.requestlist.RequestListPresenter#menuResetTabsButton";
                    }
                };
            }
        }).endMenu()).build();
    }

    public void setupButtons() {
        this.menuActionsButton = new Button();
        this.createRefreshToggleButton(this.menuActionsButton);
        this.menuRefreshButton.setIcon(IconType.REFRESH);
        this.menuRefreshButton.setSize(ButtonSize.MINI);
        this.menuRefreshButton.setTitle(Constants.INSTANCE.Refresh());
        this.menuResetTabsButton.setIcon(IconType.TH_LIST);
        this.menuResetTabsButton.setSize(ButtonSize.MINI);
        this.menuResetTabsButton.setTitle(Constants.INSTANCE.RestoreDefaultFilters());
    }

    public void createRefreshToggleButton(final Button refreshIntervalSelector) {
        refreshIntervalSelector.setToggle(true);
        refreshIntervalSelector.setIcon(IconType.COG);
        refreshIntervalSelector.setTitle(Constants.INSTANCE.AutoRefresh());
        refreshIntervalSelector.setSize(ButtonSize.MINI);
        this.popup.getElement().getStyle().setZIndex(Integer.MAX_VALUE);
        this.popup.addAutoHidePartner((Element)refreshIntervalSelector.getElement());
        this.popup.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> popupPanelCloseEvent) {
                if (popupPanelCloseEvent.isAutoClosed()) {
                    refreshIntervalSelector.setActive(false);
                }
            }
        });
        refreshIntervalSelector.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!refreshIntervalSelector.isActive()) {
                    DataSetRequestListPresenter.this.showSelectRefreshIntervalPopup(refreshIntervalSelector.getAbsoluteLeft() + refreshIntervalSelector.getOffsetWidth(), refreshIntervalSelector.getAbsoluteTop() + refreshIntervalSelector.getOffsetHeight(), refreshIntervalSelector);
                } else {
                    DataSetRequestListPresenter.this.popup.hide(false);
                }
            }
        });
    }

    private void showSelectRefreshIntervalPopup(int left, int top, final Button refreshIntervalSelector) {
        VerticalPanel popupContent = new VerticalPanel();
        int configuredSeconds = this.view.getRefreshValue();
        if (configuredSeconds > 0) {
            this.updateRefreshInterval(true, configuredSeconds);
        } else {
            this.updateRefreshInterval(false, 0);
        }
        RadioButton oneMinuteRadioButton = this.createTimeSelectorRadioButton(60, "1 " + Constants.INSTANCE.Minute(), configuredSeconds, refreshIntervalSelector, popupContent);
        RadioButton fiveMinuteRadioButton = this.createTimeSelectorRadioButton(300, "5 " + Constants.INSTANCE.Minutes(), configuredSeconds, refreshIntervalSelector, popupContent);
        RadioButton tenMinuteRadioButton = this.createTimeSelectorRadioButton(600, "10 " + Constants.INSTANCE.Minutes(), configuredSeconds, refreshIntervalSelector, popupContent);
        popupContent.add((Widget)oneMinuteRadioButton);
        popupContent.add((Widget)fiveMinuteRadioButton);
        popupContent.add((Widget)tenMinuteRadioButton);
        Button resetButton = new Button(Constants.INSTANCE.Disable());
        resetButton.setSize(ButtonSize.MINI);
        resetButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                DataSetRequestListPresenter.this.updateRefreshInterval(false, 0);
                DataSetRequestListPresenter.this.view.saveRefreshValue(0);
                refreshIntervalSelector.setActive(false);
                DataSetRequestListPresenter.this.popup.hide();
            }
        });
        popupContent.add((Widget)resetButton);
        this.popup.setWidget((Widget)popupContent);
        this.popup.show();
        int finalLeft = left - this.popup.getOffsetWidth();
        this.popup.setPopupPosition(finalLeft, top);
    }

    private RadioButton createTimeSelectorRadioButton(int time, String name, int configuredSeconds, final Button refreshIntervalSelector, VerticalPanel popupContent) {
        RadioButton oneMinuteRadioButton = new RadioButton("refreshInterval", name);
        oneMinuteRadioButton.setText(name);
        final int selectedRefreshTime = time;
        if (configuredSeconds == selectedRefreshTime) {
            oneMinuteRadioButton.setValue(Boolean.valueOf(true));
        }
        oneMinuteRadioButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                DataSetRequestListPresenter.this.updateRefreshInterval(true, selectedRefreshTime);
                DataSetRequestListPresenter.this.view.saveRefreshValue(selectedRefreshTime);
                refreshIntervalSelector.setActive(false);
                DataSetRequestListPresenter.this.popup.hide();
            }
        });
        return oneMinuteRadioButton;
    }

    protected void onSearchEvent(@Observes SearchEvent searchEvent) {
        this.textSearchStr = searchEvent.getFilter();
        if (this.textSearchStr != null && this.textSearchStr.trim().length() > 0) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("textSearch", this.textSearchStr);
            this.dataSetQueryHelper.getCurrentTableSettings().getKey();
            this.view.applyFilterOnPresenter(this.dataSetQueryHelper.getCurrentTableSettings().getKey());
        }
    }

    public static interface DataSetRequestListView
    extends AbstractListView.ListView<RequestSummary, DataSetRequestListPresenter> {
        public int getRefreshValue();

        public void restoreTabs();

        public void saveRefreshValue(int var1);

        public void applyFilterOnPresenter(String var1);
    }
}

