/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.es.client.editors.requestlist;

import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.NumberCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.Window;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jbpm.console.ng.df.client.filter.FilterSettings;
import org.jbpm.console.ng.df.client.filter.FilterSettingsBuilderHelper;
import org.jbpm.console.ng.df.client.list.base.DataSetEditorManager;
import org.jbpm.console.ng.es.client.editors.jobdetails.JobDetailsPopup;
import org.jbpm.console.ng.es.client.editors.quicknewjob.QuickNewJobPopup;
import org.jbpm.console.ng.es.client.editors.requestlist.RequestListPresenter;
import org.jbpm.console.ng.es.client.editors.servicesettings.JobServiceSettingsPopup;
import org.jbpm.console.ng.es.client.i18n.Constants;
import org.jbpm.console.ng.es.model.RequestSummary;
import org.jbpm.console.ng.es.model.events.RequestChangedEvent;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.list.base.AbstractListPresenter;
import org.jbpm.console.ng.gc.client.list.base.AbstractMultiGridView;
import org.jbpm.console.ng.gc.client.util.ButtonActionCell;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.common.client.tables.ColumnMeta;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.common.client.tables.popup.NewTabFilterPopup;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class RequestListViewImpl
extends AbstractMultiGridView<RequestSummary, RequestListPresenter>
implements RequestListPresenter.RequestListView {
    private Constants constants = (Constants)GWT.create(Constants.class);
    public static String REQUEST_LIST_PREFIX = "DS_RequestListGrid";
    public static final String REQUEST_LIST_DATASET_ID = "jbpmRequestList";
    public static final String COLUMN_ID = "id";
    public static final String COLUMN_TIMESTAMP = "timestamp";
    public static final String COLUMN_STATUS = "status";
    public static final String COLUMN_COMMANDNAME = "commandName";
    public static final String COLUMN_MESSAGE = "message";
    public static final String COLUMN_BUSINESSKEY = "businessKey";
    public static final String COL_ID_ACTIONS = "Actions";
    @Inject
    private Event<NotificationEvent> notification;
    private List<RequestSummary> selectedRequestSummary = new ArrayList<RequestSummary>();
    @Inject
    private JobDetailsPopup jobDetailsPopup;
    @Inject
    private QuickNewJobPopup quickNewJobPopup;
    @Inject
    private NewTabFilterPopup newTabFilterPopup;
    @Inject
    private DataSetEditorManager dataSetEditorManager;
    @Inject
    private JobServiceSettingsPopup jobServiceSettingsPopup;

    public void init(final RequestListPresenter presenter) {
        final ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add(COLUMN_ID);
        bannedColumns.add(COLUMN_COMMANDNAME);
        bannedColumns.add(COL_ID_ACTIONS);
        final ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add(COLUMN_ID);
        initColumns.add(COLUMN_COMMANDNAME);
        initColumns.add(COL_ID_ACTIONS);
        final Button button = new Button();
        button.setIcon(IconType.PLUS);
        button.setSize(ButtonSize.SMALL);
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                final String key = RequestListViewImpl.this.getValidKeyForAdditionalListGrid(REQUEST_LIST_PREFIX + "_");
                Command addNewGrid = new Command(){

                    public void execute() {
                        final ExtendedPagedTable extendedPagedTable = RequestListViewImpl.this.createGridInstance(new GridGlobalPreferences(key, initColumns, bannedColumns), key);
                        extendedPagedTable.setDataProvider(presenter.getDataProvider());
                        RequestListViewImpl.this.filterPagedTable.createNewTab((PagedTable)extendedPagedTable, key, button, new Command(){

                            public void execute() {
                                RequestListViewImpl.this.currentListGrid = extendedPagedTable;
                                RequestListViewImpl.this.applyFilterOnPresenter(key);
                            }
                        });
                        RequestListViewImpl.this.applyFilterOnPresenter(key);
                    }
                };
                FilterSettings tableSettings = RequestListViewImpl.this.createTableSettingsPrototype();
                tableSettings.setKey(key);
                RequestListViewImpl.this.dataSetEditorManager.showTableSettingsEditor(RequestListViewImpl.this.filterPagedTable, Constants.INSTANCE.New_JobList(), tableSettings, addNewGrid);
            }
        });
        super.init((AbstractListPresenter)presenter, new GridGlobalPreferences(REQUEST_LIST_PREFIX, initColumns, bannedColumns), button);
    }

    public void requestCreated(@Observes RequestChangedEvent event) {
        ((RequestListPresenter)this.presenter).refreshGrid();
    }

    public void initColumns(ExtendedPagedTable extendedPagedTable) {
        Column jobIdColumn = this.initJobIdColumn();
        Column jobTypeColumn = this.initJobTypeColumn();
        Column statusColumn = this.initStatusColumn();
        Column dueDateColumn = this.initDueDateColumn();
        this.actionsColumn = this.initActionsColumn();
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        columnMetas.add(new ColumnMeta(jobIdColumn, this.constants.Id()));
        columnMetas.add(new ColumnMeta(jobTypeColumn, this.constants.Type()));
        columnMetas.add(new ColumnMeta(statusColumn, this.constants.Status()));
        columnMetas.add(new ColumnMeta(dueDateColumn, this.constants.Due_On()));
        columnMetas.add(new ColumnMeta(this.actionsColumn, this.constants.Actions()));
        extendedPagedTable.addColumns(columnMetas);
    }

    public void initSelectionModel() {
        final ExtendedPagedTable extendedPagedTable = this.getListGrid();
        extendedPagedTable.setEmptyTableCaption(this.constants.No_Jobs_Found());
        this.initLeftToolbarActions(extendedPagedTable);
        this.selectionModel = new NoSelectionModel();
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                boolean close = false;
                if (RequestListViewImpl.this.selectedRow == -1) {
                    extendedPagedTable.setRowStyles(RequestListViewImpl.this.selectedStyles);
                    RequestListViewImpl.this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                    extendedPagedTable.redraw();
                } else if (extendedPagedTable.getKeyboardSelectedRow() != RequestListViewImpl.this.selectedRow) {
                    extendedPagedTable.setRowStyles(RequestListViewImpl.this.selectedStyles);
                    RequestListViewImpl.this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                    extendedPagedTable.redraw();
                } else {
                    close = true;
                }
            }
        });
        this.initNoActionColumnManager(extendedPagedTable);
        extendedPagedTable.setSelectionModel((SelectionModel)this.selectionModel, (CellPreviewEvent.Handler)this.noActionColumnManager);
        extendedPagedTable.setRowStyles(this.selectedStyles);
    }

    private void initNoActionColumnManager(final ExtendedPagedTable extendedPagedTable) {
        this.noActionColumnManager = DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new DefaultSelectionEventManager.EventTranslator<RequestSummary>(){

            public boolean clearCurrentSelection(CellPreviewEvent<RequestSummary> event) {
                return false;
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<RequestSummary> event) {
                NativeEvent nativeEvent = event.getNativeEvent();
                if ("click".equals(nativeEvent.getType())) {
                    InputElement input;
                    if (extendedPagedTable.getColumnIndex(RequestListViewImpl.this.actionsColumn) == event.getColumn()) {
                        return DefaultSelectionEventManager.SelectAction.IGNORE;
                    }
                    Element target = (Element)nativeEvent.getEventTarget().cast();
                    if ("input".equals(target.getTagName().toLowerCase()) && "checkbox".equals((input = (InputElement)target.cast()).getType().toLowerCase())) {
                        if (!RequestListViewImpl.this.selectedRequestSummary.contains(event.getValue())) {
                            RequestListViewImpl.this.selectedRequestSummary.add(event.getValue());
                            input.setChecked(true);
                        } else {
                            RequestListViewImpl.this.selectedRequestSummary.remove(event.getValue());
                            input.setChecked(false);
                        }
                        return DefaultSelectionEventManager.SelectAction.IGNORE;
                    }
                }
                return DefaultSelectionEventManager.SelectAction.DEFAULT;
            }
        });
    }

    private void initLeftToolbarActions(ExtendedPagedTable extendedPagedTable) {
    }

    private Column initJobIdColumn() {
        Column<RequestSummary, Number> jobIdColumn = new Column<RequestSummary, Number>((Cell)new NumberCell()){

            public Number getValue(RequestSummary object) {
                return object.getJobId();
            }
        };
        jobIdColumn.setSortable(true);
        jobIdColumn.setDataStoreName(COLUMN_ID);
        return jobIdColumn;
    }

    private Column initJobTypeColumn() {
        Column<RequestSummary, String> jobTypeColumn = new Column<RequestSummary, String>((Cell)new TextCell()){

            public String getValue(RequestSummary object) {
                return object.getCommandName();
            }
        };
        jobTypeColumn.setSortable(true);
        jobTypeColumn.setDataStoreName(COLUMN_COMMANDNAME);
        return jobTypeColumn;
    }

    private Column initStatusColumn() {
        Column<RequestSummary, String> statusColumn = new Column<RequestSummary, String>((Cell)new TextCell()){

            public String getValue(RequestSummary object) {
                return object.getStatus();
            }
        };
        statusColumn.setSortable(true);
        statusColumn.setDataStoreName(COLUMN_STATUS);
        return statusColumn;
    }

    private Column initDueDateColumn() {
        Column<RequestSummary, String> dueDateColumn = new Column<RequestSummary, String>((Cell)new TextCell()){

            public String getValue(RequestSummary object) {
                return object.getTime().toString();
            }
        };
        dueDateColumn.setSortable(true);
        dueDateColumn.setDataStoreName(COLUMN_TIMESTAMP);
        return dueDateColumn;
    }

    private Column<RequestSummary, RequestSummary> initActionsColumn() {
        LinkedList<ActionHasCell> cells = new LinkedList<ActionHasCell>();
        ArrayList<String> allStatuses = new ArrayList<String>();
        allStatuses.add("QUEUED");
        allStatuses.add("DONE");
        allStatuses.add("CANCELLED");
        allStatuses.add("ERROR");
        allStatuses.add("RETRYING");
        allStatuses.add("RUNNING");
        cells.add(new ActionHasCell(Constants.INSTANCE.Details(), allStatuses, new ActionCell.Delegate<RequestSummary>(){

            public void execute(RequestSummary job) {
                RequestListViewImpl.this.jobDetailsPopup.show(String.valueOf(job.getJobId()));
            }
        }));
        ArrayList<String> activeStatuses = new ArrayList<String>();
        activeStatuses.add("QUEUED");
        activeStatuses.add("RETRYING");
        activeStatuses.add("RUNNING");
        cells.add(new ActionHasCell(Constants.INSTANCE.Cancel(), activeStatuses, new ActionCell.Delegate<RequestSummary>(){

            public void execute(RequestSummary job) {
                if (Window.confirm((String)"Are you sure you want to cancel this Job?")) {
                    ((RequestListPresenter)RequestListViewImpl.this.presenter).cancelRequest(job.getJobId());
                }
            }
        }));
        ArrayList<String> requeueStatuses = new ArrayList<String>();
        requeueStatuses.add("ERROR");
        requeueStatuses.add("RUNNING");
        cells.add(new ActionHasCell(Constants.INSTANCE.Requeue(), requeueStatuses, new ActionCell.Delegate<RequestSummary>(){

            public void execute(RequestSummary job) {
                if (Window.confirm((String)"Are you sure you want to requeue this Job?")) {
                    ((RequestListPresenter)RequestListViewImpl.this.presenter).requeueRequest(job.getJobId());
                }
            }
        }));
        CompositeCell cell = new CompositeCell(cells);
        Column<RequestSummary, RequestSummary> actionsColumn = new Column<RequestSummary, RequestSummary>((Cell)cell){

            public RequestSummary getValue(RequestSummary object) {
                return object;
            }
        };
        actionsColumn.setDataStoreName(COL_ID_ACTIONS);
        return actionsColumn;
    }

    public void initDefaultFilters(GridGlobalPreferences preferences, Button createTabButton) {
        ((RequestListPresenter)this.presenter).setAddingDefaultFilters(true);
        ArrayList<String> statuses = new ArrayList<String>();
        this.initTabFilter(preferences, REQUEST_LIST_PREFIX + "_0", Constants.INSTANCE.All(), "Filter " + Constants.INSTANCE.All(), statuses);
        statuses = new ArrayList();
        statuses.add("QUEUED");
        this.initTabFilter(preferences, REQUEST_LIST_PREFIX + "_1", Constants.INSTANCE.Queued(), "Filter " + Constants.INSTANCE.Queued(), statuses);
        statuses = new ArrayList();
        statuses.add("RUNNING");
        this.initTabFilter(preferences, REQUEST_LIST_PREFIX + "_2", Constants.INSTANCE.Running(), "Filter " + Constants.INSTANCE.Running(), statuses);
        statuses = new ArrayList();
        statuses.add("RETRYING");
        this.initTabFilter(preferences, REQUEST_LIST_PREFIX + "_3", Constants.INSTANCE.Retrying(), "Filter " + Constants.INSTANCE.Retrying(), statuses);
        statuses = new ArrayList();
        statuses.add("ERROR");
        this.initTabFilter(preferences, REQUEST_LIST_PREFIX + "_4", Constants.INSTANCE.Error(), "Filter " + Constants.INSTANCE.Error(), statuses);
        statuses = new ArrayList();
        statuses.add("DONE");
        this.initTabFilter(preferences, REQUEST_LIST_PREFIX + "_5", Constants.INSTANCE.Completed(), "Filter " + Constants.INSTANCE.Completed(), statuses);
        statuses = new ArrayList();
        statuses.add("CANCELLED");
        this.initTabFilter(preferences, REQUEST_LIST_PREFIX + "_6", Constants.INSTANCE.Cancelled(), "Filter " + Constants.INSTANCE.Cancelled(), statuses);
        this.filterPagedTable.addAddTableButton(createTabButton);
        ((RequestListPresenter)this.presenter).setAddingDefaultFilters(false);
        this.getMultiGridPreferencesStore().setSelectedGrid(REQUEST_LIST_PREFIX + "_0");
        this.filterPagedTable.setSelectedTab();
        this.applyFilterOnPresenter(REQUEST_LIST_PREFIX + "_0");
    }

    private void initTabFilter(GridGlobalPreferences preferences, final String key, String tabName, String tabDesc, List<String> statuses) {
        ExtendedPagedTable extendedPagedTable;
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        if (statuses != null && statuses.size() > 0) {
            builder.dataset(REQUEST_LIST_DATASET_ID);
            ArrayList<String> names = new ArrayList<String>();
            for (String s : statuses) {
                names.add(s);
            }
            builder.filter(new ColumnFilter[]{FilterFactory.equalsTo((String)COLUMN_STATUS, names)});
        }
        builder.dataset(REQUEST_LIST_DATASET_ID);
        builder.setColumn(COLUMN_ID, COLUMN_ID);
        builder.setColumn(COLUMN_TIMESTAMP, "time", "MMM dd E, yyyy");
        builder.setColumn(COLUMN_STATUS, COLUMN_STATUS);
        builder.setColumn(COLUMN_COMMANDNAME, COLUMN_COMMANDNAME, "MMM dd E, yyyy");
        builder.setColumn(COLUMN_MESSAGE, COLUMN_STATUS);
        builder.setColumn(COLUMN_BUSINESSKEY, "key");
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault(COLUMN_TIMESTAMP, SortOrder.DESCENDING);
        FilterSettings tableSettings = builder.buildSettings();
        tableSettings.setKey(key);
        tableSettings.setTableName(tabName);
        tableSettings.setTableDescription(tabDesc);
        HashMap<String, String> tabSettingsValues = new HashMap<String, String>();
        tabSettingsValues.put(FILTER_TABLE_SETTINGS, this.dataSetEditorManager.getTableSettingsToStr(tableSettings));
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, tableSettings.getTableName());
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, tableSettings.getTableDescription());
        this.filterPagedTable.saveNewTabSettings(key, tabSettingsValues);
        this.currentListGrid = extendedPagedTable = this.createGridInstance(new GridGlobalPreferences(key, preferences.getInitialColumns(), preferences.getBannedColumns()), key);
        extendedPagedTable.setDataProvider(((RequestListPresenter)this.presenter).getDataProvider());
        this.filterPagedTable.addTab((PagedTable)extendedPagedTable, key, new Command(){

            public void execute() {
                RequestListViewImpl.this.currentListGrid = extendedPagedTable;
                RequestListViewImpl.this.applyFilterOnPresenter(key);
            }
        });
    }

    public void applyFilterOnPresenter(HashMap<String, Object> params) {
        String tableSettingsJSON = (String)params.get(FILTER_TABLE_SETTINGS);
        FilterSettings tableSettings = this.dataSetEditorManager.getStrToTableSettings(tableSettingsJSON);
        ((RequestListPresenter)this.presenter).filterGrid(tableSettings);
    }

    @Override
    public void applyFilterOnPresenter(String key) {
        this.initSelectionModel();
        this.applyFilterOnPresenter(this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(key));
    }

    public FilterSettings createTableSettingsPrototype() {
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset(REQUEST_LIST_DATASET_ID);
        builder.setColumn(COLUMN_ID, COLUMN_ID);
        builder.setColumn(COLUMN_TIMESTAMP, "time", "MMM dd E, yyyy");
        builder.setColumn(COLUMN_STATUS, COLUMN_STATUS);
        builder.setColumn(COLUMN_COMMANDNAME, COLUMN_COMMANDNAME, "MMM dd E, yyyy");
        builder.setColumn(COLUMN_MESSAGE, COLUMN_STATUS);
        builder.setColumn(COLUMN_BUSINESSKEY, "key");
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault(COLUMN_TIMESTAMP, SortOrder.DESCENDING);
        builder.tableWidth(1000);
        return builder.buildSettings();
    }

    @Override
    public int getRefreshValue() {
        return this.getMultiGridPreferencesStore().getRefreshInterval();
    }

    @Override
    public void saveRefreshValue(int newValue) {
        this.filterPagedTable.saveNewRefreshInterval(newValue);
    }

    @Override
    public void restoreTabs() {
        ArrayList existingGrids = this.getMultiGridPreferencesStore().getGridsId();
        ArrayList allTabs = new ArrayList(existingGrids.size());
        ((RequestListPresenter)this.presenter).setAddingDefaultFilters(true);
        if (existingGrids != null && existingGrids.size() > 0) {
            int i;
            for (i = 0; i < existingGrids.size(); ++i) {
                allTabs.add(existingGrids.get(i));
            }
            for (i = 0; i < allTabs.size(); ++i) {
                this.filterPagedTable.removeTab((String)allTabs.get(i));
            }
        }
        this.filterPagedTable.removeTab(0);
        this.initDefaultFilters(this.currentGlobalPreferences, this.createTabButton);
    }

    private class ActionHasCell
    extends ButtonActionCell<RequestSummary> {
        private final List<String> availableStatuses;

        public ActionHasCell(String text, List<String> availableStatusesList, ActionCell.Delegate<RequestSummary> delegate) {
            super(text, delegate);
            this.availableStatuses = availableStatusesList;
        }

        public void render(Cell.Context context, RequestSummary value, SafeHtmlBuilder sb) {
            if (this.availableStatuses.contains(value.getStatus())) {
                super.render(context, (Object)value, sb);
            }
        }
    }
}

