/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.es.client.editors.requestlist;

import com.google.gwt.view.client.Range;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jbpm.console.ng.df.client.filter.FilterSettings;
import org.jbpm.console.ng.df.client.filter.FilterSettingsBuilderHelper;
import org.jbpm.console.ng.df.client.list.base.DataSetQueryHelper;
import org.jbpm.console.ng.es.client.editors.requestlist.RequestListPresenter;
import org.jbpm.console.ng.es.client.editors.requestlist.RequestListViewImpl;
import org.jbpm.console.ng.es.model.RequestSummary;
import org.jbpm.console.ng.es.model.events.RequestChangedEvent;
import org.jbpm.console.ng.es.service.ExecutorServiceEntryPoint;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class RequestListPresenterTest {
    private static final Long REQUESTID_ID = 1L;
    private CallerMock<ExecutorServiceEntryPoint> callerMockExecutorService;
    @Mock
    private ExecutorServiceEntryPoint executorServiceMock;
    @Mock
    private RequestListViewImpl viewMock;
    @Mock
    private DataSetQueryHelper dataSetQueryHelper;
    @Mock
    private ExtendedPagedTable<RequestSummary> extendedPagedTable;
    @Mock
    private ErrorPopupPresenter errorPopup;
    @Mock
    private EventSourceMock<RequestChangedEvent> requestChangedEvent;
    private FilterSettings filterSettings;
    private RequestListPresenter presenter;

    @Before
    public void setupMocks() {
        this.callerMockExecutorService = new CallerMock((Object)this.executorServiceMock);
        this.filterSettings = this.createTableSettingsPrototype();
        Mockito.when((Object)this.viewMock.getListGrid()).thenReturn(this.extendedPagedTable);
        Mockito.when((Object)this.extendedPagedTable.getPageSize()).thenReturn((Object)10);
        Mockito.when((Object)this.extendedPagedTable.getColumnSortList()).thenReturn(null);
        Mockito.when((Object)this.dataSetQueryHelper.getCurrentTableSettings()).thenReturn((Object)this.filterSettings);
        this.presenter = new RequestListPresenter(this.viewMock, this.callerMockExecutorService, this.dataSetQueryHelper, this.requestChangedEvent);
    }

    @Test
    public void getDataTest() {
        this.presenter.setAddingDefaultFilters(false);
        this.presenter.getData(new Range(0, 5));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setLastSortOrder(SortOrder.ASCENDING);
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).hideBusyIndicator();
    }

    @Test
    public void cancelRequestTest() {
        this.presenter.cancelRequest(REQUESTID_ID);
        ((EventSourceMock)Mockito.verify(this.requestChangedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RequestChangedEvent.class));
        ((ExecutorServiceEntryPoint)Mockito.verify((Object)this.executorServiceMock)).cancelRequest(REQUESTID_ID);
    }

    @Test
    public void requeueRequestTest() {
        this.presenter.requeueRequest(REQUESTID_ID);
        ((EventSourceMock)Mockito.verify(this.requestChangedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RequestChangedEvent.class));
        ((ExecutorServiceEntryPoint)Mockito.verify((Object)this.executorServiceMock)).requeueRequest(REQUESTID_ID);
    }

    public FilterSettings createTableSettingsPrototype() {
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset("jbpmRequestList");
        builder.setColumn("id", "id");
        builder.setColumn("timestamp", "time", "MMM dd E, yyyy");
        builder.setColumn("status", "status");
        builder.setColumn("commandName", "commandName", "MMM dd E, yyyy");
        builder.setColumn("message", "status");
        builder.setColumn("businessKey", "key");
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault("timestamp", SortOrder.DESCENDING);
        builder.tableWidth(1000);
        return builder.buildSettings();
    }
}

