/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.es.client.editors.quicknewjob;

import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.gwtbootstrap3.client.ui.html.Text;
import org.jbpm.console.ng.es.client.editors.quicknewjob.QuickNewJobPopup;
import org.jbpm.console.ng.es.service.ExecutorServiceEntryPoint;
import org.jbpm.console.ng.gc.client.util.UTCDateBox;
import org.jbpm.console.ng.gc.client.util.UTCTimeBox;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Text.class})
public class QuickNewJobPopupTest {
    private String JOB_NAME = "JOB_NAME_1";
    private String JOB_TYPE = "JOB_TYPE_1";
    private int JOB_RETRIES = 5;
    @Mock
    private CallerMock<ExecutorServiceEntryPoint> executorServices;
    @Mock
    private ExecutorServiceEntryPoint executorServicesMock;
    @Mock
    public UTCTimeBox jobDueDateTime;
    @InjectMocks
    private QuickNewJobPopup quickNewJobPopup;

    @Before
    public void setupMocks() {
        this.executorServices = new CallerMock((Object)this.executorServicesMock);
        this.quickNewJobPopup.setExecutorService(this.executorServices);
    }

    @Test
    public void jobNameIsPassedAsBusinessKeyTest() {
        ((ExecutorServiceEntryPoint)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                HashMap ctxValues = (HashMap)invocationOnMock.getArguments()[2];
                Assert.assertTrue((boolean)((String)ctxValues.get("businessKey")).equals(QuickNewJobPopupTest.this.JOB_NAME));
                Assert.assertTrue((boolean)((String)ctxValues.get("retries")).equals(String.valueOf(QuickNewJobPopupTest.this.JOB_RETRIES)));
                Assert.assertTrue((boolean)invocationOnMock.getArguments()[2].equals(QuickNewJobPopupTest.this.JOB_TYPE));
                return null;
            }
        }).when((Object)this.executorServicesMock)).scheduleRequest(Mockito.anyString(), (Date)Mockito.any(Date.class), (Map)Mockito.any(Map.class));
        this.quickNewJobPopup.createJob(this.JOB_NAME, new Date(), this.JOB_TYPE, Integer.valueOf(this.JOB_RETRIES), new ArrayList());
        ((ExecutorServiceEntryPoint)Mockito.verify((Object)this.executorServicesMock)).scheduleRequest(Mockito.anyString(), (Date)Mockito.any(Date.class), (Map)Mockito.any(HashMap.class));
    }

    @Test
    public void dueTimeSetToFutureTimeTest() {
        final Long nextHalfHour = UTCDateBox.date2utc((Date)new Date(System.currentTimeMillis() + 1800000L));
        final Long nextHour = UTCDateBox.date2utc((Date)new Date(System.currentTimeMillis() + 3600000L));
        ((UTCTimeBox)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                Long setTime = (Long)invocationOnMock.getArguments()[0];
                Assert.assertTrue((setTime > nextHalfHour ? 1 : 0) != 0);
                Assert.assertTrue((setTime < nextHour ? 1 : 0) != 0);
                return null;
            }
        }).when((Object)this.jobDueDateTime)).setValue(Long.valueOf(Mockito.anyLong()));
        this.quickNewJobPopup.cleanForm();
        ((UTCTimeBox)Mockito.verify((Object)this.jobDueDateTime)).setValue(Long.valueOf(Mockito.anyLong()));
    }
}

