/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.es.client.editors.quicknewjob;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.EditTextCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.IntegerBox;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.TabListItem;
import org.gwtbootstrap3.client.ui.TabPane;
import org.gwtbootstrap3.client.ui.TabPanel;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.gwtbootstrap3.client.ui.gwt.ButtonCell;
import org.gwtbootstrap3.client.ui.gwt.DataGrid;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.es.client.i18n.Constants;
import org.jbpm.console.ng.es.client.util.ResizableHeader;
import org.jbpm.console.ng.es.model.RequestParameterSummary;
import org.jbpm.console.ng.es.model.events.RequestChangedEvent;
import org.jbpm.console.ng.es.service.ExecutorServiceEntryPoint;
import org.jbpm.console.ng.gc.client.util.UTCDateBox;
import org.jbpm.console.ng.gc.client.util.UTCTimeBox;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class QuickNewJobPopup
extends BaseModal {
    private final Constants constants = Constants.INSTANCE;
    @UiField
    public TabPanel tabPanel;
    @UiField
    public TabListItem basicTab;
    @UiField
    public TabListItem advancedTab;
    @UiField
    public TabPane basicTabPane;
    @UiField
    public TabPane advancedTabPane;
    @UiField
    public FormGroup jobNameControlGroup;
    @UiField
    public TextBox jobNameText;
    @UiField
    HelpBlock jobNameHelpInline;
    @UiField
    public FormGroup jobDueDateControlGroup;
    @UiField
    public UTCDateBox jobDueDate;
    @UiField
    public UTCTimeBox jobDueDateTime;
    @UiField
    HelpBlock jobDueDateHelpBlock;
    @UiField
    public FormGroup jobTypeControlGroup;
    @UiField
    public TextBox jobTypeText;
    @UiField
    HelpBlock jobTypeHelpInline;
    @UiField
    public FormGroup jobRetriesControlGroup;
    @UiField
    public IntegerBox jobRetriesNumber;
    @UiField
    HelpBlock jobRetriesHelpInline;
    @UiField
    public Button newParametersButton;
    @UiField
    public DataGrid<RequestParameterSummary> myParametersGrid;
    @UiField
    public HelpBlock errorMessages;
    @UiField
    public FormGroup errorMessagesGroup;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    private Caller<ExecutorServiceEntryPoint> executorServices;
    @Inject
    private Event<RequestChangedEvent> requestCreatedEvent;
    private ListDataProvider<RequestParameterSummary> dataProvider = new ListDataProvider();
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);

    public QuickNewJobPopup() {
        this.setTitle(Constants.INSTANCE.New_Job());
        this.setBody((Widget)uiBinder.createAndBindUi((Object)this));
        this.basicTab.setDataTargetWidget((Widget)this.basicTabPane);
        this.advancedTab.setDataTargetWidget((Widget)this.advancedTabPane);
        this.jobDueDate.getDateBox().setContainer((Widget)this);
        this.init();
        GenericModalFooter footer = new GenericModalFooter();
        footer.addButton(Constants.INSTANCE.Create(), new Command(){

            public void execute() {
                QuickNewJobPopup.this.okButton();
            }
        }, IconType.PLUS, ButtonType.PRIMARY);
        this.add((Widget)footer);
    }

    public void setExecutorService(Caller<ExecutorServiceEntryPoint> executorServices) {
        this.executorServices = executorServices;
    }

    public void show() {
        this.cleanForm();
        super.show();
    }

    private void okButton() {
        if (this.validateForm()) {
            this.createJob();
        }
    }

    public void init() {
        this.newParametersButton.setText(this.constants.Add_Parameter());
        this.myParametersGrid.setHeight("200px");
        this.myParametersGrid.setEmptyTableWidget((Widget)new Label(this.constants.No_Parameters_added_yet()));
        this.initGridColumns();
        this.newParametersButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                QuickNewJobPopup.this.addNewParameter();
            }
        });
    }

    public void cleanForm() {
        this.basicTab.setActive(true);
        this.basicTabPane.setActive(true);
        this.advancedTab.setActive(false);
        this.advancedTabPane.setActive(false);
        this.basicTab.showTab();
        long nextDueDate = System.currentTimeMillis() + 1800000L;
        this.jobDueDate.setEnabled(true);
        this.jobDueDate.setValue(Long.valueOf(nextDueDate));
        this.jobDueDateTime.setValue(UTCDateBox.date2utc((Date)new Date(nextDueDate)));
        this.jobNameText.setText("");
        this.jobTypeText.setText("");
        this.jobRetriesNumber.setText("0");
        this.dataProvider.getList().clear();
    }

    private void cleanErrorMessages() {
        this.jobNameControlGroup.setValidationState(ValidationState.NONE);
        this.jobNameHelpInline.setText("");
        this.jobDueDateControlGroup.setValidationState(ValidationState.NONE);
        this.jobDueDateHelpBlock.setText("");
        this.jobTypeControlGroup.setValidationState(ValidationState.NONE);
        this.jobTypeHelpInline.setText("");
        this.jobRetriesControlGroup.setValidationState(ValidationState.NONE);
        this.jobRetriesHelpInline.setText("");
    }

    public void closePopup() {
        this.cleanForm();
        this.hide();
    }

    private boolean validateForm() {
        boolean valid = true;
        this.cleanErrorMessages();
        if (this.jobNameText.getText() == null || this.jobNameText.getText().trim().isEmpty()) {
            this.jobNameControlGroup.setValidationState(ValidationState.ERROR);
            this.jobNameHelpInline.setText(Constants.INSTANCE.The_Job_Must_Have_A_Name());
            valid = false;
        } else {
            this.jobNameControlGroup.setValidationState(ValidationState.SUCCESS);
        }
        if (UTCDateBox.utc2date((Long)(this.jobDueDate.getValue() + this.jobDueDateTime.getValue())).before(new Date())) {
            this.jobDueDateControlGroup.setValidationState(ValidationState.ERROR);
            this.jobDueDateHelpBlock.setText(Constants.INSTANCE.The_Job_Must_Have_A_Due_Date_In_The_Future());
            valid = false;
        } else {
            this.jobDueDateControlGroup.setValidationState(ValidationState.SUCCESS);
        }
        if (this.jobTypeText.getText() == null || this.jobTypeText.getText().trim().isEmpty()) {
            this.jobTypeControlGroup.setValidationState(ValidationState.ERROR);
            this.jobTypeHelpInline.setText(Constants.INSTANCE.The_Job_Must_Have_A_Type());
            valid = false;
        } else {
            this.jobTypeControlGroup.setValidationState(ValidationState.SUCCESS);
        }
        if (this.jobRetriesNumber.getValue() == null || (Integer)this.jobRetriesNumber.getValue() < 0) {
            this.jobRetriesControlGroup.setValidationState(ValidationState.ERROR);
            this.jobRetriesHelpInline.setText(Constants.INSTANCE.The_Job_Must_Have_A_Positive_Number_Of_Reties());
            valid = false;
        } else {
            this.jobRetriesControlGroup.setValidationState(ValidationState.SUCCESS);
        }
        if (!valid) {
            this.basicTab.showTab();
        }
        return valid;
    }

    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    public void makeRowEditable(RequestParameterSummary parameter) {
        this.myParametersGrid.getSelectionModel().setSelected((Object)parameter, true);
    }

    public void removeRow(RequestParameterSummary parameter) {
        this.dataProvider.getList().remove(parameter);
    }

    public void addRow(RequestParameterSummary parameter) {
        this.dataProvider.getList().add(parameter);
    }

    private void initGridColumns() {
        Column<RequestParameterSummary, String> paramKeyColumn = new Column<RequestParameterSummary, String>((Cell)new EditTextCell()){

            public String getValue(RequestParameterSummary rowObject) {
                return rowObject.getKey();
            }
        };
        paramKeyColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<RequestParameterSummary, String>(){

            public void update(int index, RequestParameterSummary object, String value) {
                object.setKey(value);
                QuickNewJobPopup.this.dataProvider.getList().set(index, object);
            }
        });
        this.myParametersGrid.addColumn((Column)paramKeyColumn, new ResizableHeader<RequestParameterSummary>(this.constants.Key(), (AbstractCellTable<RequestParameterSummary>)this.myParametersGrid, paramKeyColumn));
        Column<RequestParameterSummary, String> paramValueColumn = new Column<RequestParameterSummary, String>((Cell)new EditTextCell()){

            public String getValue(RequestParameterSummary rowObject) {
                return rowObject.getValue();
            }
        };
        paramValueColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<RequestParameterSummary, String>(){

            public void update(int index, RequestParameterSummary object, String value) {
                object.setValue(value);
                QuickNewJobPopup.this.dataProvider.getList().set(index, object);
            }
        });
        this.myParametersGrid.addColumn((Column)paramValueColumn, new ResizableHeader<RequestParameterSummary>(this.constants.Value(), (AbstractCellTable<RequestParameterSummary>)this.myParametersGrid, paramValueColumn));
        ButtonCell buttonCell = new ButtonCell(ButtonType.DANGER, IconType.TRASH);
        Column<RequestParameterSummary, String> actionsColumn = new Column<RequestParameterSummary, String>((Cell)buttonCell){

            public String getValue(RequestParameterSummary object) {
                return Constants.INSTANCE.Remove();
            }
        };
        actionsColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<RequestParameterSummary, String>(){

            public void update(int index, RequestParameterSummary object, String value) {
                QuickNewJobPopup.this.removeParameter(object);
            }
        });
        actionsColumn.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.myParametersGrid.addColumn((Column)actionsColumn, this.constants.Actions());
        this.myParametersGrid.setColumnWidth((Column)actionsColumn, 90.0, Style.Unit.PX);
        this.dataProvider.addDataDisplay(this.myParametersGrid);
    }

    public void removeParameter(RequestParameterSummary parameter) {
        this.removeRow(parameter);
    }

    public void addNewParameter() {
        this.addRow(new RequestParameterSummary(this.constants.ClickToEdit(), this.constants.ClickToEdit()));
    }

    public void createJob() {
        this.createJob(this.jobNameText.getText(), UTCDateBox.utc2date((Long)(this.jobDueDate.getValue() + this.jobDueDateTime.getValue())), this.jobTypeText.getText(), (Integer)this.jobRetriesNumber.getValue(), this.dataProvider.getList());
    }

    public void createJob(String jobName, Date dueDate, String jobType, Integer numberOfTries, List<RequestParameterSummary> parameters) {
        HashMap<String, String> ctx = new HashMap<String, String>();
        if (parameters != null) {
            for (RequestParameterSummary param : parameters) {
                ctx.put(param.getKey(), param.getValue());
            }
        }
        ctx.put("retries", String.valueOf(numberOfTries));
        ctx.put("businessKey", jobName);
        ((ExecutorServiceEntryPoint)this.executorServices.call((RemoteCallback)new RemoteCallback<Long>(){

            public void callback(Long requestId) {
                QuickNewJobPopup.this.cleanForm();
                QuickNewJobPopup.this.displayNotification(QuickNewJobPopup.this.constants.RequestScheduled(requestId));
                QuickNewJobPopup.this.requestCreatedEvent.fire((Object)new RequestChangedEvent(requestId));
                QuickNewJobPopup.this.closePopup();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                if (throwable instanceof IllegalArgumentException) {
                    QuickNewJobPopup.this.jobTypeControlGroup.setValidationState(ValidationState.ERROR);
                    QuickNewJobPopup.this.jobTypeHelpInline.setText(Constants.INSTANCE.The_Job_Must_Have_A_Valid_Type());
                    return true;
                }
                QuickNewJobPopup.this.errorMessages.setText(throwable.getMessage());
                QuickNewJobPopup.this.errorMessagesGroup.setValidationState(ValidationState.ERROR);
                QuickNewJobPopup.this.basicTab.showTab();
                return true;
            }
        })).scheduleRequest(jobType, dueDate, ctx);
    }

    static interface Binder
    extends UiBinder<Widget, QuickNewJobPopup> {
    }
}

