/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.es.client.editors.requestlist;

import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gwtbootstrap3.client.ui.Button;
import org.jbpm.console.ng.df.client.list.base.DataSetEditorManager;
import org.jbpm.console.ng.es.client.editors.requestlist.RequestListPresenter;
import org.jbpm.console.ng.es.client.editors.requestlist.RequestListViewImpl;
import org.jbpm.console.ng.es.model.RequestSummary;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;
import org.uberfire.ext.widgets.common.client.tables.FilterPagedTable;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class RequestListViewTest {
    @Mock
    protected ExtendedPagedTable<RequestSummary> currentListGrid;
    @Mock
    FilterPagedTable filterPagedTableMock;
    @Mock
    MultiGridPreferencesStore multiGridPreferencesStoreMock;
    @Mock
    protected GridPreferencesStore gridPreferencesStoreMock;
    @Mock
    protected Button mockButton;
    @Mock
    protected RequestListPresenter presenter;
    @Mock
    private DataSetEditorManager dataSetEditorManager;
    @Mock
    private AsyncDataProvider dataProvider;
    @InjectMocks
    private RequestListViewImpl view;

    @Test
    public void testDataStoreNameIsSet() {
        ((ExtendedPagedTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                for (ColumnMeta columnMeta : columns) {
                    Assert.assertNotNull((Object)columnMeta.getColumn().getDataStoreName());
                }
                return null;
            }
        }).when(this.currentListGrid)).addColumns(Mockito.anyList());
        this.view.initColumns(this.currentListGrid);
        ((ExtendedPagedTable)Mockito.verify(this.currentListGrid)).addColumns(Mockito.anyList());
    }

    @Test
    public void setDefaultFilterTitleAndDescriptionTest() {
        Mockito.when((Object)this.filterPagedTableMock.getMultiGridPreferencesStore()).thenReturn((Object)this.multiGridPreferencesStoreMock);
        this.view.resetDefaultFilterTitleAndDescription();
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock, (VerificationMode)Mockito.times((int)7))).getMultiGridPreferencesStore();
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock, (VerificationMode)Mockito.times((int)7))).saveTabSettings(Mockito.anyString(), (HashMap)Mockito.any(HashMap.class));
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock)).saveTabSettings((String)Mockito.eq((Object)(RequestListViewImpl.REQUEST_LIST_PREFIX + "_0")), (HashMap)Mockito.any(HashMap.class));
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock)).saveTabSettings((String)Mockito.eq((Object)(RequestListViewImpl.REQUEST_LIST_PREFIX + "_1")), (HashMap)Mockito.any(HashMap.class));
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock)).saveTabSettings((String)Mockito.eq((Object)(RequestListViewImpl.REQUEST_LIST_PREFIX + "_2")), (HashMap)Mockito.any(HashMap.class));
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock)).saveTabSettings((String)Mockito.eq((Object)(RequestListViewImpl.REQUEST_LIST_PREFIX + "_3")), (HashMap)Mockito.any(HashMap.class));
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock)).saveTabSettings((String)Mockito.eq((Object)(RequestListViewImpl.REQUEST_LIST_PREFIX + "_4")), (HashMap)Mockito.any(HashMap.class));
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock)).saveTabSettings((String)Mockito.eq((Object)(RequestListViewImpl.REQUEST_LIST_PREFIX + "_5")), (HashMap)Mockito.any(HashMap.class));
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock)).saveTabSettings((String)Mockito.eq((Object)(RequestListViewImpl.REQUEST_LIST_PREFIX + "_6")), (HashMap)Mockito.any(HashMap.class));
    }

    @Test
    public void initColumnsTest() {
        ((ExtendedPagedTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                Assert.assertTrue((columns.size() == 6 ? 1 : 0) != 0);
                return null;
            }
        }).when(this.currentListGrid)).addColumns(Mockito.anyList());
        ArrayList columnPreferences = new ArrayList();
        Mockito.when((Object)this.currentListGrid.getGridPreferencesStore()).thenReturn((Object)this.gridPreferencesStoreMock);
        Mockito.when((Object)this.gridPreferencesStoreMock.getColumnPreferences()).thenReturn(columnPreferences);
        this.view.initColumns(this.currentListGrid);
        ((ExtendedPagedTable)Mockito.verify(this.currentListGrid)).addColumns(Mockito.anyList());
    }

    @Test
    public void initDefaultFiltersOwnTaskFilter() {
        Mockito.when((Object)this.presenter.getDataProvider()).thenReturn((Object)this.dataProvider);
        this.view.initDefaultFilters(new GridGlobalPreferences(), this.mockButton);
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock, (VerificationMode)Mockito.times((int)7))).addTab((PagedTable)Mockito.any(ExtendedPagedTable.class), Mockito.anyString(), (Command)Mockito.any(Command.class));
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock)).addAddTableButton(this.mockButton);
        ((RequestListPresenter)Mockito.verify((Object)this.presenter)).setAddingDefaultFilters(true);
        ((RequestListPresenter)Mockito.verify((Object)this.presenter)).setAddingDefaultFilters(false);
    }
}

