/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.gc.client.util;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.Heading;
import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.datepicker.client.ui.DateBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.CalendarUtil;
import java.util.Date;
import org.jbpm.console.ng.gc.client.i18n.Constants;
import org.jbpm.console.ng.gc.client.util.DateRange;
import org.jbpm.console.ng.gc.client.util.DateUtils;

public class CalendarPicker
extends Composite
implements HasValueChangeHandlers<Date> {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private Date currentDate;
    private ViewType viewType;
    private FlowPanel mainPanel = new FlowPanel();
    private FlowPanel calendarPanel = new FlowPanel();
    private FlowPanel iconPanel = new FlowPanel();
    private FlowPanel rightPanel = new FlowPanel();
    private FlowPanel controlsPanel = new FlowPanel();
    private Heading calendarLabel;
    private Heading iconLabel;
    private Heading controlsLabel;
    private IconAnchor calendarIcon;
    private Button previousButton;
    private Button nextButton;
    private Button todayButton;

    public CalendarPicker() {
        this.currentDate = new Date();
        this.viewType = ViewType.DAY;
        this.calendarPanel.setStyleName("span2 offset1");
        this.calendarLabel = new Heading(4);
        this.iconLabel = new Heading(4);
        this.iconLabel.setStyleName("span1");
        this.iconPanel.add((Widget)this.iconLabel);
        this.controlsLabel = new Heading(4);
        this.controlsPanel.add((Widget)this.controlsLabel);
        this.calendarIcon = new IconAnchor();
        this.previousButton = new Button();
        this.nextButton = new Button();
        this.todayButton = new Button();
        this.initWidget((Widget)this.mainPanel);
    }

    public String getViewType() {
        return this.viewType.toString();
    }

    public void setViewType(String viewType) {
        this.viewType = ViewType.valueOf(viewType.toUpperCase());
        this.updateCalendarLabelText();
        this.updateTodayButtonEnabled();
    }

    public void init() {
        this.initCalendarIcon();
        this.calendarPanel.add((Widget)this.calendarLabel);
        this.mainPanel.add((Widget)this.calendarPanel);
        this.initPrevNextTodayButtons();
        this.rightPanel.add((Widget)this.previousButton);
        this.rightPanel.add((Widget)this.todayButton);
        this.rightPanel.add((Widget)this.nextButton);
        this.iconLabel.add((Widget)this.calendarIcon);
        this.iconPanel.add((Widget)this.iconLabel);
        this.mainPanel.add((Widget)this.iconPanel);
        this.rightPanel.setStyleName("btn-group pull-right");
        this.controlsLabel.add((Widget)this.rightPanel);
        this.mainPanel.add((Widget)this.controlsPanel);
        this.updateCalendarLabelText();
    }

    private void adjustDate(boolean back) {
        switch (this.viewType) {
            case DAY: {
                if (back) {
                    CalendarUtil.addDaysToDate((Date)this.currentDate, (int)-1);
                    break;
                }
                CalendarUtil.addDaysToDate((Date)this.currentDate, (int)1);
                break;
            }
            case WEEK: {
                if (back) {
                    CalendarUtil.addDaysToDate((Date)this.currentDate, (int)-7);
                    break;
                }
                CalendarUtil.addDaysToDate((Date)this.currentDate, (int)7);
                break;
            }
            case MONTH: {
                if (back) {
                    this.currentDate = DateUtils.getSameOrClosestDateInPreviousMonth(this.currentDate);
                    break;
                }
                this.currentDate = DateUtils.getSameOrClosestDateInNextMonth(this.currentDate);
                break;
            }
        }
        this.propagateDateChanges();
    }

    private void propagateDateChanges() {
        this.updateCalendarLabelText();
        this.updateTodayButtonEnabled();
        ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.currentDate);
    }

    private void updateCalendarLabelText() {
        switch (this.viewType) {
            case DAY: {
                this.mainPanel.setVisible(true);
                DateTimeFormat fmt = DateTimeFormat.getFormat((String)"EEE, dd MMMM");
                this.calendarLabel.setText(fmt.format(this.currentDate));
                break;
            }
            case WEEK: {
                this.mainPanel.setVisible(true);
                DateTimeFormat fmt = DateTimeFormat.getFormat((String)"dd MMM");
                DateRange weekRange = DateUtils.getWeekDateRange(this.currentDate);
                String text = fmt.format(weekRange.getStartDate());
                text = text + " - " + fmt.format(weekRange.getEndDate());
                this.calendarLabel.setText(text);
                break;
            }
            case MONTH: {
                this.mainPanel.setVisible(true);
                DateTimeFormat fmt = DateTimeFormat.getFormat((String)"MMMM yy");
                this.calendarLabel.setText(fmt.format(this.currentDate));
                break;
            }
            case GRID: {
                this.mainPanel.setVisible(false);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized view type " + (Object)((Object)this.viewType));
            }
        }
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Date> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    private void initCalendarIcon() {
        this.calendarIcon.setIcon(IconType.CALENDAR);
        this.calendarIcon.setTitle(Constants.INSTANCE.Select_Date());
        this.calendarIcon.setIconSize(IconSize.LARGE);
        this.calendarIcon.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CalendarPicker.this.calendarPanel.clear();
                DateBox dateBox = new DateBox();
                dateBox.setAutoClose(true);
                dateBox.setValue(CalendarPicker.this.currentDate, false);
                dateBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Date>(){

                    public void onValueChange(ValueChangeEvent<Date> event) {
                        CalendarPicker.this.currentDate = (Date)event.getValue();
                        CalendarPicker.this.propagateDateChanges();
                    }
                });
                CalendarPicker.this.calendarPanel.add((Widget)dateBox);
                dateBox.show();
                dateBox.removeFromParent();
                CalendarPicker.this.calendarPanel.add((Widget)CalendarPicker.this.calendarLabel);
            }
        });
    }

    private void initPrevNextTodayButtons() {
        this.previousButton.setIcon(IconType.CARET_LEFT);
        this.previousButton.setTitle(Constants.INSTANCE.Previous());
        this.previousButton.setIconSize(IconSize.LARGE);
        this.previousButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CalendarPicker.this.adjustDate(true);
            }
        });
        this.nextButton.setIcon(IconType.CARET_RIGHT);
        this.nextButton.setTitle(Constants.INSTANCE.Next());
        this.nextButton.setIconSize(IconSize.LARGE);
        this.nextButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CalendarPicker.this.adjustDate(false);
            }
        });
        this.todayButton.setText(this.constants.Today());
        this.todayButton.setEnabled(false);
        this.todayButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CalendarPicker.this.currentDate = new Date();
                CalendarPicker.this.propagateDateChanges();
            }
        });
    }

    private void updateTodayButtonEnabled() {
        boolean todayBtnEnabled = true;
        Date today = new Date();
        switch (this.viewType) {
            case DAY: {
                if (!DateUtils.areDatesEqual(today, this.currentDate)) break;
                todayBtnEnabled = false;
                break;
            }
            case WEEK: {
                DateRange weekRange = DateUtils.getWeekDateRange(this.currentDate);
                if (!DateUtils.isDateInRange(today, weekRange)) break;
                todayBtnEnabled = false;
                break;
            }
            case MONTH: {
                DateRange monthRange = DateUtils.getMonthDateRange(this.currentDate);
                if (!DateUtils.isDateInRange(today, monthRange)) break;
                todayBtnEnabled = false;
                break;
            }
            case GRID: {
                todayBtnEnabled = false;
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized calendar view type: " + (Object)((Object)this.viewType));
            }
        }
        this.todayButton.setEnabled(todayBtnEnabled);
    }

    public static enum ViewType {
        DAY,
        WEEK,
        MONTH,
        GRID;

    }
}

