/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.gc.client.util;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import org.jbpm.console.ng.gc.client.util.UTCDateBox;
import org.jbpm.console.ng.gc.client.util.UTCTimeBoxImplShared;

public class UTCTimeBoxImplHtml4
extends UTCTimeBoxImplShared {
    private static final String CLASSNAME_INVALID = "invalid";
    private TextBox textbox = new TextBox();
    private TimeBoxMenu menu;
    private Long lastKnownValue;

    public UTCTimeBoxImplHtml4() {
        TextBoxHandler handler = new TextBoxHandler();
        this.textbox.addKeyDownHandler((KeyDownHandler)handler);
        this.textbox.addBlurHandler((BlurHandler)handler);
        this.textbox.addClickHandler((ClickHandler)handler);
        this.textbox.setStyleName("gwt-TimeBox");
        this.initWidget((Widget)this.textbox);
    }

    @Override
    public void setTimeFormat(DateTimeFormat timeFormat) {
        super.setTimeFormat(timeFormat);
        this.menu = new TimeBoxMenu();
    }

    public TextBox getTextBox() {
        return this.textbox;
    }

    public void showMenu() {
        this.menu.showTimePicker();
    }

    public void hideMenu() {
        this.menu.hide();
    }

    public boolean hasValue() {
        return this.getText().trim().length() > 0;
    }

    public boolean hasValidValue() {
        return !this.hasValue() || this.getValue() != null;
    }

    public Long getValue() {
        return this.text2value(this.getText());
    }

    public void setValue(Long value, boolean fireEvents) {
        this.setValue(value, true, fireEvents);
    }

    protected void setValue(Long value, boolean updateTextBox, boolean fireEvents) {
        if (updateTextBox) {
            this.syncTextToValue(value);
        }
        Long oldValue = this.lastKnownValue;
        this.lastKnownValue = value;
        if (fireEvents && !this.isSameValue(oldValue, value)) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
        }
    }

    protected boolean isSameValue(Long a, Long b) {
        return a == null ? b == null : a.equals(b);
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Long> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public String getText() {
        return this.textbox.getValue();
    }

    public void setText(String text) {
        this.textbox.setValue((Object)text);
        this.syncValueToText();
    }

    protected void syncTextToValue(Long value) {
        this.textbox.setValue((Object)this.value2text(value));
    }

    protected void syncValueToText() {
        this.setValue(this.text2value(this.getText()), false, true);
    }

    @Override
    public void validate() {
        boolean valid = true;
        if (this.hasValue()) {
            Long value = this.getValue();
            if (value != null) {
                this.setText(this.value2text(value));
            } else {
                valid = false;
            }
        }
        this.setStyleName(CLASSNAME_INVALID, !valid);
    }

    @Override
    public void setVisibleLength(int length) {
        this.textbox.setVisibleLength(length);
    }

    @Override
    public void setTabIndex(int tabIndex) {
        this.textbox.setTabIndex(tabIndex);
    }

    public void clearInvalidStyle() {
        this.removeStyleName(CLASSNAME_INVALID);
    }

    private class TimeBoxMenu
    extends PopupPanel {
        private static final long INTERVAL = 1800000L;
        private static final long DAY = 86400000L;
        private TimeBoxMenuOption[] options;
        private int highlightedOptionIndex;

        public TimeBoxMenu() {
            super(true);
            this.highlightedOptionIndex = -1;
            this.setStyleName("gwt-TimeBox-menu");
            this.addAutoHidePartner((Element)UTCTimeBoxImplHtml4.this.textbox.getElement());
            FlowPanel container = new FlowPanel();
            int numOptions = 48;
            this.options = new TimeBoxMenuOption[numOptions];
            for (int i = 0; i < numOptions; ++i) {
                this.options[i] = new TimeBoxMenuOption((long)i * 1800000L);
                container.add((Widget)this.options[i]);
            }
            this.add((Widget)container);
        }

        public void adjustHighlight(int distance) {
            if (!this.isShowing()) {
                this.showTimePicker();
            }
            int index = this.normalizeOptionIndex(this.highlightedOptionIndex + distance);
            this.setHighlightedIndex(index);
            this.scrollToIndex(index);
        }

        public void acceptHighlighted() {
            if (this.hasHighlightedOption()) {
                this.options[this.highlightedOptionIndex].acceptValue();
            }
        }

        private boolean hasHighlightedOption() {
            return this.highlightedOptionIndex != -1;
        }

        private int normalizeOptionIndex(int index) {
            if (index < 0) {
                return 0;
            }
            if (index >= this.options.length) {
                return this.options.length - 1;
            }
            return index;
        }

        public void scrollToIndex(int index) {
            this.options[this.normalizeOptionIndex(index)].getElement().scrollIntoView();
            this.getContainerElement().setScrollLeft(0);
        }

        public void setHighlightedIndex(int index) {
            if (index != this.highlightedOptionIndex) {
                if (this.hasHighlightedOption()) {
                    this.options[this.highlightedOptionIndex].setHighlighted(false);
                }
                this.highlightedOptionIndex = index;
                this.options[index].setHighlighted(true);
                this.scrollToIndex(index);
            }
        }

        public void showTimePicker() {
            this.showRelativeTo((UIObject)UTCTimeBoxImplHtml4.this.textbox);
            int lastOptionLessThanCurrentTime = 0;
            this.highlightedOptionIndex = -1;
            Long currentTime = UTCTimeBoxImplHtml4.this.getValue();
            for (int i = 0; i < this.options.length; ++i) {
                boolean isEqual;
                TimeBoxMenuOption option = this.options[i];
                boolean bl = isEqual = currentTime != null && option.isTimeEqualTo(currentTime);
                if (isEqual) {
                    this.highlightedOptionIndex = i;
                }
                option.setSelected(isEqual);
                option.setHighlighted(isEqual);
                if (currentTime == null || !option.isTimeLessThan(currentTime)) continue;
                lastOptionLessThanCurrentTime = i;
            }
            int index = this.hasHighlightedOption() ? this.highlightedOptionIndex : this.normalizeOptionIndex(lastOptionLessThanCurrentTime);
            this.setHighlightedIndex(index);
            this.scrollToIndex(index + 6);
        }
    }

    private class TimeBoxMenuOption
    extends SimplePanel {
        private long offsetFromMidnight;
        private String value;

        public TimeBoxMenuOption(long offsetFromMidnight) {
            this.offsetFromMidnight = offsetFromMidnight;
            long time = UTCDateBox.timezoneOffsetMillis(new Date(0L)) + offsetFromMidnight;
            this.value = UTCTimeBoxImplHtml4.this.timeFormat.format(new Date(time));
            Anchor anchor = new Anchor(this.value);
            anchor.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    TimeBoxMenuOption.this.acceptValue();
                    UTCTimeBoxImplHtml4.this.hideMenu();
                    UTCTimeBoxImplHtml4.this.clearInvalidStyle();
                }
            });
            this.setWidget((Widget)anchor);
        }

        public void acceptValue() {
            UTCTimeBoxImplHtml4.this.setText(this.value);
        }

        public void setSelected(boolean isSelected) {
            this.setStyleName("selected", isSelected);
        }

        public void setHighlighted(boolean isHighlighted) {
            this.setStyleName("highlighted", isHighlighted);
        }

        private long getTime() {
            return this.offsetFromMidnight;
        }

        public boolean isTimeEqualTo(long time) {
            long compare = this.getTime();
            return compare == time;
        }

        public boolean isTimeLessThan(long time) {
            return this.getTime() < time;
        }
    }

    private class TextBoxHandler
    implements KeyDownHandler,
    BlurHandler,
    ClickHandler {
        private TextBoxHandler() {
        }

        public void onKeyDown(KeyDownEvent event) {
            switch (event.getNativeKeyCode()) {
                case 38: {
                    UTCTimeBoxImplHtml4.this.menu.adjustHighlight(-1);
                    break;
                }
                case 40: {
                    UTCTimeBoxImplHtml4.this.menu.adjustHighlight(1);
                    break;
                }
                case 9: 
                case 13: {
                    if (UTCTimeBoxImplHtml4.this.menu.isShowing()) {
                        UTCTimeBoxImplHtml4.this.menu.acceptHighlighted();
                        UTCTimeBoxImplHtml4.this.hideMenu();
                        UTCTimeBoxImplHtml4.this.clearInvalidStyle();
                        break;
                    }
                    UTCTimeBoxImplHtml4.this.syncValueToText();
                    UTCTimeBoxImplHtml4.this.validate();
                    break;
                }
                case 27: {
                    UTCTimeBoxImplHtml4.this.validate();
                    UTCTimeBoxImplHtml4.this.hideMenu();
                    break;
                }
                default: {
                    UTCTimeBoxImplHtml4.this.hideMenu();
                    UTCTimeBoxImplHtml4.this.clearInvalidStyle();
                }
            }
        }

        public void onBlur(BlurEvent event) {
            UTCTimeBoxImplHtml4.this.validate();
        }

        public void onClick(ClickEvent event) {
            UTCTimeBoxImplHtml4.this.showMenu();
        }
    }
}

