/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.gc.client.list.base;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.console.ng.ga.model.GenericSummary;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.i18n.Constants;
import org.jbpm.console.ng.gc.client.list.base.AbstractListPresenter;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.services.shared.preferences.UserPreferencesType;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class AbstractListView<T extends GenericSummary, V extends AbstractListPresenter>
extends Composite
implements RequiresResize {
    @Inject
    public User identity;
    @Inject
    protected Event<NotificationEvent> notification;
    @Inject
    protected PlaceManager placeManager;
    @Inject
    private Caller<UserPreferencesService> preferencesService;
    protected V presenter;
    protected ExtendedPagedTable<T> listGrid;
    protected RowStyles<T> selectedStyles = new RowStyles<T>(){

        public String getStyleNames(T row, int rowIndex) {
            if (rowIndex == AbstractListView.this.selectedRow) {
                return "selected";
            }
            return null;
        }
    };
    protected NoSelectionModel<T> selectionModel;
    protected T selectedItem;
    protected int selectedRow = -1;
    protected Column actionsColumn;
    protected DefaultSelectionEventManager<T> noActionColumnManager;

    public void init(final V presenter, final GridGlobalPreferences preferences) {
        this.presenter = presenter;
        this.listGrid = new ExtendedPagedTable(10, preferences);
        this.listGrid.setShowLastPagerButton(true);
        this.listGrid.setShowFastFordwardPagerButton(true);
        this.initWidget((Widget)this.listGrid);
        ((AbstractListPresenter)presenter).addDataDisplay(this.listGrid);
        ((UserPreferencesService)this.preferencesService.call((RemoteCallback)new RemoteCallback<GridPreferencesStore>(){

            public void callback(GridPreferencesStore preferencesStore) {
                AbstractListView.this.listGrid.setPreferencesService(AbstractListView.this.preferencesService);
                if (preferencesStore == null) {
                    AbstractListView.this.listGrid.setGridPreferencesStore(new GridPreferencesStore(preferences));
                } else {
                    AbstractListView.this.listGrid.setGridPreferencesStore(preferencesStore);
                }
                presenter.onGridPreferencesStoreLoaded();
                AbstractListView.this.initColumns(AbstractListView.this.listGrid);
                AbstractListView.this.initGenericToolBar();
                AbstractListView.this.listGrid.loadPageSizePreferences();
            }
        })).loadUserPreferences(preferences.getKey(), UserPreferencesType.GRIDPREFERENCES);
    }

    public void onResize() {
    }

    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    public void initGenericToolBar() {
        Button refreshButton = new Button();
        refreshButton.setIcon(IconType.REFRESH);
        refreshButton.setTitle(Constants.INSTANCE.Refresh());
        refreshButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ((AbstractListPresenter)AbstractListView.this.presenter).refreshGrid();
            }
        });
        this.listGrid.getRightToolbar().add((Widget)refreshButton);
    }

    public ExtendedPagedTable<T> getListGrid() {
        return this.listGrid;
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    public abstract void initColumns(ExtendedPagedTable<T> var1);

    public static interface ListView<T extends GenericSummary, V>
    extends BasicListView<T>,
    UberView<V> {
    }

    public static interface BasicListView<T extends GenericSummary>
    extends IsWidget {
        public void showBusyIndicator(String var1);

        public void hideBusyIndicator();

        public void displayNotification(String var1);

        public ExtendedPagedTable<T> getListGrid();
    }
}

