/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.gc.client.list.base;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.Divider;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.Pull;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.jbpm.console.ng.gc.client.i18n.Constants;
import org.jbpm.console.ng.gc.client.list.base.AbstractListPresenter;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

public class RefreshSelectorMenuBuilder
implements MenuFactory.CustomMenuBuilder {
    private AbstractListPresenter presenter;
    private final DropDownMenu menuDropDownMenu = new DropDownMenu();
    private final Button menuButton = (Button)GWT.create(Button.class);

    public RefreshSelectorMenuBuilder(AbstractListPresenter presenter) {
        this.presenter = presenter;
        this.setupMenuButton();
        this.setupMenuDropDown();
    }

    public void push(MenuFactory.CustomMenuBuilder element) {
    }

    public MenuItem build() {
        return new BaseMenuCustom<IsWidget>(){

            public IsWidget build() {
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add((Widget)RefreshSelectorMenuBuilder.this.menuButton);
                buttonGroup.add((Widget)RefreshSelectorMenuBuilder.this.menuDropDownMenu);
                return buttonGroup;
            }

            public boolean isEnabled() {
                return true;
            }

            public void setEnabled(boolean enabled) {
            }

            public String getSignatureId() {
                return "org.jbpm.console.ng.gc.client.list.base.RefreshSelectorMenuBuilder#refresh";
            }
        };
    }

    protected void setupMenuButton() {
        this.menuButton.setDataToggle(Toggle.DROPDOWN);
        this.menuButton.setIcon(IconType.COG);
        this.menuButton.setTitle(Constants.INSTANCE.AutoRefresh());
        this.menuButton.setSize(ButtonSize.SMALL);
    }

    protected void setupMenuDropDown() {
        this.menuDropDownMenu.setPull(Pull.RIGHT);
    }

    protected AnchorListItem createTimeSelector(int time, String name, int configuredSeconds, final AnchorListItem refreshDisableButton) {
        final AnchorListItem oneMinuteRadioButton = new AnchorListItem(name);
        oneMinuteRadioButton.setIconFixedWidth(true);
        final int selectedRefreshTime = time;
        if (configuredSeconds == selectedRefreshTime) {
            oneMinuteRadioButton.setIcon(IconType.CHECK);
        }
        oneMinuteRadioButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                oneMinuteRadioButton.setIcon(IconType.CHECK);
                RefreshSelectorMenuBuilder.this.presenter.updateRefreshInterval(true, selectedRefreshTime);
                refreshDisableButton.setActive(false);
                refreshDisableButton.setEnabled(true);
                refreshDisableButton.setText(Constants.INSTANCE.Disable_autorefresh());
            }
        });
        return oneMinuteRadioButton;
    }

    public void loadOptions(int configuredSeconds) {
        final AnchorListItem resetButton = new AnchorListItem(Constants.INSTANCE.Disable_autorefresh());
        if (configuredSeconds > 10) {
            this.presenter.updateRefreshInterval(true, configuredSeconds);
            resetButton.setEnabled(true);
        } else {
            this.presenter.updateRefreshInterval(false, 0);
            resetButton.setEnabled(false);
            resetButton.setText(Constants.INSTANCE.Autorefresh_Disabled());
        }
        final AnchorListItem oneMinuteRadioButton = this.createTimeSelector(60, "1 " + Constants.INSTANCE.Minute(), configuredSeconds, resetButton);
        final AnchorListItem fiveMinuteRadioButton = this.createTimeSelector(300, "5 " + Constants.INSTANCE.Minutes(), configuredSeconds, resetButton);
        final AnchorListItem tenMinuteRadioButton = this.createTimeSelector(600, "10 " + Constants.INSTANCE.Minutes(), configuredSeconds, resetButton);
        this.menuDropDownMenu.add((Widget)oneMinuteRadioButton);
        this.menuDropDownMenu.add((Widget)fiveMinuteRadioButton);
        this.menuDropDownMenu.add((Widget)tenMinuteRadioButton);
        oneMinuteRadioButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                fiveMinuteRadioButton.setIcon(null);
                tenMinuteRadioButton.setIcon(null);
            }
        });
        fiveMinuteRadioButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                oneMinuteRadioButton.setIcon(null);
                tenMinuteRadioButton.setIcon(null);
            }
        });
        tenMinuteRadioButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                oneMinuteRadioButton.setIcon(null);
                fiveMinuteRadioButton.setIcon(null);
            }
        });
        resetButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                RefreshSelectorMenuBuilder.this.presenter.updateRefreshInterval(false, 0);
                resetButton.setActive(false);
                resetButton.setEnabled(false);
                resetButton.setText(Constants.INSTANCE.Autorefresh_Disabled());
                oneMinuteRadioButton.setIcon(null);
                fiveMinuteRadioButton.setIcon(null);
                tenMinuteRadioButton.setIcon(null);
            }
        });
        this.menuDropDownMenu.add((Widget)new Divider());
        this.menuDropDownMenu.add((Widget)resetButton);
    }
}

