/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.gc.client.dataset;

import com.google.gwt.core.client.GWT;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.jbpm.console.ng.gc.client.i18n.Constants;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;

public abstract class AbstractDataSetReadyCallback
implements DataSetReadyCallback {
    private ErrorPopupPresenter errorPopup;
    private AbstractListView.BasicListView view;
    private DataSet dataSet;

    public AbstractDataSetReadyCallback(ErrorPopupPresenter errorPopup, AbstractListView.BasicListView view, DataSet dataSet) {
        this.errorPopup = errorPopup;
        this.view = view;
        this.dataSet = dataSet;
    }

    public void notFound() {
        this.view.hideBusyIndicator();
        this.errorPopup.showMessage(Constants.INSTANCE.DataSetNotFound(this.dataSet.getUUID()));
        GWT.log((String)("DataSet with UUID [ " + this.dataSet.getUUID() + " ] not found."));
    }

    public boolean onError(ClientRuntimeError error) {
        this.view.hideBusyIndicator();
        this.errorPopup.showMessage(Constants.INSTANCE.DataSetError(this.dataSet.getUUID(), error.getMessage()));
        GWT.log((String)("DataSet with UUID [ " + this.dataSet.getUUID() + " ] error: "), (Throwable)error.getThrowable());
        return false;
    }
}

