/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ga.forms.display.backend;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.enterprise.inject.Instance;
import org.apache.commons.io.IOUtils;
import org.jbpm.console.ng.ga.forms.display.FormRenderingSettings;
import org.jbpm.console.ng.ga.forms.display.backend.FormServiceEntryPointImpl;
import org.jbpm.console.ng.ga.forms.display.backend.provider.ClasspathFormProvider;
import org.jbpm.console.ng.ga.forms.display.backend.provider.InMemoryFormProvider;
import org.jbpm.console.ng.ga.forms.display.impl.StaticHTMLFormRenderingSettings;
import org.jbpm.console.ng.ga.forms.service.providing.FormProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.definition.TaskInputsDefinition;
import org.kie.server.api.model.definition.TaskOutputsDefinition;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.client.DocumentServicesClient;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesException;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.UIServicesClient;
import org.kie.server.client.UserTaskServicesClient;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class FormServiceEntryPointImplTest {
    protected InMemoryFormProvider inMemoryFormProvider = new InMemoryFormProvider();
    protected ClasspathFormProvider classpathFormProvider = new ClasspathFormProvider();
    @Mock
    protected DocumentServicesClient documentServicesClient;
    @Mock
    protected UIServicesClient uiServicesClient;
    @Mock
    protected UserTaskServicesClient userTaskServicesClient;
    @Mock
    protected ProcessServicesClient processServicesClient;
    @Mock
    protected KieServicesClient kieServicesClient;
    protected FormServiceEntryPointImpl serviceEntryPoint;
    protected String formContent;

    @Before
    public void init() {
        Instance instance = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)instance.iterator()).then(result -> Arrays.asList(this.inMemoryFormProvider).iterator());
        this.serviceEntryPoint = new FormServiceEntryPointImpl(instance, (FormProvider)this.classpathFormProvider){

            protected <T> T getClient(String serverTemplateId, String containerId, Class<T> clientType) {
                if (clientType.equals(DocumentServicesClient.class)) {
                    return (T)FormServiceEntryPointImplTest.this.documentServicesClient;
                }
                if (clientType.equals(UIServicesClient.class)) {
                    return (T)FormServiceEntryPointImplTest.this.uiServicesClient;
                }
                if (clientType.equals(UserTaskServicesClient.class)) {
                    return (T)FormServiceEntryPointImplTest.this.userTaskServicesClient;
                }
                if (clientType.equals(ProcessServicesClient.class)) {
                    return (T)FormServiceEntryPointImplTest.this.processServicesClient;
                }
                return null;
            }

            protected KieServicesClient getKieServicesClient(String serverTemplateId, String containerId) {
                return FormServiceEntryPointImplTest.this.kieServicesClient;
            }
        };
        this.formContent = this.getFormContent();
        ProcessDefinition processDefinition = new ProcessDefinition();
        processDefinition.setId("testProcess");
        processDefinition.setName("testProcess");
        processDefinition.setContainerId("localhost");
        processDefinition.setPackageName("org.jbpm.test");
        Mockito.when((Object)this.processServicesClient.getProcessDefinition(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)processDefinition);
        Mockito.when((Object)this.processServicesClient.getUserTaskInputDefinitions(Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)new TaskInputsDefinition());
        Mockito.when((Object)this.processServicesClient.getUserTaskOutputDefinitions(Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)new TaskOutputsDefinition());
        TaskInstance taskInstance = new TaskInstance();
        taskInstance.setId(new Long(12L));
        taskInstance.setName("TaskName");
        taskInstance.setFormName("TaskFormName");
        taskInstance.setDescription("TaskDescription");
        taskInstance.setProcessId("testProcess");
        Mockito.when((Object)this.userTaskServicesClient.getTaskInstance(Mockito.anyString(), Long.valueOf(Mockito.anyLong()), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean())).thenReturn((Object)taskInstance);
    }

    @Test
    public void testRenderProcessForm() {
        Mockito.when((Object)this.uiServicesClient.getProcessRawForm(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)this.formContent);
        FormRenderingSettings settings = this.serviceEntryPoint.getFormDisplayProcess("template", "domain", "testProcess");
        ((ProcessServicesClient)Mockito.verify((Object)this.processServicesClient)).getProcessDefinition(Mockito.anyString(), Mockito.anyString());
        ((KieServicesClient)Mockito.verify((Object)this.kieServicesClient)).getClassLoader();
        ((UIServicesClient)Mockito.verify((Object)this.uiServicesClient)).getProcessRawForm(Mockito.anyString(), Mockito.anyString());
        Assert.assertNotNull((String)"Settings cannot be null", (Object)settings);
        Assert.assertTrue((String)"Settings must be Static HTML", (boolean)(settings instanceof StaticHTMLFormRenderingSettings));
        StaticHTMLFormRenderingSettings htmlSettings = (StaticHTMLFormRenderingSettings)settings;
        Assert.assertEquals((String)"FormContent must be equal", (Object)this.formContent, (Object)htmlSettings.getFormContent());
    }

    @Test
    public void testRenderProcessDefaultForm() {
        FormRenderingSettings settings = this.serviceEntryPoint.getFormDisplayProcess("template", "domain", "testProcess");
        ((ProcessServicesClient)Mockito.verify((Object)this.processServicesClient)).getProcessDefinition(Mockito.anyString(), Mockito.anyString());
        ((KieServicesClient)Mockito.verify((Object)this.kieServicesClient, (VerificationMode)Mockito.times((int)2))).getClassLoader();
        ((UIServicesClient)Mockito.verify((Object)this.uiServicesClient)).getProcessRawForm(Mockito.anyString(), Mockito.anyString());
        Assert.assertNotNull((String)"Settings cannot be null", (Object)settings);
        Assert.assertTrue((String)"Settings must be Static HTML", (boolean)(settings instanceof StaticHTMLFormRenderingSettings));
        StaticHTMLFormRenderingSettings htmlSettings = (StaticHTMLFormRenderingSettings)settings;
        Assert.assertNotEquals((String)"FormContent must be equal", (Object)this.formContent, (Object)htmlSettings.getFormContent());
    }

    @Test
    public void testRenderProcessDefaultFormWithException() {
        Mockito.when((Object)this.uiServicesClient.getProcessRawForm(Mockito.anyString(), Mockito.anyString())).thenThrow(new Throwable[]{new KieServicesException("Unable to find form")});
        FormRenderingSettings settings = this.serviceEntryPoint.getFormDisplayProcess("template", "domain", "testProcess");
        ((ProcessServicesClient)Mockito.verify((Object)this.processServicesClient)).getProcessDefinition(Mockito.anyString(), Mockito.anyString());
        ((KieServicesClient)Mockito.verify((Object)this.kieServicesClient)).getClassLoader();
        ((UIServicesClient)Mockito.verify((Object)this.uiServicesClient)).getProcessRawForm(Mockito.anyString(), Mockito.anyString());
        Assert.assertNotNull((String)"Settings cannot be null", (Object)settings);
        Assert.assertTrue((String)"Settings must be Static HTML", (boolean)(settings instanceof StaticHTMLFormRenderingSettings));
        StaticHTMLFormRenderingSettings htmlSettings = (StaticHTMLFormRenderingSettings)settings;
        Assert.assertNotEquals((String)"FormContent must be equal", (Object)this.formContent, (Object)htmlSettings.getFormContent());
    }

    @Test
    public void testRenderTaskForm() {
        Mockito.when((Object)this.uiServicesClient.getTaskRawForm(Mockito.anyString(), Long.valueOf(Mockito.anyLong()))).thenReturn((Object)this.formContent);
        FormRenderingSettings settings = this.serviceEntryPoint.getFormDisplayTask("template", "domain", 12L);
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).getTaskInstance(Mockito.anyString(), Long.valueOf(Mockito.anyLong()), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean());
        ((KieServicesClient)Mockito.verify((Object)this.kieServicesClient)).getClassLoader();
        ((UIServicesClient)Mockito.verify((Object)this.uiServicesClient)).getTaskRawForm(Mockito.anyString(), Long.valueOf(Mockito.anyLong()));
        Assert.assertNotNull((String)"Settings cannot be null", (Object)settings);
        Assert.assertTrue((String)"Settings must be Static HTML", (boolean)(settings instanceof StaticHTMLFormRenderingSettings));
        StaticHTMLFormRenderingSettings htmlSettings = (StaticHTMLFormRenderingSettings)settings;
        Assert.assertEquals((String)"FormContent must be equal", (Object)this.formContent, (Object)htmlSettings.getFormContent());
    }

    @Test
    public void testRenderTaskDefaultForm() {
        FormRenderingSettings settings = this.serviceEntryPoint.getFormDisplayTask("template", "domain", 12L);
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).getTaskInstance(Mockito.anyString(), Long.valueOf(Mockito.anyLong()), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean());
        ((KieServicesClient)Mockito.verify((Object)this.kieServicesClient, (VerificationMode)Mockito.times((int)2))).getClassLoader();
        ((UIServicesClient)Mockito.verify((Object)this.uiServicesClient)).getTaskRawForm(Mockito.anyString(), Long.valueOf(Mockito.anyLong()));
        Assert.assertNotNull((String)"Settings cannot be null", (Object)settings);
        Assert.assertTrue((String)"Settings must be Static HTML", (boolean)(settings instanceof StaticHTMLFormRenderingSettings));
        StaticHTMLFormRenderingSettings htmlSettings = (StaticHTMLFormRenderingSettings)settings;
        Assert.assertNotEquals((String)"FormContent must be equal", (Object)this.formContent, (Object)htmlSettings.getFormContent());
    }

    @Test
    public void testRenderTaskDefaultFormWithException() {
        Mockito.when((Object)this.uiServicesClient.getTaskRawForm(Mockito.anyString(), Long.valueOf(Mockito.anyLong()))).thenThrow(new Throwable[]{new KieServicesException("Unable to find form")});
        FormRenderingSettings settings = this.serviceEntryPoint.getFormDisplayTask("template", "domain", 12L);
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).getTaskInstance(Mockito.anyString(), Long.valueOf(Mockito.anyLong()), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean());
        ((KieServicesClient)Mockito.verify((Object)this.kieServicesClient)).getClassLoader();
        ((UIServicesClient)Mockito.verify((Object)this.uiServicesClient)).getTaskRawForm(Mockito.anyString(), Long.valueOf(Mockito.anyLong()));
        Assert.assertNotNull((String)"Settings cannot be null", (Object)settings);
        Assert.assertTrue((String)"Settings must be Static HTML", (boolean)(settings instanceof StaticHTMLFormRenderingSettings));
        StaticHTMLFormRenderingSettings htmlSettings = (StaticHTMLFormRenderingSettings)settings;
        Assert.assertNotEquals((String)"FormContent must be equal", (Object)this.formContent, (Object)htmlSettings.getFormContent());
    }

    protected String getFormContent() {
        try {
            return IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/forms/form.ftl"));
        }
        catch (IOException ex) {
            Assert.fail((String)"Exception thrown getting form content");
            return "";
        }
    }
}

