/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.backend.server;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.inject.Inject;
import org.jbpm.console.ng.ht.service.TaskServiceEntryPoint;
import org.jbpm.services.task.impl.model.UserImpl;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.InternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HumanTasksBackendBaseTest {
    protected static Logger logger = LoggerFactory.getLogger(HumanTasksBackendBaseTest.class);
    protected static boolean usersLoaded = false;
    @Inject
    protected InternalTaskService taskService;
    @Inject
    protected TaskServiceEntryPoint consoleTaskService;

    @Before
    public void setUp() {
        if (!usersLoaded) {
            try {
                this.taskService.addUser((User)new UserImpl("Administrator"));
                usersLoaded = true;
            }
            catch (Exception ex) {
                logger.error("Error while adding user Administrator! {}", (Object)ex.getMessage());
            }
        }
    }

    @After
    public void tearDown() {
        this.taskService.removeAllTasks();
    }

    @AfterClass
    public static void tearDownClass() {
        usersLoaded = false;
    }

    protected void printTestName() {
        System.out.println("Running " + this.getClass().getSimpleName() + "." + Thread.currentThread().getStackTrace()[2].getMethodName());
    }

    protected Date createDate(String dateString) {
        return this.createDate(dateString, "yyyy-MM-dd");
    }

    protected Date createDate(String dateString, String dateFormat) {
        SimpleDateFormat fmt = new SimpleDateFormat(dateFormat);
        try {
            return fmt.parse(dateString);
        }
        catch (ParseException e) {
            throw new RuntimeException("Can't create date from string '" + dateString + "' using '" + dateFormat + "' format!", e);
        }
    }
}

