/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.backend.server;

import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.bd.service.KieSessionEntryPoint;
import org.jbpm.console.ng.ht.service.FormModelerProcessStarterEntryPoint;
import org.jbpm.console.ng.ht.service.TaskServiceEntryPoint;
import org.jbpm.formModeler.api.client.FormRenderContextManager;

@Service
@ApplicationScoped
public class FormModelerProcessStarterEntryPointImpl
implements FormModelerProcessStarterEntryPoint {
    @Inject
    private FormRenderContextManager formRenderContextManager;
    @Inject
    private KieSessionEntryPoint kieSessionEntryPoint;
    @Inject
    private TaskServiceEntryPoint taskServiceEntryPoint;

    public Long startProcessFromRenderContext(String ctxUID, String domainId, String processId) {
        Map params = this.formRenderContextManager.getFormRenderContext(ctxUID).getOutputData();
        this.formRenderContextManager.removeContext(ctxUID);
        return this.kieSessionEntryPoint.startProcess(domainId, processId, params);
    }

    public Long saveTaskStateFromRenderContext(String ctxUID, Long taskId, boolean clearStatus) {
        Map params = this.formRenderContextManager.getFormRenderContext(ctxUID).getOutputData();
        if (clearStatus) {
            this.formRenderContextManager.removeContext(ctxUID);
        }
        return this.taskServiceEntryPoint.saveContent(taskId.longValue(), params);
    }

    public Long saveTaskStateFromRenderContext(String ctxUID, Long taskId) {
        return this.saveTaskStateFromRenderContext(ctxUID, taskId, false);
    }

    public void completeTaskFromContext(String ctxUID, Long taskId, String identityName) {
        Map params = this.formRenderContextManager.getFormRenderContext(ctxUID).getOutputData();
        this.formRenderContextManager.removeContext(ctxUID);
        this.taskServiceEntryPoint.complete(taskId.longValue(), identityName, params);
    }

    public void clearContext(String ctxUID) {
        this.formRenderContextManager.removeContext(ctxUID);
    }
}

