/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.backend.server;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.jbpm.console.ng.ht.backend.server.HumanTasksBackendBaseTest;
import org.jbpm.console.ng.ht.model.Day;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.services.task.impl.factories.TaskFactory;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.task.model.Task;

public abstract class TaskServiceEntryPointBaseTest
extends HumanTasksBackendBaseTest {
    private static String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";

    @Test
    public void testGetTasksForLongPeriod() {
        Map tasksByDays = this.consoleTaskService.getTasksOwnedFromDateToDateByDays("Bobba Fet", this.getTaskStatuses(), this.createDate("2014-02-24"), 42);
        Assert.assertEquals((long)42L, (long)tasksByDays.size());
        tasksByDays = this.consoleTaskService.getTasksOwnedFromDateToDateByDays("Bobba Fet", this.getTaskStatuses(), this.createDate("2014-02-24"), 3000);
        Assert.assertEquals((long)3000L, (long)tasksByDays.size());
        tasksByDays = this.consoleTaskService.getTasksOwnedFromDateToDateByDays("Bobba Fet", this.getTaskStatuses(), this.createDate("2013-09-30"), 35);
        Assert.assertEquals((long)35L, (long)tasksByDays.size());
    }

    @Test
    public void testGetTasksForLongPeriodWithDayLightSaving() {
        DateTimeZone defaultTZ = DateTimeZone.getDefault();
        DateTimeZone.setDefault((DateTimeZone)DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone("Brazil/East")));
        Map tasksByDays = this.consoleTaskService.getTasksOwnedFromDateToDateByDays("Bobba Fet", this.getTaskStatuses(), this.createDate("2014-02-24"), 42);
        Assert.assertEquals((long)42L, (long)tasksByDays.size());
        tasksByDays = this.consoleTaskService.getTasksOwnedFromDateToDateByDays("Bobba Fet", this.getTaskStatuses(), this.createDate("2014-02-24"), 3000);
        Assert.assertEquals((long)3000L, (long)tasksByDays.size());
        tasksByDays = this.consoleTaskService.getTasksOwnedFromDateToDateByDays("Bobba Fet", this.getTaskStatuses(), this.createDate("2013-09-30"), 35);
        Assert.assertEquals((long)35L, (long)tasksByDays.size());
        DateTimeZone.setDefault((DateTimeZone)defaultTZ);
    }

    @Test
    public void testGetTasksOwnedFromDateToDateByDaysNoTasksAtAll() {
        Map tasksByDays = this.consoleTaskService.getTasksOwnedFromDateToDateByDays("Bobba Fet", this.getTaskStatuses(), this.createDate("2013-04-18"), 3);
        Assert.assertEquals((long)3L, (long)tasksByDays.size());
        this.verifyNoTasksPresent(tasksByDays);
    }

    @Test
    public void testGetTasksOwnedFromDateToDateByDaysNoTasksWithinRange() {
        this.createTaskWithSpecifiedDueDateAndUserAndName("2012-06-08", "Bobba Fet", "Task before");
        this.createTaskWithSpecifiedDueDateAndUserAndName("2013-04-17", "Bobba Fet", "Task before 2");
        this.createTaskWithSpecifiedDueDateAndUserAndName("2013-04-21", "Bobba Fet", "Task after");
        this.createTaskWithSpecifiedDueDateAndUserAndName("2014-01-12", "Bobba Fet", "Task after 2");
        this.createTaskWithNoDueDateAndUserAndName("Bobba Fet", "No due date");
        Map tasksByDays = this.consoleTaskService.getTasksOwnedFromDateToDateByDays("Bobba Fet", this.getTaskStatuses(), this.createDate("2013-04-18"), 3);
        Assert.assertEquals((long)3L, (long)tasksByDays.size());
        this.verifyNoTasksPresent(tasksByDays);
    }

    @Test
    public void testGetTasksOwnedFromDateToDateByDaysOnlyTasksWithNoDueDate() {
        this.createTaskWithNoDueDateAndUserAndName("Bobba Fet", "No due date");
        this.createTaskWithNoDueDateAndUserAndName("Bobba Fet", "No due date 2");
        LocalDate today = new LocalDate();
        Map tasksByDays = this.consoleTaskService.getTasksOwnedFromDateToDateByDays("Bobba Fet", this.getTaskStatuses(), this.toJavaUtilDate(today), 3);
        Assert.assertEquals((long)3L, (long)tasksByDays.size());
        this.verifyCorrectTasksForSpecifiedDay(tasksByDays, today, 2);
        this.verifyCorrectTasksForSpecifiedDay(tasksByDays, today.plusDays(1), 0);
        this.verifyCorrectTasksForSpecifiedDay(tasksByDays, today.plusDays(2), 0);
    }

    @Test
    public void testGetTasksOwnedFromDateToDateByDaysMultipleDifferentTasks() {
        LocalDate today = new LocalDate();
        LocalDate from = today.minusDays(2);
        LocalDate to = today.plusDays(2);
        int nrOfDaysTotal = Days.daysBetween((ReadablePartial)from, (ReadablePartial)to).getDays() + 1;
        int nrOfTasksWithNoExpDate = 2;
        int nrOfTasksForFirstDay = 15;
        int nrOfTasksForSecondDay = 0;
        int nrOfTasksForThirdDay = 1;
        int nrOfTasksForFourthDay = 100;
        int nrOfTasksForFifthDay = 123;
        LocalDate firstDay = from;
        LocalDate secondDay = from.plusDays(1);
        LocalDate thirdDay = from.plusDays(2);
        LocalDate fourthDay = from.plusDays(3);
        LocalDate fifthDay = to;
        this.createTaskWithSpecifiedDueDateAndUserAndName(from.minusDays(1), "Bobba Fet", "Before start date");
        this.createTaskWithSpecifiedDueDateAndUserAndName(from.minusDays(200), "Bobba Fet", "Before start 2");
        this.createTaskWithSpecifiedDueDateAndUserAndName(to.plusDays(1), "Bobba Fet", "After end date");
        this.createTaskWithSpecifiedDueDateAndUserAndName(to.plusDays(300), "Bobba Fet", "After end date 2 ");
        this.createTasksWithSpecifiedDueDateAndUserAndName(firstDay, "Darth Vader", "Correct day, but different owner", 20);
        this.createTasksWithSpecifiedDueDateAndUserAndName(secondDay, "Yoda", "Correct day, but different owner", 100);
        this.createTasksWithSpecifiedDueDateAndUserAndName(thirdDay, "Anakin", "Correct day, but different owner", 5);
        this.createTasksWithSpecifiedDueDateAndUserAndName(fourthDay, "Darth Maul", "Correct day, but different owner", 34);
        this.createTasksWithSpecifiedDueDateAndUserAndName(fifthDay, "Darth Maul", "Correct day, but different owner", 15);
        this.createTaskWithNoDueDateAndUserAndName("Bobba Fet", "No due date");
        this.createTaskWithNoDueDateAndUserAndName("Bobba Fet", "No due date 2 ");
        this.createTasksWithSpecifiedDueDateAndUserAndName(firstDay, "Bobba Fet", "First day task", nrOfTasksForFirstDay);
        this.createTasksWithSpecifiedDueDateAndUserAndName(secondDay, "Bobba Fet", "Second day task", nrOfTasksForSecondDay);
        this.createTasksWithSpecifiedDueDateAndUserAndName(thirdDay, "Bobba Fet", "Third day task", nrOfTasksForThirdDay);
        this.createTasksWithSpecifiedDueDateAndUserAndName(fourthDay, "Bobba Fet", "Fourth day task", nrOfTasksForFourthDay);
        this.createTasksWithSpecifiedDueDateAndUserAndName(fifthDay, "Bobba Fet", "fifth day task", nrOfTasksForFifthDay);
        Map tasksByDays = this.consoleTaskService.getTasksOwnedFromDateToDateByDays("Bobba Fet", this.getTaskStatuses(), this.toJavaUtilDate(from), nrOfDaysTotal);
        Assert.assertEquals((long)nrOfDaysTotal, (long)tasksByDays.size());
        this.verifyCorrectTasksForSpecifiedDay(tasksByDays, firstDay, nrOfTasksForFirstDay);
        this.verifyCorrectTasksForSpecifiedDay(tasksByDays, secondDay, nrOfTasksForSecondDay);
        this.verifyCorrectTasksForSpecifiedDay(tasksByDays, thirdDay, nrOfTasksForThirdDay + nrOfTasksWithNoExpDate);
        this.verifyCorrectTasksForSpecifiedDay(tasksByDays, fourthDay, nrOfTasksForFourthDay);
        this.verifyCorrectTasksForSpecifiedDay(tasksByDays, fifthDay, nrOfTasksForFifthDay);
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerFromDateToDateByDaysNoTasksAtAll() {
        Map tasksByDays = this.consoleTaskService.getTasksAssignedAsPotentialOwnerFromDateToDateByDays("Bobba Fet", this.getTaskStatuses(), this.createDate("2013-04-18"), 3);
        Assert.assertEquals((long)3L, (long)tasksByDays.size());
        this.verifyNoTasksPresent(tasksByDays);
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerFromDateToDateByDaysNoTasksWithinRange() {
        this.createTaskWithSpecifiedDueDateAndUserAndName("2012-06-08", "Bobba Fet", "Task before");
        this.createTaskWithSpecifiedDueDateAndUserAndName("2013-04-17", "Bobba Fet", "Task before 2");
        this.createTaskWithSpecifiedDueDateAndUserAndName("2013-04-21", "Bobba Fet", "Task after");
        this.createTaskWithSpecifiedDueDateAndUserAndName("2014-01-12", "Bobba Fet", "Task after 2");
        this.createTaskWithNoDueDateAndUserAndName("Bobba Fet", "No due date");
        Map tasksByDays = this.consoleTaskService.getTasksAssignedAsPotentialOwnerFromDateToDateByDays("Bobba Fet", this.getTaskStatuses(), this.createDate("2013-04-18"), 3);
        Assert.assertEquals((long)3L, (long)tasksByDays.size());
        this.verifyNoTasksPresent(tasksByDays);
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerFromDateToDateByDaysOnlyTasksWithNoDueDate() {
        this.createTaskWithNoDueDateAndUserAndName("Bobba Fet", "No due date");
        this.createTaskWithNoDueDateAndGroupAndName("Bounty Hunters", "No due date 2");
        LocalDate today = new LocalDate();
        Map tasksByDays = this.consoleTaskService.getTasksAssignedAsPotentialOwnerFromDateToDateByDays("Bobba Fet", this.getTaskStatuses(), this.toJavaUtilDate(today), 3);
        Assert.assertEquals((long)3L, (long)tasksByDays.size());
        this.verifyCorrectTasksForSpecifiedDay(tasksByDays, today, 2);
        this.verifyCorrectTasksForSpecifiedDay(tasksByDays, today.plusDays(1), 0);
        this.verifyCorrectTasksForSpecifiedDay(tasksByDays, today.plusDays(2), 0);
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerFromDateToDateByDaysOnlyGroupTasksNoTasksAtAll() {
        Map tasksByDays = this.consoleTaskService.getTasksAssignedAsPotentialOwnerFromDateToDateByDays("Bobba Fet", this.getStatusesForGroupTasksOnly(), this.createDate("2013-04-18"), 3);
        Assert.assertEquals((long)3L, (long)tasksByDays.size());
        this.verifyNoTasksPresent(tasksByDays);
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerFromDateToDateByDaysOnlyGroupTasks() {
        LocalDate today = new LocalDate();
        this.createTaskWithNoDueDateAndUserAndName("Bobba Fet", "No due date - personal task");
        this.createTaskWithSpecifiedDueDateAndUserAndName(today, "Jedi Knight", "Different group");
        this.createTaskWithNoDueDateAndGroupAndName("Bounty Hunters", "No due date 2 - group task");
        this.createTaskWithSpecifiedDueDateAndGroupAndName(today, "Star Wars", "Valid group");
        this.createTaskWithSpecifiedDueDateAndGroupAndName(today.plusDays(2), "Bounty Hunters", "Valid group - another day");
        Map tasksByDays = this.consoleTaskService.getTasksAssignedAsPotentialOwnerFromDateToDateByDays("Bobba Fet", this.getStatusesForGroupTasksOnly(), this.toJavaUtilDate(today), 3);
        Assert.assertEquals((long)3L, (long)tasksByDays.size());
        this.verifyCorrectTasksForSpecifiedDay(tasksByDays, today, 2);
        this.verifyCorrectTasksForSpecifiedDay(tasksByDays, today.plusDays(1), 0);
        this.verifyCorrectTasksForSpecifiedDay(tasksByDays, today.plusDays(2), 1);
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerFromDateToDateByDaysMultipleDifferentTasks() {
        LocalDate today = new LocalDate();
        LocalDate from = today.minusDays(2);
        LocalDate to = today.plusDays(2);
        int nrOfDaysTotal = Days.daysBetween((ReadablePartial)from, (ReadablePartial)to).getDays() + 1;
        int nrOfTasksWithNoExpDate = 2;
        int nrOfTasksForFirstDay = 18;
        int nrOfTasksForSecondDay = 0;
        int nrOfTasksForThirdDay = 2;
        int nrOfTasksForFourthDay = 10;
        int nrOfTasksForFifthDay = 124;
        LocalDate firstDay = from;
        LocalDate secondDay = from.plusDays(1);
        LocalDate thirdDay = from.plusDays(2);
        LocalDate fourthDay = from.plusDays(3);
        LocalDate fifthDay = to;
        this.createTaskWithSpecifiedDueDateAndUserAndName(from.minusDays(1), "Bobba Fet", "Before start date");
        this.createTaskWithSpecifiedDueDateAndGroupAndName(from.minusDays(200), "Jedi Knights", "Before start 2");
        this.createTaskWithSpecifiedDueDateAndGroupAndName(to.plusDays(1), "Jedi Knights", "After end date");
        this.createTaskWithSpecifiedDueDateAndUserAndName(to.plusDays(300), "Bobba Fet", "After end date 2 ");
        this.createTasksWithSpecifiedDueDateAndUserAndName(firstDay, "Darth Vader", "Correct day, but different owner", 10);
        this.createTasksWithSpecifiedDueDateAndUserAndName(secondDay, "Yoda", "Correct day, but different owner", 5);
        this.createTasksWithSpecifiedDueDateAndUserAndName(thirdDay, "Anakin", "Correct day, but different owner", 5);
        this.createTasksWithSpecifiedDueDateAndUserAndName(fourthDay, "Darth Maul", "Correct day, but different owner", 10);
        this.createTasksWithSpecifiedDueDateAndUserAndName(fifthDay, "Darth Maul", "Correct day, but different owner", 5);
        this.createTasksWithSpecifiedDueDateAndGroupAndName(firstDay, "Jedi Knights", "Correct day, but different group", 10);
        this.createTasksWithSpecifiedDueDateAndGroupAndName(secondDay, "Jedi Knights", "Correct day, but different group", 10);
        this.createTasksWithSpecifiedDueDateAndGroupAndName(fifthDay, "Sith Lords", "Correct day, but different group", 10);
        this.createTaskWithNoDueDateAndUserAndName("Bobba Fet", "No due date");
        this.createTaskWithNoDueDateAndGroupAndName("Bounty Hunters", "No due date 2 ");
        this.createTasksWithSpecifiedDueDateAndUserAndName(firstDay, "Bobba Fet", "First day task", nrOfTasksForFirstDay / 2);
        this.createTasksWithSpecifiedDueDateAndGroupAndName(firstDay, "Bounty Hunters", "1st group task", nrOfTasksForFirstDay / 2);
        this.createTasksWithSpecifiedDueDateAndUserAndName(secondDay, "Bobba Fet", "Second day task", nrOfTasksForSecondDay / 2);
        this.createTasksWithSpecifiedDueDateAndGroupAndName(secondDay, "Bounty Hunters", "2nd gr task", nrOfTasksForSecondDay / 2);
        this.createTasksWithSpecifiedDueDateAndUserAndName(thirdDay, "Bobba Fet", "Third day task", nrOfTasksForThirdDay / 2);
        this.createTasksWithSpecifiedDueDateAndGroupAndName(thirdDay, "Star Wars", "3rd day group task", nrOfTasksForThirdDay / 2);
        this.createTasksWithSpecifiedDueDateAndUserAndName(fourthDay, "Bobba Fet", "Fourth day task", nrOfTasksForFourthDay / 2);
        this.createTasksWithSpecifiedDueDateAndGroupAndName(fourthDay, "Star Wars", "4th day group task", nrOfTasksForFourthDay / 2);
        this.createTasksWithSpecifiedDueDateAndUserAndName(fifthDay, "Bobba Fet", "Fifth day task", nrOfTasksForFifthDay / 2);
        this.createTasksWithSpecifiedDueDateAndGroupAndName(fifthDay, "Bounty Hunters", "5th group task", nrOfTasksForFifthDay / 2);
        Map tasksByDays = this.consoleTaskService.getTasksAssignedAsPotentialOwnerFromDateToDateByDays("Bobba Fet", this.getTaskStatuses(), this.toJavaUtilDate(from), nrOfDaysTotal);
        Assert.assertEquals((long)nrOfDaysTotal, (long)tasksByDays.size());
        this.verifyCorrectTasksForSpecifiedDay(tasksByDays, firstDay, nrOfTasksForFirstDay);
        this.verifyCorrectTasksForSpecifiedDay(tasksByDays, secondDay, nrOfTasksForSecondDay);
        this.verifyCorrectTasksForSpecifiedDay(tasksByDays, thirdDay, nrOfTasksForThirdDay + nrOfTasksWithNoExpDate);
        this.verifyCorrectTasksForSpecifiedDay(tasksByDays, fourthDay, nrOfTasksForFourthDay);
        this.verifyCorrectTasksForSpecifiedDay(tasksByDays, fifthDay, nrOfTasksForFifthDay);
    }

    private void createTaskWithSpecifiedDueDateAndUserAndName(String date, String userId, String name) {
        String taskStr = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {";
        taskStr = taskStr + "expirationTime = new java.text.SimpleDateFormat(\"" + DEFAULT_DATE_FORMAT + "\").parse(\"" + date + "\") } ), ";
        taskStr = taskStr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('" + userId + "')], businessAdministrators = [ new User('Administrator') ], }),";
        taskStr = taskStr + "names = [ new I18NText( 'en-UK', '" + name + "')] })";
        this.createAndAddTaskFromString(taskStr);
    }

    private void createTaskWithSpecifiedDueDateAndUserAndName(LocalDate date, String userId, String name) {
        this.createTaskWithSpecifiedDueDateAndUserAndName(date.toString(DEFAULT_DATE_FORMAT), userId, name);
    }

    private void createTaskWithSpecifiedDueDateAndGroupAndName(String date, String groupId, String name) {
        String taskStr = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {";
        taskStr = taskStr + "expirationTime = new java.text.SimpleDateFormat(\"" + DEFAULT_DATE_FORMAT + "\").parse(\"" + date + "\") } ), ";
        taskStr = taskStr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new Group('" + groupId + "')], businessAdministrators = [ new User('Administrator') ], }),";
        taskStr = taskStr + "names = [ new I18NText( 'en-UK', '" + name + "')] })";
        this.createAndAddTaskFromString(taskStr);
    }

    private void createTaskWithSpecifiedDueDateAndGroupAndName(LocalDate date, String groupId, String name) {
        this.createTaskWithSpecifiedDueDateAndGroupAndName(date.toString(DEFAULT_DATE_FORMAT), groupId, name);
    }

    private void createTaskWithNoDueDateAndUserAndName(String user, String name) {
        String taskStr = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {";
        taskStr = taskStr + "expirationTime = null } ), ";
        taskStr = taskStr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new User('" + user + "')], businessAdministrators = [ new User('Administrator') ], }),";
        taskStr = taskStr + "names = [ new I18NText( 'en-UK', '" + name + "')] })";
        this.createAndAddTaskFromString(taskStr);
    }

    private void createTasksWithSpecifiedDueDateAndUserAndName(LocalDate day, String userId, String taskName, int nrOfTasksToCreate) {
        for (int i = 0; i < nrOfTasksToCreate; ++i) {
            this.createTaskWithSpecifiedDueDateAndUserAndName(day, userId, taskName + i);
        }
    }

    private void createTasksWithSpecifiedDueDateAndGroupAndName(LocalDate day, String groupId, String taskName, int nrOfTasksToCreate) {
        for (int i = 0; i < nrOfTasksToCreate; ++i) {
            this.createTaskWithSpecifiedDueDateAndGroupAndName(day, groupId, taskName + i);
        }
    }

    private void createTaskWithNoDueDateAndGroupAndName(String groupId, String name) {
        String taskStr = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) {";
        taskStr = taskStr + "expirationTime = null } ), ";
        taskStr = taskStr + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [new Group('" + groupId + "')], businessAdministrators = [ new User('Administrator') ], }),";
        taskStr = taskStr + "names = [ new I18NText( 'en-UK', '" + name + "')] })";
        this.createAndAddTaskFromString(taskStr);
    }

    protected void createAndAddTaskFromString(String taskStr) {
        Task task = TaskFactory.evalTask((Reader)new StringReader(taskStr));
        this.taskService.addTask(task, new HashMap());
    }

    private boolean sameDays(Date date, LocalDate localDate) {
        return localDate.equals((Object)new LocalDate((Object)date));
    }

    private Date toJavaUtilDate(LocalDate localDate) {
        return localDate.toDateMidnight().toDate();
    }

    private List<String> getTaskStatuses() {
        ArrayList<String> statuses = new ArrayList<String>();
        statuses.add("InProgress");
        statuses.add("Ready");
        statuses.add("Reserved");
        statuses.add("Created");
        return statuses;
    }

    private List<String> getStatusesForGroupTasksOnly() {
        ArrayList<String> statuses = new ArrayList<String>();
        statuses.add("Ready");
        return statuses;
    }

    private void verifyNoTasksPresent(Map<Day, List<TaskSummary>> tasksByDays) {
        for (Map.Entry<Day, List<TaskSummary>> entry : tasksByDays.entrySet()) {
            Assert.assertEquals((long)0L, (long)entry.getValue().size());
        }
    }

    private void verifyCorrectTasksForSpecifiedDay(Map<Day, List<TaskSummary>> tasksByDays, LocalDate day, int nrOfTasks) {
        for (Map.Entry<Day, List<TaskSummary>> entry : tasksByDays.entrySet()) {
            Date date = entry.getKey().getDate();
            List<TaskSummary> tasks = entry.getValue();
            if (!this.sameDays(date, day)) continue;
            Assert.assertEquals((long)nrOfTasks, (long)tasks.size());
            this.checkTasksHaveExpectedExpirationDate(date, tasks);
            return;
        }
        Assert.fail((String)("Specified date " + day + " not found in days Map!"));
    }

    protected void checkTasksHaveExpectedExpirationDate(Date expectedDate, List<TaskSummary> tasks) {
        for (TaskSummary task : tasks) {
            if (task.getExpirationTime() == null) continue;
            Assert.assertEquals((Object)expectedDate, (Object)task.getExpirationTime());
        }
    }
}

