/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.backend.server;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.ga.model.QueryFilter;
import org.jbpm.console.ng.ht.backend.server.TaskSummaryHelper;
import org.jbpm.console.ng.ht.model.Day;
import org.jbpm.console.ng.ht.model.TaskKey;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.model.TasksPerDaySummary;
import org.jbpm.console.ng.ht.service.TaskCalendarService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.task.query.QueryFilterImpl;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.kie.api.task.model.Status;
import org.uberfire.paging.PageResponse;

@Service
@ApplicationScoped
public class TaskCalendarServiceImpl
implements TaskCalendarService {
    @Inject
    private RuntimeDataService runtimeDataService;

    public PageResponse<TasksPerDaySummary> getData(QueryFilter filter) {
        PageResponse response = new PageResponse();
        List statusesString = null;
        String userId = "";
        Date dateFrom = null;
        Date dateTo = null;
        boolean ownedFilter = false;
        if (filter.getParams() != null) {
            userId = (String)filter.getParams().get("userId");
            statusesString = (List)filter.getParams().get("statuses");
            dateFrom = (Date)filter.getParams().get("dateFrom");
            dateTo = (Date)filter.getParams().get("dateTo");
            ownedFilter = (Boolean)filter.getParams().get("ownedFilter");
        }
        ArrayList<Status> statuses = new ArrayList<Status>();
        for (String s : statusesString) {
            statuses.add(Status.valueOf((String)s));
        }
        QueryFilterImpl qf = new QueryFilterImpl(filter.getOffset().intValue(), filter.getCount() + 1);
        List<TaskSummary> taskSummaries = null;
        taskSummaries = !ownedFilter ? TaskSummaryHelper.adaptCollection(this.runtimeDataService.getTasksAssignedAsPotentialOwner(userId, null, statuses, (org.kie.internal.query.QueryFilter)qf)) : TaskSummaryHelper.adaptCollection(this.runtimeDataService.getTasksOwnedByStatus(userId, statuses, (org.kie.internal.query.QueryFilter)qf));
        LocalDate dayFrom = new LocalDate((Object)dateFrom);
        LocalDate dayTo = new LocalDate((Object)dateTo);
        LocalDate today = new LocalDate();
        int nrOfDaysTotal = this.getNumberOfDaysWithinDateRange(dayFrom, dayTo);
        List<TasksPerDaySummary> tasksPerDay = this.createTasksPerDayHolder(dayFrom, nrOfDaysTotal);
        this.fillTasksPerDay(tasksPerDay, taskSummaries, today);
        response.setStartRowIndex(filter.getOffset().intValue());
        response.setTotalRowSize(taskSummaries.size() - 1);
        if (taskSummaries.size() > filter.getCount()) {
            response.setTotalRowSizeExact(false);
        } else {
            response.setTotalRowSizeExact(true);
        }
        if (!taskSummaries.isEmpty() && taskSummaries.size() > filter.getCount() + filter.getOffset()) {
            response.setPageRowList(tasksPerDay);
            response.setLastPage(false);
        } else {
            response.setPageRowList(tasksPerDay);
            response.setLastPage(true);
        }
        return response;
    }

    private int getNumberOfDaysWithinDateRange(LocalDate dayFrom, LocalDate dayTo) {
        Days daysBetween = Days.daysBetween((ReadablePartial)dayFrom, (ReadablePartial)dayTo);
        return daysBetween.getDays() + 1;
    }

    private List<TasksPerDaySummary> createTasksPerDayHolder(LocalDate dayFrom, int nrOfDaysTotal) {
        ArrayList<TasksPerDaySummary> tasksPerDay = new ArrayList<TasksPerDaySummary>();
        for (int i = 0; i < nrOfDaysTotal; ++i) {
            tasksPerDay.add(new TasksPerDaySummary(this.transformLocalDateToDay(dayFrom.plusDays(i)), new ArrayList()));
        }
        return tasksPerDay;
    }

    private void fillTasksPerDay(List<TasksPerDaySummary> tasksPerDay, List<TaskSummary> taskSummaries, LocalDate today) {
        for (TaskSummary taskSummary : taskSummaries) {
            LocalDate expDate = taskSummary.getExpirationTime() == null ? today : new LocalDate((Object)taskSummary.getExpirationTime());
            for (TasksPerDaySummary tpds : tasksPerDay) {
                if (!tpds.getDay().equals((Object)this.transformLocalDateToDay(expDate))) continue;
                tpds.getTasks().add(taskSummary);
            }
        }
    }

    private Day transformLocalDateToDay(LocalDate localDate) {
        SimpleDateFormat dayFormat = new SimpleDateFormat("EEEE dd");
        Date dayDate = localDate.toDateTimeAtStartOfDay().toDate();
        return new Day(dayDate, dayFormat.format(dayDate));
    }

    public TasksPerDaySummary getItem(TaskKey key) {
        return null;
    }
}

